/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;

public class SpyConnectionConsumer
implements ConnectionConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpyConnectionConsumer == null ? (class$org$jboss$mq$SpyConnectionConsumer = SpyConnectionConsumer.class$("org.jboss.mq.SpyConnectionConsumer")) : class$org$jboss$mq$SpyConnectionConsumer));
    Connection connection;
    Destination destination;
    ServerSessionPool serverSessionPool;
    int maxMessages;
    LinkedList queue = new LinkedList();
    boolean closed = false;
    boolean waitingForMessage = false;
    Subscription subscription = new Subscription();
    Thread internalThread;
    static /* synthetic */ Class class$org$jboss$mq$SpyConnectionConsumer;

    public SpyConnectionConsumer(Connection connection, Destination destination, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this.connection = connection;
        this.destination = destination;
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = maxMessages;
        if (this.maxMessages < 1) {
            this.maxMessages = 1;
        }
        this.subscription.destination = (SpyDestination)destination;
        this.subscription.messageSelector = messageSelector;
        this.subscription.noLocal = false;
        connection.addConsumer(this);
        this.internalThread = new Thread((Runnable)this, "Connection Consumer for dest " + destination);
        this.internalThread.start();
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SpyMessage mes) throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("" + this + "->addMessage(mes=" + mes + ")"));
        }
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.closed) {
                log.warn((Object)"NACK issued. The connection consumer was closed.");
                this.connection.send(mes.getAcknowledgementRequest(false));
                return;
            }
            if (this.waitingForMessage) {
                this.queue.addLast(mes);
                this.queue.notifyAll();
            } else {
                this.connection.send(mes.getAcknowledgementRequest(false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.queue.notifyAll();
        }
        if (this.internalThread != null && !this.internalThread.equals(Thread.currentThread())) {
            try {
                this.internalThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        LinkedList linkedList2 = this.queue;
        synchronized (linkedList2) {
            while (!this.queue.isEmpty()) {
                SpyMessage message = (SpyMessage)this.queue.removeFirst();
                this.connection.send(message.getAcknowledgementRequest(false));
            }
            this.connection.removeConsumer(this);
        }
    }

    public String toString() {
        return "SpyConnectionConsumer:" + this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<SpyMessage> mesList = new ArrayList<SpyMessage>();
        try {
            boolean trace = log.isTraceEnabled();
            while (true) {
                SpyMessage mes;
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    if (this.closed) {
                        break;
                    }
                }
                int i = 0;
                while (i < this.maxMessages) {
                    mes = this.connection.receive(this.subscription, -1L);
                    if (mes == null) break;
                    mesList.add(mes);
                    ++i;
                }
                if (mesList.isEmpty()) {
                    mes = null;
                    LinkedList linkedList2 = this.queue;
                    synchronized (linkedList2) {
                        mes = this.connection.receive(this.subscription, 0L);
                        if (mes == null) {
                            this.waitingForMessage = true;
                            while (this.queue.isEmpty() && !this.closed) {
                                try {
                                    this.queue.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            if (this.closed) {
                                this.waitingForMessage = false;
                                break;
                            }
                            mes = (SpyMessage)this.queue.removeFirst();
                            this.waitingForMessage = false;
                        }
                    }
                    mesList.add(mes);
                }
                ServerSession serverSession = this.serverSessionPool.getServerSession();
                SpySession spySession = (SpySession)serverSession.getSession();
                if (spySession.sessionConsumer == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("" + this + " Session did not have a set MessageListner"));
                    }
                } else {
                    spySession.sessionConsumer.subscription = this.subscription;
                }
                int i2 = 0;
                while (i2 < mesList.size()) {
                    spySession.addMessage((SpyMessage)mesList.get(i2));
                    ++i2;
                }
                if (trace) {
                    log.trace((Object)("" + this + " Starting the ServerSession."));
                }
                serverSession.start();
                mesList.clear();
            }
        }
        catch (JMSException e) {
            log.warn((Object)"Connection consumer closing due to error in listening thread.", (Throwable)e);
            try {
                int i = 0;
                while (i < mesList.size()) {
                    SpyMessage msg = (SpyMessage)mesList.get(i);
                    this.connection.send(msg.getAcknowledgementRequest(false));
                    ++i;
                }
                this.close();
            }
            catch (Exception ignore) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

