/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyQueueSession;
import org.jboss.mq.selectors.Selector;

public class SpyQueueBrowser
implements QueueBrowser {
    boolean closed;
    Queue destination;
    String messageSelector;
    SpyQueueSession session;

    SpyQueueBrowser(SpyQueueSession session, Queue destination, String messageSelector) throws InvalidSelectorException {
        this.destination = destination;
        this.session = session;
        this.messageSelector = messageSelector;
        if (messageSelector != null) {
            new Selector(messageSelector);
        }
    }

    public Queue getQueue() throws JMSException {
        return this.destination;
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this.closed) {
            throw new JMSException("The QueueBrowser was closed");
        }
        final SpyMessage[] data = this.session.connection.browse(this.destination, this.messageSelector);
        return new Enumeration(){
            int i = 0;

            public boolean hasMoreElements() {
                return this.i < data.length;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return data[this.i++];
            }
        };
    }

    public void close() throws JMSException {
        this.closed = true;
    }
}

