/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageProducer;
import org.jboss.mq.SpyQueueSession;

public class SpyQueueSender
extends SpyMessageProducer
implements QueueSender {
    private SpyQueueSession session;
    private Queue queue;

    SpyQueueSender(SpyQueueSession session, Queue queue) {
        block3: {
            this.queue = null;
            this.session = session;
            this.queue = queue;
            try {
                if (queue instanceof TemporaryQueue) {
                    this.setDeliveryMode(1);
                    break block3;
                }
                this.setDeliveryMode(2);
            }
            catch (JMSException e) {}
        }
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public void send(Message message) throws JMSException {
        if (this.queue == null) {
            throw new UnsupportedOperationException("Not constructed with identifyed queue. Usage of method not allowed");
        }
        this.internalSend(this.queue, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.queue == null) {
            throw new UnsupportedOperationException("Not constructed with identifyed queue. Usage of method not allowed");
        }
        this.internalSend(this.queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (this.queue != null && !this.queue.equals(queue)) {
            throw new UnsupportedOperationException("Sending to unidentifyed queue not allowed when sender created with an identifyed queue");
        }
        this.internalSend(queue, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.queue != null && !this.queue.equals(queue)) {
            throw new UnsupportedOperationException("Sending to unidentifyed queue not allowed when sender created with an identifyed queue");
        }
        this.internalSend(queue, message, deliveryMode, priority, timeToLive);
    }

    public void internalSend(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination((Destination)queue);
        message.setJMSDeliveryMode(deliveryMode);
        long ts = System.currentTimeMillis();
        message.setJMSTimestamp(ts);
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(timeToLive + ts);
        }
        message.setJMSPriority(priority);
        message.setJMSMessageID(this.session.getNewMessageID());
        if (!(message instanceof SpyMessage)) {
            SpyEncapsulatedMessage m = MessagePool.getEncapsulatedMessage();
            m.setMessage(message);
            message = m;
        }
        this.session.sendMessage((SpyMessage)message);
    }
}

