/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageProducer;
import org.jboss.mq.SpyTopicSession;

public class SpyTopicPublisher
extends SpyMessageProducer
implements TopicPublisher {
    private SpyTopicSession mySession;
    private Topic myTopic;

    SpyTopicPublisher(SpyTopicSession s, Topic t) {
        block3: {
            this.myTopic = null;
            this.mySession = s;
            this.myTopic = t;
            try {
                if (t instanceof TemporaryTopic) {
                    this.setDeliveryMode(1);
                    break block3;
                }
                this.setDeliveryMode(2);
            }
            catch (JMSException e) {}
        }
    }

    public Topic getTopic() throws JMSException {
        return this.myTopic;
    }

    public void publish(Message message) throws JMSException {
        if (this.myTopic == null) {
            throw new UnsupportedOperationException("Not constructed with identifyed topic. Usage of method not allowed");
        }
        this.internalPublish(this.myTopic, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.myTopic == null) {
            throw new UnsupportedOperationException("Not constructed with identifyed topic. Usage of method not allowed");
        }
        this.internalPublish(this.myTopic, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (this.myTopic != null && !this.myTopic.equals(topic)) {
            throw new UnsupportedOperationException("Publishing to unidentifyed topic not allowed when publisher created with an identifyed topic");
        }
        this.internalPublish(topic, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.myTopic != null && !this.myTopic.equals(topic)) {
            throw new UnsupportedOperationException("Publishing to unidentifyed topic not allowed when publisher created with an identifyed topic");
        }
        this.internalPublish(topic, message, deliveryMode, priority, timeToLive);
    }

    protected void internalPublish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination((Destination)topic);
        message.setJMSDeliveryMode(deliveryMode);
        long ts = System.currentTimeMillis();
        message.setJMSTimestamp(ts);
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(timeToLive + ts);
        }
        message.setJMSPriority(priority);
        message.setJMSMessageID(this.mySession.getNewMessageID());
        if (!(message instanceof SpyMessage)) {
            SpyEncapsulatedMessage m = MessagePool.getEncapsulatedMessage();
            m.setMessage(message);
            message = m;
        }
        this.mySession.sendMessage((SpyMessage)message);
    }
}

