/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.selectors.Selector;

public class Subscription
implements Serializable {
    private static final long serialVersionID = -4045603824932803577L;
    public int subscriptionId;
    public SpyDestination destination;
    public String messageSelector;
    public boolean destroyDurableSubscription;
    public boolean noLocal;
    public transient Selector selector;
    public transient ConnectionToken connectionToken;
    public transient Object clientConsumer;

    public Selector getSelector() throws InvalidSelectorException {
        if (this.messageSelector == null || this.messageSelector.trim().length() == 0) {
            return null;
        }
        if (this.selector == null) {
            this.selector = new Selector(this.messageSelector);
        }
        return this.selector;
    }

    public boolean accepts(SpyMessage.Header header) throws JMSException {
        if (header.jmsDestination instanceof SpyTopic && this.noLocal && header.producerClientId.equals(this.connectionToken.getClientID())) {
            return false;
        }
        Selector ms = this.getSelector();
        return ms == null || ms.test(header);
    }

    public Subscription myClone() {
        Subscription result = new Subscription();
        result.subscriptionId = this.subscriptionId;
        result.destination = this.destination;
        result.messageSelector = this.messageSelector;
        result.destroyDurableSubscription = this.destroyDurableSubscription;
        result.noLocal = this.noLocal;
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append("{");
        if (this.connectionToken != null) {
            buffer.append("connection=").append(this.connectionToken);
        }
        buffer.append(" subscriptionId=").append(this.subscriptionId);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" messageSelector=").append(this.messageSelector);
        if (this.noLocal) {
            buffer.append(" NoLocal");
        } else {
            buffer.append(" Local");
        }
        if (this.destroyDurableSubscription) {
            buffer.append(" Destroy");
        } else {
            buffer.append(" Create");
        }
        buffer.append("}");
        return buffer.toString();
    }
}

