/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.mq.il.http.AnyhostVerifier;
import org.jboss.mq.il.http.HTTPILRequest;
import org.jboss.mq.il.http.HTTPILResponse;
import org.jboss.security.SecurityAssociationAuthenticator;

public class HTTPClient {
    private static final String CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.mq.il.http.HTTPILRequest";
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$http$HTTPClient == null ? (class$org$jboss$mq$il$http$HTTPClient = HTTPClient.class$("org.jboss.mq.il.http.HTTPClient")) : class$org$jboss$mq$il$http$HTTPClient));
    static /* synthetic */ Class class$org$jboss$mq$il$http$HTTPClient;

    public static Object post(URL url, HTTPILRequest request) throws Exception {
        HttpURLConnection connection;
        if (log.isTraceEnabled()) {
            log.trace((Object)("post(URL " + url.toString() + ", HTTPILRequest " + request.toString() + ")"));
        }
        if ((connection = (HttpURLConnection)url.openConnection()) instanceof HttpsURLConnection && Boolean.getBoolean("org.jboss.security.ignoreHttpsHost")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using the AnyhostVerifier");
            }
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            AnyhostVerifier verifier = new AnyhostVerifier();
            httpsConnection.setHostnameVerifier((HostnameVerifier)verifier);
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("ContentType", CONTENT_TYPE);
        connection.setRequestMethod("POST");
        ObjectOutputStream outputStream = new ObjectOutputStream(connection.getOutputStream());
        outputStream.writeObject(request);
        outputStream.close();
        ObjectInputStream inputStream = new ObjectInputStream(connection.getInputStream());
        HTTPILResponse response = (HTTPILResponse)inputStream.readObject();
        inputStream.close();
        Object responseValue = response.getValue();
        if (responseValue instanceof Exception) {
            throw (Exception)responseValue;
        }
        return responseValue;
    }

    public static URL resolveServerUrl(String url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("URL is null.");
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException exception) {
            String propertyValue = System.getProperty(url);
            if (propertyValue == null) {
                throw exception;
            }
            return new URL(propertyValue);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Authenticator.setDefault((Authenticator)new SecurityAssociationAuthenticator());
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to install SecurityAssociationAuthenticator", (Throwable)exception);
        }
    }
}

