/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;

public class OIL2Request
implements Externalizable {
    private static int lastRequestId = 0;
    private static Object lastRequestIdLock = new Object();
    public Integer requestId;
    public byte operation;
    public Object[] arguments;

    public OIL2Request() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIL2Request(byte operation, Object[] arguments) {
        Object object = lastRequestIdLock;
        synchronized (object) {
            this.requestId = new Integer(lastRequestId++);
        }
        this.operation = operation;
        this.arguments = arguments;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.operation);
        out.writeInt(this.requestId);
        switch (this.operation) {
            case -1: {
                ReceiveRequest[] messages = (ReceiveRequest[])this.arguments[0];
                out.writeInt(messages.length);
                int i = 0;
                while (i < messages.length) {
                    messages[i].writeExternal(out);
                    ++i;
                }
                break;
            }
            case -2: {
                out.writeObject(this.arguments[0]);
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                out.writeLong((Long)this.arguments[0]);
                break;
            }
            case 14: {
                out.writeObject(this.arguments[0]);
                break;
            }
            case 1: {
                ((AcknowledgementRequest)this.arguments[0]).writeExternal(out);
                break;
            }
            case 2: {
                SpyMessage.writeMessage((SpyMessage)this.arguments[0], out);
                break;
            }
            case 3: {
                out.writeObject(this.arguments[0]);
                OIL2Request.writeString(out, (String)this.arguments[1]);
                break;
            }
            case 4: {
                OIL2Request.writeString(out, (String)this.arguments[0]);
                break;
            }
            case 5: {
                this.arguments = null;
                break;
            }
            case 6: {
                OIL2Request.writeString(out, (String)this.arguments[0]);
                break;
            }
            case 7: {
                OIL2Request.writeString(out, (String)this.arguments[0]);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                out.writeObject(this.arguments[0]);
                break;
            }
            case 12: {
                out.writeInt((Integer)this.arguments[0]);
                out.writeLong((Long)this.arguments[1]);
                break;
            }
            case 13: {
                out.writeBoolean((Boolean)this.arguments[0]);
                break;
            }
            case 15: {
                out.writeObject(this.arguments[0]);
                break;
            }
            case 16: {
                ((TransactionRequest)this.arguments[0]).writeExternal(out);
                break;
            }
            case 17: {
                out.writeInt((Integer)this.arguments[0]);
                break;
            }
            case 18: {
                out.writeObject(this.arguments[0]);
                break;
            }
            case 19: {
                OIL2Request.writeString(out, (String)this.arguments[0]);
                OIL2Request.writeString(out, (String)this.arguments[1]);
                break;
            }
            case 20: {
                out.writeLong((Long)this.arguments[0]);
                break;
            }
            case 22: {
                OIL2Request.writeString(out, (String)this.arguments[0]);
                OIL2Request.writeString(out, (String)this.arguments[1]);
                break;
            }
            default: {
                throw new IOException("Protocol Error: Bad operation code.");
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = in.readByte();
        this.requestId = new Integer(in.readInt());
        switch (this.operation) {
            case -1: {
                int numReceives = in.readInt();
                ReceiveRequest[] messages = new ReceiveRequest[numReceives];
                int i = 0;
                while (i < numReceives) {
                    messages[i] = new ReceiveRequest();
                    messages[i].readExternal(in);
                    ++i;
                }
                this.arguments = new Object[]{messages};
                break;
            }
            case -2: {
                this.arguments = new Object[]{in.readObject()};
                break;
            }
            case -3: {
                this.arguments = null;
                break;
            }
            case -4: {
                this.arguments = new Object[]{new Long(in.readLong())};
                break;
            }
            case 14: {
                this.arguments = new Object[]{in.readObject()};
                break;
            }
            case 1: {
                AcknowledgementRequest ack = new AcknowledgementRequest();
                ack.readExternal(in);
                this.arguments = new Object[]{ack};
                break;
            }
            case 2: {
                this.arguments = new Object[]{SpyMessage.readMessage(in)};
                break;
            }
            case 3: {
                this.arguments = new Object[]{in.readObject(), OIL2Request.readString(in)};
                break;
            }
            case 4: {
                this.arguments = new Object[]{OIL2Request.readString(in)};
                break;
            }
            case 5: {
                this.arguments = null;
                break;
            }
            case 6: {
                this.arguments = new Object[]{OIL2Request.readString(in)};
                break;
            }
            case 7: {
                this.arguments = new Object[]{OIL2Request.readString(in)};
                break;
            }
            case 9: {
                this.arguments = null;
                break;
            }
            case 10: {
                this.arguments = null;
                break;
            }
            case 11: {
                this.arguments = null;
                break;
            }
            case 8: {
                this.arguments = new Object[]{in.readObject()};
                break;
            }
            case 12: {
                this.arguments = new Object[]{new Integer(in.readInt()), new Long(in.readLong())};
                break;
            }
            case 13: {
                this.arguments = new Object[]{new Boolean(in.readBoolean())};
                break;
            }
            case 15: {
                this.arguments = new Object[]{in.readObject()};
                break;
            }
            case 16: {
                TransactionRequest trans = new TransactionRequest();
                trans.readExternal(in);
                this.arguments = new Object[]{trans};
                break;
            }
            case 17: {
                this.arguments = new Object[]{new Integer(in.readInt())};
                break;
            }
            case 18: {
                this.arguments = new Object[]{in.readObject()};
                break;
            }
            case 19: {
                this.arguments = new Object[]{OIL2Request.readString(in), OIL2Request.readString(in)};
                break;
            }
            case 20: {
                this.arguments = new Object[]{new Long(in.readLong())};
                break;
            }
            case 22: {
                this.arguments = new Object[]{OIL2Request.readString(in), OIL2Request.readString(in)};
                break;
            }
            default: {
                throw new IOException("Protocol Error: Bad operation code.");
            }
        }
    }

    private static void writeString(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    private static String readString(ObjectInput in) throws IOException {
        byte b = in.readByte();
        if (b == 0) {
            return null;
        }
        return in.readUTF();
    }

    public String toString() {
        return "[operation:" + this.operation + "," + "requestId:" + this.requestId + ",arguments:" + this.arguments + "]";
    }
}

