/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.Slot;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.logging.Logger;
import org.jboss.mq.il.oil2.OIL2Request;
import org.jboss.mq.il.oil2.OIL2RequestListner;
import org.jboss.mq.il.oil2.OIL2Response;

public final class OIL2SocketHandler
implements Cloneable,
Runnable {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$oil2$OIL2SocketHandler == null ? (class$org$jboss$mq$il$oil2$OIL2SocketHandler = OIL2SocketHandler.class$("org.jboss.mq.il.oil2.OIL2SocketHandler")) : class$org$jboss$mq$il$oil2$OIL2SocketHandler));
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private boolean running;
    private final ThreadGroup partentThreadGroup;
    private Thread worker;
    private static int threadNumber = 0;
    private static final int STATE_CREATED = 0;
    private static final int STATE_CONNECTED = 1;
    private static final int STATE_DISCONNECTED = 2;
    private static final int STATE_CONNECTION_ERROR = 3;
    private int state = 0;
    volatile ConcurrentHashMap responseSlots = new ConcurrentHashMap();
    OIL2RequestListner requestListner;
    private volatile boolean pumpingData = false;
    private Object pumpMutex = new Object();
    LinkedQueue requestQueue = new LinkedQueue();
    PooledExecutor pool;
    static /* synthetic */ Class class$org$jboss$mq$il$oil2$OIL2SocketHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIL2SocketHandler(ObjectInputStream in, ObjectOutputStream out, ThreadGroup partentThreadGroup) {
        this.in = in;
        this.out = out;
        this.partentThreadGroup = partentThreadGroup;
        Class clazz = class$org$jboss$mq$il$oil2$OIL2SocketHandler == null ? (class$org$jboss$mq$il$oil2$OIL2SocketHandler = OIL2SocketHandler.class$("org.jboss.mq.il.oil2.OIL2SocketHandler")) : class$org$jboss$mq$il$oil2$OIL2SocketHandler;
        synchronized (clazz) {
            if (this.pool == null) {
                this.pool = new PooledExecutor(50);
                log.debug((Object)"Setting the OIL2SocketHandler's thread factory");
                this.pool.setThreadFactory(new ThreadFactory(){
                    private int threadNo = 0;

                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(OIL2SocketHandler.this.partentThreadGroup, r, "OIL2SocketHandler Thread-" + this.threadNo++);
                        t.setDaemon(true);
                        return t;
                    }
                });
                this.pool.setMinimumPoolSize(1);
                this.pool.setKeepAliveTime(60000L);
                this.pool.runWhenBlocked();
                this.pool.createThreads(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(OIL2Request request) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeByte(1);
                request.writeExternal(this.out);
                this.out.reset();
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.state = 3;
            throw e;
        }
    }

    private void registerResponseSlot(OIL2Request request, Slot responseSlot) throws IOException {
        this.responseSlots.put((Object)request.requestId, (Object)responseSlot);
    }

    public void setRequestListner(OIL2RequestListner requestListner) {
        this.requestListner = requestListner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(OIL2Response response) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeByte(2);
                response.writeExternal(this.out);
                this.out.reset();
                this.out.flush();
            }
        }
        catch (IOException e) {
            this.state = 3;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Object pumpMessages(OIL2Request request, Channel mySlot) throws IOException, ClassNotFoundException, InterruptedException {
        Object object = this.pumpMutex;
        // MONITORENTER : object
        if (this.pumpingData) {
            // MONITOREXIT : object
            return null;
        }
        this.pumpingData = true;
        // MONITOREXIT : object
        try {
            while (true) {
                if (mySlot != null) {
                    Object o;
                    while ((o = mySlot.peek()) != null) {
                        o = mySlot.take();
                        if (o == this) continue;
                        Object object2 = o;
                        return object2;
                    }
                }
                byte code = this.in.readByte();
                boolean tracing = log.isTraceEnabled();
                switch (code) {
                    case 1: {
                        OIL2Request newRequest = new OIL2Request();
                        newRequest.readExternal(this.in);
                        if (request == null) {
                            OIL2Request thread = newRequest;
                            return thread;
                        }
                        this.requestQueue.put((Object)newRequest);
                        break;
                    }
                    case 2: {
                        OIL2Response response = new OIL2Response();
                        response.readExternal(this.in);
                        if (response.correlationRequestId == null) break;
                        if (request != null && request.requestId.equals(response.correlationRequestId)) {
                            OIL2Response interrupted = response;
                            return interrupted;
                        }
                        Slot slot = (Slot)this.responseSlots.remove((Object)response.correlationRequestId);
                        if (slot != null) {
                            slot.put((Object)response);
                            break;
                        }
                        if (!log.isTraceEnabled()) break;
                        log.warn((Object)("No slot registered for: " + response));
                        break;
                    }
                }
            }
        }
        finally {
            Object object3 = this.pumpMutex;
        }
    }

    public OIL2Response synchRequest(OIL2Request request) throws IOException, InterruptedException, ClassNotFoundException {
        Slot slot = new Slot();
        this.registerResponseSlot(request, slot);
        this.sendRequest(request);
        Object o = null;
        while (true) {
            if (o != null) {
                if (o != this) {
                    return (OIL2Response)o;
                }
                o = slot.peek();
                if (o == null) continue;
                o = slot.take();
                continue;
            }
            o = this.pumpMessages(request, (Channel)slot);
            if (o != null) continue;
            o = slot.take();
        }
    }

    public void run() {
        boolean code = false;
        try {
            Object o = null;
            while (this.running) {
                if (o != null) {
                    if (o != this) {
                        this.pool.execute((Runnable)new RequestRunner((OIL2Request)o));
                    }
                    if ((o = this.requestQueue.peek()) == null) continue;
                    o = this.requestQueue.take();
                    continue;
                }
                o = this.pumpMessages(null, (Channel)this.requestQueue);
                if (o != null) continue;
                o = this.requestQueue.take();
            }
        }
        catch (InterruptedException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Stopped due to interruption");
            }
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Stopping due to unexcpected exception: ", (Throwable)e);
            }
            this.state = 3;
            this.requestListner.handleConnectionException(e);
        }
        this.running = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stopped");
        }
    }

    public void start() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting");
        }
        this.running = true;
        this.worker = new Thread(this.partentThreadGroup, this, "OIL2 Worker-" + threadNumber++);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stopping");
        }
        this.running = false;
        this.worker.interrupt();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RequestRunner
    implements Runnable {
        OIL2Request request;

        RequestRunner(OIL2Request request) {
            this.request = request;
        }

        public void run() {
            OIL2SocketHandler.this.requestListner.handleRequest(this.request);
        }
    }
}

