/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.jboss.mq.il.uil.multiplexor.MuxOutputStream;

public class StreamMux {
    short frameSize = (short)512;
    HashMap openStreams = new HashMap();
    OutputStream out;
    DataOutputStream objectOut;
    static final byte OPEN_STREAM_COMMAND = 0;
    static final byte CLOSE_STREAM_COMMAND = 1;
    static final byte NEXT_FRAME_SHORT_COMMAND = 2;

    public StreamMux(OutputStream out) throws IOException {
        this.out = out;
        this.objectOut = new DataOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameSize(short newFrameSize) throws IOException {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            if (this.openStreams.size() > 0) {
                throw new IOException("Cannot change the frame size while there are open streams.");
            }
            this.frameSize = newFrameSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getFrameSize() {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            return this.frameSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getStream(short id) throws IOException {
        OutputStream s;
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            s = (OutputStream)this.openStreams.get(new Short(id));
            if (s != null) {
                return s;
            }
            s = new MuxOutputStream(this, id);
            this.openStreams.put(new Short(id), s);
        }
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            this.objectOut.writeShort(0);
            this.objectOut.writeByte(0);
            this.objectOut.writeShort(id);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            this.objectOut.flush();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStream(short id) throws IOException {
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            MuxOutputStream s = (MuxOutputStream)this.openStreams.remove(new Short(id));
        }
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            this.objectOut.writeShort(0);
            this.objectOut.writeByte(1);
            this.objectOut.writeShort(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(MuxOutputStream s, byte[] b, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len < 0 || len > b.length || len > this.frameSize) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        DataOutputStream dataOutputStream = this.objectOut;
        synchronized (dataOutputStream) {
            if (len < this.frameSize) {
                this.objectOut.writeShort(0);
                this.objectOut.writeByte(2);
                this.objectOut.writeShort(len);
            }
            this.objectOut.writeShort(s.streamId);
            this.objectOut.write(b, 0, len);
        }
    }
}

