/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.selectors;

import gnu.regexp.RE;
import gnu.regexp.RESyntax;

public class RegExp {
    protected RE re;

    public RegExp(String pattern, Character escapeChar) throws Exception {
        this.re = new RE((Object)this.adjustPattern(pattern, escapeChar), 0, RESyntax.RE_SYNTAX_POSIX_MINIMAL_BASIC);
    }

    public boolean isMatch(Object target) {
        return this.re.isMatch(target);
    }

    protected String adjustPattern(String pattern, Character escapeChar) throws Exception {
        int patternLen = pattern.length();
        StringBuffer REpattern = new StringBuffer(patternLen + 10);
        boolean useEscape = escapeChar != null;
        char escape = '\u0000';
        if (useEscape) {
            escape = escapeChar.charValue();
        }
        REpattern.append('^');
        int i = 0;
        while (i < patternLen) {
            boolean escaped = false;
            char c = pattern.charAt(i);
            if (useEscape && escape == c) {
                if (++i < patternLen) {
                    escaped = true;
                    c = pattern.charAt(i);
                } else {
                    throw new Exception("LIKE ESCAPE: Bad use of escape character");
                }
            }
            switch (c) {
                case '_': {
                    if (escaped) {
                        REpattern.append(c);
                        break;
                    }
                    REpattern.append('.');
                    break;
                }
                case '%': {
                    if (escaped) {
                        REpattern.append(c);
                        break;
                    }
                    REpattern.append(".*");
                    break;
                }
                case '$': 
                case '*': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    REpattern.append("\\");
                    REpattern.append(c);
                    break;
                }
                default: {
                    REpattern.append(c);
                }
            }
            ++i;
        }
        REpattern.append('$');
        return REpattern.toString();
    }
}

