/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.HashSet;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.jboss.mq.Connection;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnectionConsumer;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyQueueSession;
import org.jboss.mq.SpyTemporaryQueue;
import org.jboss.mq.SpyTemporaryTopic;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.SpyTopicSession;

public class SpyConnection
extends Connection
implements Serializable,
TopicConnection,
QueueConnection {
    public SpyConnection(String userId, String password, GenericConnectionFactory gcf) throws JMSException {
        super(userId, password, gcf);
    }

    public SpyConnection(GenericConnectionFactory gcf) throws JMSException {
        super(gcf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpyTopicSession session = new SpyTopicSession(this, transacted, acknowledgeMode);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Null topic");
        }
        this.checkClientID();
        return new SpyConnectionConsumer(this, (Destination)topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Null topic");
        }
        if (topic instanceof TemporaryTopic) {
            throw new InvalidDestinationException("Attempt to create a durable subscription for a temporary topic");
        }
        if (subscriptionName == null || subscriptionName.trim().length() == 0) {
            throw new JMSException("Null or empty subscription");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.getClientID(), subscriptionName, messageSelector);
        return new SpyConnectionConsumer(this, t, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Null queue");
        }
        return new SpyConnectionConsumer(this, (Destination)queue, messageSelector, sessionPool, maxMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpyQueueSession session = new SpyQueueSession(this, transacted, acknowledgeMode);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    TemporaryTopic getTemporaryTopic() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        try {
            SpyTemporaryTopic temp = (SpyTemporaryTopic)this.serverIL.getTemporaryTopic(this.connectionToken);
            temp.setConnection(this);
            return temp;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot create a Temporary Topic", e);
        }
    }

    TemporaryQueue getTemporaryQueue() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        try {
            SpyTemporaryQueue temp = (SpyTemporaryQueue)this.serverIL.getTemporaryQueue(this.connectionToken);
            temp.setConnection(this);
            return temp;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot create a Temporary Queue", e);
        }
    }

    Topic createTopic(String name) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("The connection is closed");
            }
            this.checkClientID();
            return this.serverIL.createTopic(this.connectionToken, name);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot get the Topic from the provider", e);
        }
    }

    Queue createQueue(String name) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("The connection is closed");
            }
            this.checkClientID();
            return this.serverIL.createQueue(this.connectionToken, name);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot get the Queue from the provider", e);
        }
    }
}

