/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.XAQueueSession;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyQueueBrowser;
import org.jboss.mq.SpyQueueReceiver;
import org.jboss.mq.SpyQueueSender;
import org.jboss.mq.SpySession;

public class SpyQueueSession
extends SpySession
implements QueueSession,
XAQueueSession {
    SpyQueueSession(Connection myConnection, boolean transacted, int acknowledgeMode) {
        this(myConnection, transacted, acknowledgeMode, false);
    }

    SpyQueueSession(Connection myConnection, boolean transacted, int acknowledgeMode, boolean xaSession) {
        super(myConnection, transacted, acknowledgeMode, xaSession);
    }

    public QueueSession getQueueSession() throws JMSException {
        return this;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Cannot browse a null queue.");
        }
        return new SpyQueueBrowser(this, queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Cannot browse a null queue.");
        }
        return new SpyQueueBrowser(this, queue, messageSelector);
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (queueName == null) {
            throw new InvalidDestinationException("Queue name cannot be null.");
        }
        return ((SpyConnection)this.connection).createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Queue cannot be null.");
        }
        SpyQueueReceiver receiver = new SpyQueueReceiver(this, queue, null);
        this.addConsumer(receiver);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Queue cannot be null.");
        }
        SpyQueueReceiver receiver = new SpyQueueReceiver(this, queue, messageSelector);
        this.addConsumer(receiver);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return new SpyQueueSender(this, queue);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return ((SpyConnection)this.connection).getTemporaryQueue();
    }
}

