/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageConsumer;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.mq.SpyXAResource;
import org.jboss.mq.SpyXAResourceManager;
import org.jboss.util.NullArgumentException;

public abstract class SpySession
implements Session,
XASession {
    public Connection connection;
    public boolean running;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected HashSet consumers;
    SpyMessageConsumer sessionConsumer;
    boolean closed;
    Object runLock = new Object();
    private Object currentTransactionId;
    SpyXAResource spyXAResource;
    LinkedList messages = new LinkedList();
    ArrayList unacknowledgedMessages = new ArrayList();
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpySession == null ? (class$org$jboss$mq$SpySession = SpySession.class$("org.jboss.mq.SpySession")) : class$org$jboss$mq$SpySession));
    static /* synthetic */ Class class$org$jboss$mq$SpySession;

    SpySession(Connection conn, boolean trans, int acknowledge, boolean xaSession) {
        this.connection = conn;
        this.transacted = trans;
        this.acknowledgeMode = acknowledge;
        if (xaSession) {
            this.spyXAResource = new SpyXAResource(this);
        }
        this.running = true;
        this.closed = false;
        this.consumers = new HashSet();
        if (this.spyXAResource == null && this.transacted) {
            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current transaction id: " + this.currentTransactionId));
            }
        }
    }

    void setCurrentTransactionId(Object xid) {
        if (xid == null) {
            throw new NullArgumentException("xid");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting current tx " + this + " xid=" + xid + " previous: " + this.currentTransactionId));
        }
        this.currentTransactionId = xid;
    }

    void unsetCurrentTransactionId(Object xid) {
        if (xid == null) {
            throw new NullArgumentException("xid");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unsetting current tx " + this + " xid=" + xid + " previous: " + this.currentTransactionId));
        }
        if (xid.equals(this.currentTransactionId)) {
            this.currentTransactionId = null;
        }
    }

    Object getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        this.sessionConsumer = new SpyMessageConsumer(this, true);
        this.sessionConsumer.setMessageListener(listener);
    }

    public boolean getTransacted() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.transacted;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (this.sessionConsumer == null) {
            return null;
        }
        return this.sessionConsumer.getMessageListener();
    }

    public XAResource getXAResource() {
        return this.spyXAResource;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyBytesMessage message = MessagePool.getBytesMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMapMessage message = MessagePool.getMapMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public Message createMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMessage message = MessagePool.getMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = MessagePool.getObjectMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = MessagePool.getObjectMessage();
        message.setObject(object);
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyStreamMessage message = MessagePool.getStreamMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = MessagePool.getTextMessage();
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            while (this.messages.size() > 0) {
                SpyMessage message = (SpyMessage)this.messages.removeFirst();
                try {
                    if (this.sessionConsumer == null) {
                        log.warn((Object)"Session has no message listener set, cannot process message.");
                        this.connection.send(message.getAcknowledgementRequest(false));
                        continue;
                    }
                    this.sessionConsumer.addMessage(message);
                }
                catch (JMSException ignore) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        JMSException exception;
        block19: {
            Iterator i;
            log.debug((Object)"Session closing.");
            Object object = this.runLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            exception = null;
            HashSet hashSet = this.consumers;
            synchronized (hashSet) {
                if (this.sessionConsumer != null) {
                    try {
                        this.sessionConsumer.close();
                    }
                    catch (InvalidDestinationException ignored) {
                        log.warn((Object)ignored.getMessage(), (Throwable)ignored);
                    }
                    catch (JMSException e) {
                        log.trace((Object)e.getMessage(), (Throwable)e);
                        exception = e;
                    }
                }
                i = this.consumers.iterator();
            }
            while (i.hasNext()) {
                SpyMessageConsumer messageConsumer = (SpyMessageConsumer)i.next();
                try {
                    messageConsumer.close();
                }
                catch (InvalidDestinationException ignored) {
                    log.warn((Object)ignored.getMessage(), (Throwable)ignored);
                }
                catch (JMSException e) {
                    log.trace((Object)e.getMessage(), (Throwable)e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
            try {
                if (this.spyXAResource != null) break block19;
                if (this.transacted) {
                    this.internalRollback();
                } else {
                    i = this.unacknowledgedMessages.iterator();
                    while (i.hasNext()) {
                        SpyMessage message = (SpyMessage)i.next();
                        this.connection.send(message.getAcknowledgementRequest(false));
                        i.remove();
                    }
                }
            }
            catch (JMSException e) {
                log.trace((Object)e.getMessage(), (Throwable)e);
                if (exception != null) break block19;
                exception = e;
            }
        }
        this.connection.sessionClosing(this);
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        Object object = this.runLock;
        synchronized (object) {
            if (this.spyXAResource != null) {
                throw new TransactionInProgressException("Should not be call from a XASession");
            }
            if (this.closed) {
                throw new IllegalStateException("The session is closed");
            }
            if (!this.transacted) {
                throw new IllegalStateException("The session is not transacted");
            }
            try {
                this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                this.connection.spyXAResourceManager.commit(this.currentTransactionId, true);
            }
            catch (XAException e) {
                throw new SpyJMSException("Could not commit", e);
            }
            finally {
                block17: {
                    this.unacknowledgedMessages.clear();
                    try {
                        this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Current transaction id: " + this.currentTransactionId));
                        }
                    }
                    catch (Exception ignore) {
                        if (!log.isTraceEnabled()) break block17;
                        log.trace((Object)"Failed to start tx", (Throwable)ignore);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        Object object = this.runLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("The session is closed");
            }
            this.internalRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRollback() throws JMSException {
        Object object = this.runLock;
        synchronized (object) {
            if (this.spyXAResource != null) {
                throw new TransactionInProgressException("Should not be call from a XASession");
            }
            if (!this.transacted) {
                throw new IllegalStateException("The session is not transacted");
            }
            try {
                this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                this.connection.spyXAResourceManager.rollback(this.currentTransactionId);
            }
            catch (XAException e) {
                throw new SpyJMSException("Could not rollback", e);
            }
            finally {
                block16: {
                    this.unacknowledgedMessages.clear();
                    try {
                        this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Current transaction id: " + this.currentTransactionId));
                        }
                    }
                    catch (Exception ignore) {
                        if (!log.isTraceEnabled()) break block16;
                        log.trace((Object)"Failed to start tx", (Throwable)ignore);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        Object object = this.runLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("The session is closed");
            }
            if (this.transacted) {
                throw new IllegalStateException("The session is transacted");
            }
            try {
                this.connection.stop();
                this.running = false;
            }
            catch (JMSException e) {
                throw new SpyJMSException("Could not stop message delivery", e);
            }
            try {
                LinkedList e = this.messages;
                synchronized (e) {
                    boolean trace = log.isTraceEnabled();
                    if (trace) {
                        log.trace((Object)("Recovering: unacknowledged messages=" + this.unacknowledgedMessages));
                    }
                    Iterator i = this.consumers.iterator();
                    while (i.hasNext()) {
                        SpyMessageConsumer consumer = (SpyMessageConsumer)i.next();
                        Iterator ii = this.unacknowledgedMessages.iterator();
                        while (ii.hasNext()) {
                            SpyMessage message = (SpyMessage)ii.next();
                            if (!consumer.getSubscription().accepts(message.header)) continue;
                            message.setJMSRedelivered(true);
                            consumer.messages.addLast(message);
                            ii.remove();
                            if (!trace) continue;
                            log.trace((Object)("Recovered: message=" + message + " consumer=" + consumer));
                        }
                    }
                    i = this.unacknowledgedMessages.iterator();
                    while (i.hasNext()) {
                        SpyMessage message = (SpyMessage)i.next();
                        this.connection.send(message.getAcknowledgementRequest(false));
                        i.remove();
                        if (!trace) continue;
                        log.trace((Object)("Recovered: nacked with no consumer message=" + message));
                    }
                }
            }
            catch (Exception e) {
                throw new SpyJMSException("Unable to recover session ", e);
            }
            try {
                this.running = true;
                this.connection.start();
                Iterator i = this.consumers.iterator();
                while (i.hasNext()) {
                    ((SpyMessageConsumer)i.next()).restartProcessing();
                }
            }
            catch (JMSException e) {
                throw new SpyJMSException("Could not resume message delivery", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAcknowledge(Message message, AcknowledgementRequest ack) throws JMSException {
        if (ack.isAck) {
            ArrayList arrayList = this.unacknowledgedMessages;
            synchronized (arrayList) {
                this.connection.send(((SpyMessage)message).getAcknowledgementRequest(true));
                this.unacknowledgedMessages.remove(message);
                Iterator i = this.unacknowledgedMessages.iterator();
                while (i.hasNext()) {
                    Message mess = (Message)i.next();
                    i.remove();
                    this.connection.send(((SpyMessage)mess).getAcknowledgementRequest(true));
                }
            }
        } else {
            this.unacknowledgedMessages.remove(message);
            this.connection.send(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SpySession: deleteDestination(dest=" + dest.toString() + ")"));
        }
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.remove(dest);
            this.consumers = newMap;
        }
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = new SpyTextMessage();
        message.setText(string);
        message.header.producerClientId = this.connection.getClientID();
        return message;
    }

    String getNewMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.connection.getNewMessageID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(SpyMessage message) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.addLast(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnacknowlegedMessage(SpyMessage message) {
        if (!this.transacted) {
            ArrayList arrayList = this.unacknowledgedMessages;
            synchronized (arrayList) {
                this.unacknowledgedMessages.add(message);
            }
        }
    }

    void sendMessage(SpyMessage m) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        m.header.producerClientId = this.connection.getClientID();
        if (this.transacted) {
            this.connection.spyXAResourceManager.addMessage(this.currentTransactionId, m.myClone());
        } else {
            this.connection.sendToServer(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(SpyMessageConsumer who) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.add(who);
            this.consumers = newMap;
        }
        try {
            this.connection.addConsumer(who);
        }
        catch (JMSSecurityException ex) {
            this.removeConsumerInternal(who);
            throw ex;
        }
    }

    void removeConsumer(SpyMessageConsumer who) throws JMSException {
        this.connection.removeConsumer(who);
        this.removeConsumerInternal(who);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerInternal(SpyMessageConsumer who) {
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            HashSet newMap = (HashSet)this.consumers.clone();
            newMap.remove(who);
            this.consumers = newMap;
        }
    }

    public SpyXAResourceManager getXAResourceManager() {
        return this.connection.spyXAResourceManager;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

