/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyXAException;

public class SpyXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpyXAResource == null ? (class$org$jboss$mq$SpyXAResource = SpyXAResource.class$("org.jboss.mq.SpyXAResource")) : class$org$jboss$mq$SpyXAResource));
    SpySession session;
    static /* synthetic */ Class class$org$jboss$mq$SpyXAResource;

    SpyXAResource(SpySession session) {
        this.session = session;
    }

    public boolean setTransactionTimeout(int arg1) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource arg1) throws XAException {
        if (!(arg1 instanceof SpyXAResource)) {
            return false;
        }
        return ((SpyXAResource)arg1).session.connection.spyXAResourceManager == this.session.connection.spyXAResourceManager;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Commit xid=" + xid + ", onePhase=" + onePhase));
        }
        try {
            this.session.connection.spyXAResourceManager.commit(xid, onePhase);
        }
        catch (JMSException e) {
            throw new SpyXAException(-3, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("End xid=" + xid + ", flags=" + flags));
        }
        Object object = this.session.runLock;
        synchronized (object) {
            switch (flags) {
                case 0x2000000: {
                    this.session.unsetCurrentTransactionId(xid);
                    this.session.connection.spyXAResourceManager.suspendTx(xid);
                    break;
                }
                case 0x20000000: {
                    this.session.unsetCurrentTransactionId(xid);
                    this.session.connection.spyXAResourceManager.endTx(xid, false);
                    break;
                }
                case 0x4000000: {
                    this.session.unsetCurrentTransactionId(xid);
                    this.session.connection.spyXAResourceManager.endTx(xid, true);
                }
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Forget xid=" + xid));
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Prepare xid=" + xid));
        }
        try {
            return this.session.connection.spyXAResourceManager.prepare(xid);
        }
        catch (JMSException e) {
            throw new SpyXAException(-3, (Throwable)e);
        }
    }

    public Xid[] recover(int arg1) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Recover arg1=" + arg1));
        }
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rollback xid=" + xid));
        }
        try {
            this.session.connection.spyXAResourceManager.rollback(xid);
        }
        catch (JMSException e) {
            throw new SpyXAException(-3, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Start xid=" + xid + ", flags=" + flags));
        }
        boolean convertTx = false;
        if (this.session.getCurrentTransactionId() != null) {
            if (flags == 0 && this.session.getCurrentTransactionId() instanceof Long) {
                convertTx = true;
            } else {
                throw new XAException(-9);
            }
        }
        Object object = this.session.runLock;
        synchronized (object) {
            switch (flags) {
                case 0: {
                    if (convertTx) {
                        this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.convertTx((Long)this.session.getCurrentTransactionId(), xid));
                        break;
                    }
                    this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.startTx(xid));
                    break;
                }
                case 0x200000: {
                    this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.joinTx(xid));
                    break;
                }
                case 0x8000000: {
                    this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.resumeTx(xid));
                }
            }
            this.session.runLock.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

