/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;

public class SpyXAResourceManager
implements Serializable {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpyXAResourceManager == null ? (class$org$jboss$mq$SpyXAResourceManager = SpyXAResourceManager.class$("org.jboss.mq.SpyXAResourceManager")) : class$org$jboss$mq$SpyXAResourceManager));
    private Connection connection;
    private Map transactions = Collections.synchronizedMap(new HashMap());
    private long nextInternalXid = Long.MIN_VALUE;
    private static final byte TX_OPEN = 0;
    private static final byte TX_SUSPENDED = 2;
    private static final byte TX_PREPARED = 3;
    private static final byte TX_COMMITED = 4;
    private static final byte TX_ROLLEDBACK = 5;
    private static final byte TX_ENDED = 1;
    static /* synthetic */ Class class$org$jboss$mq$SpyXAResourceManager;

    public SpyXAResourceManager(Connection conn) {
        this.connection = conn;
    }

    public void ackMessage(Object xid, SpyMessage msg) throws JMSException {
        TXState state;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Ack'ing message xid=" + xid));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new JMSException("Invalid transaction id.");
        }
        AcknowledgementRequest item = msg.getAcknowledgementRequest(true);
        state.ackedMessages.addLast(item);
    }

    public void addMessage(Object xid, SpyMessage msg) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Adding xid=" + xid + ", message=" + msg));
        }
        TXState state = (TXState)this.transactions.get(xid);
        if (trace) {
            log.trace((Object)("TXState=" + state));
        }
        if (state == null) {
            throw new JMSException("Invalid transaction id.");
        }
        state.sentMessages.addLast(msg);
    }

    public void commit(Object xid, boolean onePhase) throws XAException, JMSException {
        TXState state;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Commiting xid=" + xid + ", onePhase=" + onePhase));
        }
        if ((state = (TXState)this.transactions.remove(xid)) == null) {
            throw new XAException(-4);
        }
        if (onePhase) {
            Externalizable[] job;
            TransactionRequest transaction = new TransactionRequest();
            transaction.requestType = 0;
            transaction.xid = null;
            if (state.sentMessages.size() != 0) {
                job = new SpyMessage[state.sentMessages.size()];
                job = state.sentMessages.toArray(job);
                transaction.messages = job;
            }
            if (state.ackedMessages.size() != 0) {
                job = new AcknowledgementRequest[state.ackedMessages.size()];
                job = (AcknowledgementRequest[])state.ackedMessages.toArray(job);
                transaction.acks = job;
            }
            this.connection.send(transaction);
        } else {
            if (state.txState != 3) {
                throw new XAException("The transaction had not been prepared");
            }
            TransactionRequest transaction = new TransactionRequest();
            transaction.xid = xid;
            transaction.requestType = (byte)2;
            this.connection.send(transaction);
        }
        state.txState = (byte)4;
    }

    public void endTx(Object xid, boolean success) throws XAException {
        TXState state;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Ending xid=" + xid + ", success=" + success));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new XAException(-4);
        }
        state.txState = 1;
    }

    public Object joinTx(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Joining tx xid=" + xid));
        }
        if (!this.transactions.containsKey(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    public int prepare(Object xid) throws XAException, JMSException {
        Externalizable[] job;
        TXState state;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing xid=" + xid));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new XAException(-4);
        }
        TransactionRequest transaction = new TransactionRequest();
        transaction.requestType = 1;
        transaction.xid = xid;
        if (state.sentMessages.size() != 0) {
            job = new SpyMessage[state.sentMessages.size()];
            job = state.sentMessages.toArray(job);
            transaction.messages = job;
        }
        if (state.ackedMessages.size() != 0) {
            job = new AcknowledgementRequest[state.ackedMessages.size()];
            job = (AcknowledgementRequest[])state.ackedMessages.toArray(job);
            transaction.acks = job;
        }
        this.connection.send(transaction);
        state.txState = (byte)3;
        return 0;
    }

    public Object resumeTx(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Resuming tx xid=" + xid));
        }
        if (!this.transactions.containsKey(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    public void rollback(Object xid) throws XAException, JMSException {
        TXState state;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rolling back xid=" + xid));
        }
        if ((state = (TXState)this.transactions.remove(xid)) == null) {
            throw new XAException(-4);
        }
        if (state.txState != 3) {
            TransactionRequest transaction = new TransactionRequest();
            transaction.requestType = 0;
            transaction.xid = null;
            if (state.ackedMessages.size() != 0) {
                AcknowledgementRequest[] job = new AcknowledgementRequest[state.ackedMessages.size()];
                job = state.ackedMessages.toArray(job);
                transaction.acks = job;
                int i = 0;
                while (i < transaction.acks.length) {
                    transaction.acks[i].isAck = false;
                    ++i;
                }
            }
            this.connection.send(transaction);
        } else {
            TransactionRequest transaction = new TransactionRequest();
            transaction.xid = xid;
            transaction.requestType = (byte)3;
            this.connection.send(transaction);
        }
        state.txState = (byte)5;
    }

    public synchronized Object startTx() {
        Long newXid = new Long(this.nextInternalXid++);
        this.transactions.put(newXid, new TXState());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting tx with new xid=" + newXid));
        }
        return newXid;
    }

    public Object startTx(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting tx xid=" + xid));
        }
        if (this.transactions.containsKey(xid)) {
            throw new XAException(-8);
        }
        this.transactions.put(xid, new TXState());
        return xid;
    }

    public Object suspendTx(Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Suppending tx xid=" + xid));
        }
        if (!this.transactions.containsKey(xid)) {
            throw new XAException(-4);
        }
        return xid;
    }

    public Object convertTx(Long anonXid, Xid xid) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Converting tx anonXid=" + anonXid + ", xid=" + xid));
        }
        if (!this.transactions.containsKey(anonXid)) {
            throw new XAException(-4);
        }
        if (this.transactions.containsKey(xid)) {
            throw new XAException(-8);
        }
        TXState s = (TXState)this.transactions.remove(anonXid);
        this.transactions.put(xid, s);
        return xid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TXState {
        byte txState = 0;
        LinkedList sentMessages = new LinkedList();
        LinkedList ackedMessages = new LinkedList();

        TXState() {
        }

        public String toString() {
            return super.toString() + "{ txState=" + this.txState + ", sendMessages=" + this.sentMessages + ", ackedMessages=" + this.ackedMessages + " }";
        }
    }
}

