/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.http.HTTPClient;
import org.jboss.mq.il.http.HTTPClientIL;
import org.jboss.mq.il.http.HTTPILRequest;

public class HTTPClientILService
implements Runnable,
ClientILService {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$http$HTTPClientILService == null ? (class$org$jboss$mq$il$http$HTTPClientILService = HTTPClientILService.class$("org.jboss.mq.il.http.HTTPClientILService")) : class$org$jboss$mq$il$http$HTTPClientILService));
    private HTTPClientIL clientIL;
    private Connection connection;
    private URL url = null;
    private long timeout = 60000L;
    private long restInterval = 0L;
    private Thread worker;
    private String clientILIdentifier;
    private static int threadNumber = 0;
    static /* synthetic */ Class class$org$jboss$mq$il$http$HTTPClientILService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public HTTPClientILService() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"created");
        }
    }

    public ClientIL getClientIL() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"getClientIL()");
        }
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        block4: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("init(Connection " + connection.toString() + ", Properties " + props.toString() + ")"));
            }
            this.connection = connection;
            this.url = HTTPClient.resolveServerUrl(props.getProperty("org.jboss.mq.il.http.url"));
            this.clientILIdentifier = this.getClientILIdentifier(this.url);
            this.clientIL = new HTTPClientIL(this.clientILIdentifier);
            try {
                this.timeout = System.getProperties().containsKey("org.jboss.mq.il.http.timeout") ? Long.valueOf(System.getProperty("org.jboss.mq.il.http.timeout")).longValue() : Long.valueOf(props.getProperty("org.jboss.mq.il.http.timeout")).longValue();
                if (System.getProperties().containsKey("org.jboss.mq.il.http.restinterval")) {
                    this.restInterval = Long.valueOf(System.getProperty("org.jboss.mq.il.http.restinterval"));
                    break block4;
                }
                this.restInterval = Long.valueOf(props.getProperty("org.jboss.mq.il.http.restinterval"));
            }
            catch (Exception exception) {}
        }
    }

    public void start() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"start()");
        }
        this.clientIL.stopped = false;
        this.worker = new Thread(Connection.threadGroup, this, "HTTPClientILService-" + threadNumber++);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"stop()");
        }
        this.clientIL.stopped = true;
    }

    public void run() {
        block19: {
            if (log.isTraceEnabled()) {
                log.trace((Object)"run()");
            }
            HTTPILRequest request = new HTTPILRequest();
            request.setMethodName("clientListening");
            while (!this.clientIL.stopped) {
                try {
                    if (this.clientILIdentifier != null && !this.clientIL.stopped) {
                        HTTPILRequest[] response;
                        request.setArguments(new Object[]{this.clientILIdentifier, new Long(this.timeout)}, new Class[]{class$java$lang$String == null ? HTTPClientILService.class$("java.lang.String") : class$java$lang$String, class$java$lang$Long == null ? HTTPClientILService.class$("java.lang.Long") : class$java$lang$Long});
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Sending a request to '" + this.url.toString() + "' for ClientIL #" + this.clientILIdentifier + "."));
                        }
                        if ((response = (HTTPILRequest[])HTTPClient.post(this.url, request)) != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Logging each response received in this batch for ClientIL #" + this.clientILIdentifier + "."));
                            }
                            int i = 0;
                            while (i < response.length) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)response.toString());
                                }
                                Method method = this.connection.getClass().getMethod(response[i].getMethodName(), response[i].getArgumentTypes());
                                method.invoke((Object)this.connection, response[i].getArguments());
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Server invoked method '" + method.getName() + "' on ClientIL #" + this.clientILIdentifier + "."));
                                }
                                ++i;
                            }
                        } else {
                            log.warn((Object)("The request posted to '" + this.url.toString() + "' on behalf of ClientIL #" + this.clientILIdentifier + " returned an unexpected response."));
                        }
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Resting " + String.valueOf(this.restInterval) + " milliseconds on ClientIL #" + this.clientILIdentifier + "."));
                            }
                            Thread.sleep(this.restInterval);
                        }
                        catch (InterruptedException exception) {}
                        continue;
                    }
                    log.warn((Object)"ClientIL Id is null, waiting 50 milliseconds to get one.");
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exception of type '" + exception.getClass().getName() + "' occured when trying to receive request from server URL '" + this.url + ".'"));
                    }
                    this.connection.asynchFailure(exception.getMessage(), exception);
                    break;
                }
            }
            if (!this.clientIL.stopped) break block19;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notifying the server that ClientIL #" + this.clientILIdentifier + " has stopped."));
            }
            try {
                HTTPILRequest stopRequest = new HTTPILRequest();
                request.setMethodName("stopClientListening");
                request.setArguments(new Object[]{this.clientILIdentifier}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTTPClientILService.class$("java.lang.String")) : class$java$lang$String});
                HTTPClient.post(this.url, request);
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block19;
                log.debug((Object)("Attempt to notify the server that ClientIL #" + this.clientILIdentifier + " failed due to exception with description '" + exception.getMessage() + ".' This means that requests will stay in the storage queue even though the client has stopped."));
            }
        }
    }

    private String getClientILIdentifier(URL url) throws Exception {
        HTTPILRequest request = new HTTPILRequest();
        request.setMethodName("getClientILIdentifer");
        return (String)HTTPClient.post(url, request);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

