/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.oil.OILClientIL;

public final class OILClientILService
implements Runnable,
ClientILService {
    private static final Logger cat = Logger.getLogger((Class)(class$org$jboss$mq$il$oil$OILClientILService == null ? (class$org$jboss$mq$il$oil$OILClientILService = OILClientILService.class$("org.jboss.mq.il.oil.OILClientILService")) : class$org$jboss$mq$il$oil$OILClientILService));
    private OILClientIL clientIL;
    private Thread worker;
    private Socket socket = null;
    private Connection connection;
    private boolean running;
    private ServerSocket serverSocket;
    private static int threadNumber = 0;
    private boolean enableTcpNoDelay = false;
    static /* synthetic */ Class class$org$jboss$mq$il$oil$OILClientILService;

    public ClientIL getClientIL() throws Exception {
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        this.connection = connection;
        this.serverSocket = new ServerSocket(0);
        String t = props.getProperty("OIL_TCPNODELAY_KEY");
        if (t != null) {
            this.enableTcpNoDelay = t.equals("yes");
        }
        this.clientIL = new OILClientIL(InetAddress.getLocalHost(), this.serverSocket.getLocalPort(), this.enableTcpNoDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        code = 0;
        out = null;
        in = null;
        this.socket = null;
        serverPort = this.serverSocket.getLocalPort();
        try {
            block43: {
                if (OILClientILService.cat.isDebugEnabled()) {
                    OILClientILService.cat.debug((Object)("Waiting for the server to connect to me on port " + this.serverSocket.getLocalPort()));
                }
                this.serverSocket.setSoTimeout(1000);
                while (this.running && this.socket == null) {
                    try {
                        this.socket = this.serverSocket.accept();
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        block41: {
                            if (this.running) {
                                this.connection.asynchFailure("Error accepting connection from server in OILClientILService.", e);
                            }
                            try {
                                this.serverSocket.close();
                                this.serverSocket = null;
                            }
                            catch (IOException e) {
                                if (!OILClientILService.cat.isDebugEnabled()) break block41;
                                OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                            }
                        }
                        return;
                    }
                }
                if (!this.running) break block43;
                this.socket.setTcpNoDelay(this.enableTcpNoDelay);
                this.socket.setSoTimeout(0);
                out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                out.flush();
                in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
                if (true) ** GOTO lbl101
            }
            return;
        }
        catch (IOException e) {
            this.connection.asynchFailure("Could not initialize the OILClientIL Service.", e);
            return;
        }
        finally {
            block42: {
                try {
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
                catch (IOException e) {
                    if (!OILClientILService.cat.isDebugEnabled()) break block42;
                    OILClientILService.cat.debug((Object)"run: an error occured closing the server socket", (Throwable)e);
                }
            }
        }
        do {
            try {
                code = in.readByte();
            }
            catch (InterruptedIOException e) {
                continue;
            }
            catch (IOException e) {
                break;
            }
            try {
                switch (code) {
                    case 19: {
                        numReceives = in.readInt();
                        messages = new ReceiveRequest[numReceives];
                        i = 0;
                        while (i < numReceives) {
                            messages[i] = new ReceiveRequest();
                            messages[i].readExternal(in);
                            ++i;
                        }
                        this.connection.asynchDeliver(messages);
                        break;
                    }
                    case 15: {
                        this.connection.asynchDeleteTemporaryDestination((SpyDestination)in.readObject());
                        break;
                    }
                    case 29: {
                        this.connection.asynchClose();
                        break;
                    }
                    case 28: {
                        this.connection.asynchPong(in.readLong());
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
                try {
                    out.writeByte(0);
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    this.connection.asynchFailure("Connection failure(1)", e);
                }
            }
            catch (Exception e) {
                if (!this.running) break;
                try {
                    OILClientILService.cat.error((Object)"Exception handling server request", (Throwable)e);
                    out.writeByte(2);
                    out.writeObject(e);
                    out.reset();
                    out.flush();
                    continue;
                }
                catch (IOException e2) {
                    this.connection.asynchFailure("Connection failure(2)", e2);
                }
            }
            break;
lbl101:
            // 4 sources

        } while (this.running);
        try {
            OILClientILService.cat.debug((Object)("Closing receiver connections on port: " + serverPort));
            out.close();
            in.close();
            this.socket.close();
            this.socket = null;
        }
        catch (IOException e) {
            this.connection.asynchFailure("Connection failure", e);
        }
        this.running = false;
    }

    public void start() throws Exception {
        this.running = true;
        this.worker = new Thread(Connection.threadGroup, this, "OILClientILService-" + threadNumber++);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() throws Exception {
        cat.trace((Object)"Stop called on OILClientService");
        this.running = false;
        this.worker.interrupt();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

