/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.oil2.OIL2ClientIL;
import org.jboss.mq.il.oil2.OIL2Request;
import org.jboss.mq.il.oil2.OIL2RequestListner;
import org.jboss.mq.il.oil2.OIL2Response;
import org.jboss.mq.il.oil2.OIL2ServerIL;
import org.jboss.mq.il.oil2.OIL2ServerILServiceMBean;
import org.jboss.mq.il.oil2.OIL2SocketHandler;
import org.jboss.security.SecurityDomain;
import org.jboss.system.server.ServerConfigUtil;

public final class OIL2ServerILService
extends ServerILJMXService
implements Runnable,
OIL2ServerILServiceMBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$oil2$OIL2ServerILService == null ? (class$org$jboss$mq$il$oil2$OIL2ServerILService = OIL2ServerILService.class$("org.jboss.mq.il.oil2.OIL2ServerILService")) : class$org$jboss$mq$il$oil2$OIL2ServerILService));
    private static final int SO_TIMEOUT = 5000;
    private Invoker server;
    private boolean enableTcpNoDelay = false;
    private String securityDomain;
    private String clientSocketFactoryName;
    private ServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;
    private OIL2ServerIL serverIL;
    private volatile boolean running;
    private int serverBindPort = 0;
    private InetAddress bindAddress = null;
    private Properties connectionProperties;
    static /* synthetic */ Class class$org$jboss$mq$il$oil2$OIL2ServerILService;
    static /* synthetic */ Class class$org$jboss$security$SecurityDomain;

    public Properties getClientConnectionProperties() {
        return this.connectionProperties;
    }

    public String getName() {
        return "JBossMQ-OILServerIL";
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block25: {
            block24: {
                try {
                    try {
                        while (this.running) {
                            block23: {
                                socket = null;
                                try {
                                    socket = this.serverSocket.accept();
                                    if (!OIL2ServerILService.log.isTraceEnabled()) break block23;
                                    OIL2ServerILService.log.trace((Object)("Accepted connection: " + socket));
                                }
                                catch (InterruptedIOException e) {
                                    continue;
                                }
                            }
                            if (!this.running) {
                                if (socket != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (Exception ignore) {
                                    }
                                }
                                var5_9 = null;
                                break block24;
                            }
                            try {
                                if (OIL2ServerILService.log.isTraceEnabled()) {
                                    OIL2ServerILService.log.trace((Object)("Initializing RequestListner for socket: " + socket));
                                }
                                requestListner = new RequestListner(socket);
                                requestListner.socketHandler = socketHandler = new OIL2SocketHandler(requestListner.in, requestListner.out, Thread.currentThread().getThreadGroup());
                                socketHandler.setRequestListner(requestListner);
                                socketHandler.start();
                            }
                            catch (IOException ie) {
                                OIL2ServerILService.log.debug((Object)"Client connection could not be accepted: ", (Throwable)ie);
                            }
                        }
                        break block25;
                    }
                    catch (SocketException e) {
                        if (this.running) {
                            OIL2ServerILService.log.warn((Object)"SocketException occured (Connection reset by peer?). Cannot initialize the OIL2ServerILService.");
                        }
                        var5_11 = null;
                        try {
                            this.serverSocket.close();
                            return;
                        }
                        catch (Exception e) {
                            OIL2ServerILService.log.debug((Object)"error closing server socket", (Throwable)e);
                        }
                        return;
                    }
                    catch (IOException e) {
                        if (this.running) {
                            OIL2ServerILService.log.warn((Object)"IOException occured. Cannot initialize the OIL2ServerILService.");
                        }
                        var5_12 = null;
                        ** try [egrp 5[TRYBLOCK] [12 : 243->253)] { 
lbl51:
                        // 1 sources

                        this.serverSocket.close();
                        return;
lbl53:
                        // 1 sources

                        catch (Exception e) {
                            OIL2ServerILService.log.debug((Object)"error closing server socket", (Throwable)e);
                        }
                        return;
                    }
                }
                catch (Throwable var4_19) {
                    var5_13 = null;
                    try {}
                    catch (Exception e) {
                        OIL2ServerILService.log.debug((Object)"error closing server socket", (Throwable)e);
                        return;
                    }
                    this.serverSocket.close();
                    return;
                }
            }
            ** try [egrp 5[TRYBLOCK] [12 : 243->253)] { 
lbl67:
            // 1 sources

            this.serverSocket.close();
            return;
lbl69:
            // 1 sources

            catch (Exception e) {
                OIL2ServerILService.log.debug((Object)"error closing server socket", (Throwable)e);
            }
            return;
        }
        var5_10 = null;
        ** try [egrp 5[TRYBLOCK] [12 : 243->253)] { 
lbl75:
        // 1 sources

        this.serverSocket.close();
        return;
lbl77:
        // 1 sources

        catch (Exception e) {
            OIL2ServerILService.log.debug((Object)"error closing server socket", (Throwable)e);
        }
    }

    public void startService() throws Exception {
        super.startService();
        this.running = true;
        this.server = this.lookupJMSServer();
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.securityDomain != null) {
            try {
                InitialContext ctx = new InitialContext();
                Class<?> ssfClass = this.serverSocketFactory.getClass();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.securityDomain);
                Class[] parameterTypes = new Class[]{class$org$jboss$security$SecurityDomain == null ? (class$org$jboss$security$SecurityDomain = OIL2ServerILService.class$("org.jboss.security.SecurityDomain")) : class$org$jboss$security$SecurityDomain};
                Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)this.serverSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"Socket factory does not support setSecurityDomain(SecurityDomain)");
            }
            catch (Exception e) {
                log.error((Object)("Failed to setSecurityDomain=" + this.securityDomain + " on socket factory"));
            }
        }
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.serverBindPort, 50, this.bindAddress);
        this.serverSocket.setSoTimeout(5000);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        log.info((Object)("JBossMQ OIL2 service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort()));
        new Thread(this.server.getThreadGroup(), this, "OIL2 Worker Server").start();
        socketAddress = ServerConfigUtil.fixRemoteAddress((InetAddress)socketAddress);
        this.serverIL = new OIL2ServerIL(socketAddress.getHostAddress(), this.serverSocket.getLocalPort(), this.clientSocketFactoryName, this.enableTcpNoDelay);
        this.connectionProperties = super.getClientConnectionProperties();
        this.connectionProperties.setProperty("ClientILService", "org.jboss.mq.il.oil2.OIL2ClientILService");
        this.connectionProperties.setProperty("OIL2_PORT_KEY", "" + this.serverSocket.getLocalPort());
        this.connectionProperties.setProperty("OIL2_ADDRESS_KEY", "" + socketAddress.getHostAddress());
        this.connectionProperties.setProperty("OIL2_TCPNODELAY_KEY", this.enableTcpNoDelay ? "yes" : "no");
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            log.error((Object)"Exception unbinding from JNDI", (Throwable)e);
        }
        try {
            this.running = false;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Exception stopping server thread", (Throwable)e);
        }
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public boolean getEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String name) {
        this.clientSocketFactoryName = name;
    }

    public void setServerSocketFactory(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ssfClass = loader.loadClass(name);
        this.serverSocketFactory = (ServerSocketFactory)ssfClass.newInstance();
    }

    public String getServerSocketFactory() {
        String name = null;
        if (this.serverSocketFactory != null) {
            name = this.serverSocketFactory.getClass().getName();
        }
        return name;
    }

    public void setSecurityDomain(String domainName) {
        this.securityDomain = domainName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RequestListner
    implements OIL2RequestListner {
        Socket socket;
        ObjectInputStream in;
        ObjectOutputStream out;
        OIL2SocketHandler socketHandler;
        ConnectionToken connectionToken;
        boolean closing = false;

        RequestListner(Socket socket) throws IOException {
            socket.setSoTimeout(0);
            socket.setTcpNoDelay(OIL2ServerILService.this.enableTcpNoDelay);
            this.out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }

        public void handleRequest(OIL2Request request) {
            if (this.closing) {
                log.trace((Object)"A connection that is closing received another request.  Droping request.");
                return;
            }
            Object result = null;
            Exception resultException = null;
            try {
                switch (request.operation) {
                    case 14: {
                        this.connectionToken = (ConnectionToken)request.arguments[0];
                        ((OIL2ClientIL)this.connectionToken.clientIL).setRequestListner(this);
                        break;
                    }
                    case 1: {
                        OIL2ServerILService.this.server.acknowledge(this.connectionToken, (AcknowledgementRequest)request.arguments[0]);
                        break;
                    }
                    case 2: {
                        OIL2ServerILService.this.server.addMessage(this.connectionToken, (SpyMessage)request.arguments[0]);
                        break;
                    }
                    case 3: {
                        result = OIL2ServerILService.this.server.browse(this.connectionToken, (Destination)request.arguments[0], (String)request.arguments[1]);
                        break;
                    }
                    case 4: {
                        OIL2ServerILService.this.server.checkID((String)request.arguments[0]);
                        if (this.connectionToken != null) {
                            this.connectionToken.setClientID((String)request.arguments[0]);
                        }
                        break;
                    }
                    case 5: {
                        this.beginClose();
                        break;
                    }
                    case 6: {
                        result = OIL2ServerILService.this.server.createQueue(this.connectionToken, (String)request.arguments[0]);
                        break;
                    }
                    case 7: {
                        result = OIL2ServerILService.this.server.createTopic(this.connectionToken, (String)request.arguments[0]);
                        break;
                    }
                    case 8: {
                        OIL2ServerILService.this.server.deleteTemporaryDestination(this.connectionToken, (SpyDestination)request.arguments[0]);
                        break;
                    }
                    case 9: {
                        result = OIL2ServerILService.this.server.getID();
                        if (this.connectionToken != null) {
                            this.connectionToken.setClientID((String)result);
                        }
                        break;
                    }
                    case 10: {
                        result = OIL2ServerILService.this.server.getTemporaryQueue(this.connectionToken);
                        break;
                    }
                    case 11: {
                        result = OIL2ServerILService.this.server.getTemporaryTopic(this.connectionToken);
                        break;
                    }
                    case 12: {
                        result = OIL2ServerILService.this.server.receive(this.connectionToken, (Integer)request.arguments[0], (Long)request.arguments[1]);
                        break;
                    }
                    case 13: {
                        OIL2ServerILService.this.server.setEnabled(this.connectionToken, (Boolean)request.arguments[0]);
                        break;
                    }
                    case 15: {
                        OIL2ServerILService.this.server.subscribe(this.connectionToken, (Subscription)request.arguments[0]);
                        break;
                    }
                    case 16: {
                        OIL2ServerILService.this.server.transact(this.connectionToken, (TransactionRequest)request.arguments[0]);
                        break;
                    }
                    case 17: {
                        OIL2ServerILService.this.server.unsubscribe(this.connectionToken, (Integer)request.arguments[0]);
                        break;
                    }
                    case 18: {
                        OIL2ServerILService.this.server.destroySubscription(this.connectionToken, (DurableSubscriptionID)request.arguments[0]);
                        break;
                    }
                    case 19: {
                        result = OIL2ServerILService.this.server.checkUser((String)request.arguments[0], (String)request.arguments[1]);
                        break;
                    }
                    case 20: {
                        OIL2ServerILService.this.server.ping(this.connectionToken, (Long)request.arguments[0]);
                        break;
                    }
                    case 22: {
                        result = OIL2ServerILService.this.server.authenticate((String)request.arguments[0], (String)request.arguments[1]);
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
            }
            catch (Exception e) {
                resultException = e;
            }
            try {
                OIL2Response response = new OIL2Response(request);
                response.result = result;
                response.exception = resultException;
                this.socketHandler.sendResponse(response);
            }
            catch (IOException e) {
                this.handleConnectionException(e);
            }
        }

        public void handleConnectionException(Exception e) {
            if (!this.closing) {
                log.info((Object)("Client Disconnected: " + e));
            }
            this.beginClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginClose() {
            this.closing = true;
            try {
                block4: {
                    try {
                        if (this.connectionToken == null) break block4;
                        OIL2ServerILService.this.server.connectionClosing(this.connectionToken);
                    }
                    catch (JMSException ignore) {
                        Object var3_2 = null;
                        this.close();
                    }
                }
                Object var3_1 = null;
                this.close();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.close();
                throw throwable;
            }
        }

        void close() {
            try {
                if (this.socket != null) {
                    this.socketHandler.stop();
                    this.in.close();
                    this.out.close();
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException e) {
                log.debug((Object)"Exception occured while closing opened resources: ", (Throwable)e);
            }
        }

        public OIL2SocketHandler getSocketHandler() {
            return this.socketHandler;
        }
    }
}

