/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.jboss.logging.Logger;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.uil.multiplexor.SocketMultiplexor;

public class UILClientIL
implements ClientIL,
Serializable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$il$uil$UILClientIL == null ? (class$org$jboss$mq$il$uil$UILClientIL = UILClientIL.class$("org.jboss.mq.il.uil.UILClientIL")) : class$org$jboss$mq$il$uil$UILClientIL));
    static final int m_close = 2;
    static final int m_deleteTemporaryDestination = 1;
    static final int m_receive = 3;
    static final int m_pong = 4;
    transient SocketMultiplexor mSocket;
    private transient ObjectInputStream in;
    private transient ObjectOutputStream out;
    static /* synthetic */ Class class$org$jboss$mq$il$uil$UILClientIL;

    public void close() throws Exception {
    }

    public synchronized void deleteTemporaryDestination(SpyDestination dest) throws Exception {
        this.checkSocket();
        this.out.writeByte(1);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void pong(long serverTime) throws Exception {
        this.checkSocket();
        this.out.writeByte(4);
        this.out.writeLong(serverTime);
        this.out.flush();
    }

    public synchronized void receive(ReceiveRequest[] messages) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Checking socket");
        }
        this.checkSocket();
        if (trace) {
            log.trace((Object)"Writing request");
        }
        this.out.writeByte(3);
        this.out.writeInt(messages.length);
        int i = 0;
        while (i < messages.length) {
            messages[i].writeExternal(this.out);
            ++i;
        }
        if (trace) {
            log.trace((Object)"Waiting for awnser");
        }
        this.waitAnswer();
        if (trace) {
            log.trace((Object)"Done");
        }
    }

    protected void checkSocket() throws Exception {
        if (this.out == null) {
            this.createConnection();
        }
    }

    protected void createConnection() throws RemoteException {
        try {
            this.in = new ObjectInputStream(new BufferedInputStream(this.mSocket.getInputStream(2)));
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream(2)));
            this.out.flush();
        }
        catch (Exception e) {
            log.debug((Object)"Cannot connect to the ConnectionReceiver/Server", (Throwable)e);
            throw new RemoteException("Cannot connect to the ConnectionReceiver/Server");
        }
    }

    protected void waitAnswer() throws Exception {
        RemoteException throwException = null;
        try {
            this.out.reset();
            this.out.flush();
            byte val = this.in.readByte();
            switch (val) {
                case 1: {
                    Exception e = (Exception)this.in.readObject();
                    throwException = new RemoteException("", e);
                }
            }
        }
        catch (IOException e) {
            throw new RemoteException("Cannot contact the remote object", e);
        }
        if (throwException != null) {
            throw throwException;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

