/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.rollinglogged;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.rollinglogged.IntegrityLog;
import org.jboss.mq.pm.rollinglogged.PersistenceManager;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;

public class SpyMessageLog {
    private IntegrityLog transactionLog;
    private final MessageCache cache;

    SpyMessageLog(MessageCache cache, File file) throws JMSException {
        if (cache == null) {
            throw new IllegalArgumentException("must supply a cache!");
        }
        this.cache = cache;
        try {
            this.transactionLog = new IntegrityLog(file);
        }
        catch (IOException e) {
            this.throwJMSException("Could not open the queue's tranaction log: " + file.getAbsolutePath(), e);
        }
    }

    public synchronized void close() throws JMSException {
        try {
            this.transactionLog.close();
        }
        catch (IOException e) {
            this.throwJMSException("Could not close the queue's tranaction log.", e);
        }
    }

    public synchronized void delete() throws JMSException {
        try {
            this.transactionLog.delete();
        }
        catch (IOException e) {
            this.throwJMSException("Could not delete the queue's tranaction log.", e);
        }
    }

    public synchronized void restore(TreeSet committed, PersistenceManager.LogInfo info, HashMap messages) throws JMSException {
        try {
            LinkedList objects = this.transactionLog.toIndex();
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                MessageReference mr;
                Serializable r;
                Object o = it.next();
                if (o instanceof IntegrityLog.MessageAddedRecord) {
                    r = (IntegrityLog.MessageAddedRecord)o;
                    r.message.header.messageId = r.messageId;
                    if (r.isTransacted && !committed.contains(new Tx(r.transactionId))) continue;
                    mr = this.cache.add(r.message);
                    mr.persistData = info;
                    messages.put(new Long(r.messageId), mr);
                    ++info.liveMessages;
                    continue;
                }
                if (o instanceof IntegrityLog.MessageRemovedRecord) {
                    r = (IntegrityLog.MessageRemovedRecord)o;
                    if (((IntegrityLog.MessageRemovedRecord)r).isTransacted && !committed.contains(new Tx(((IntegrityLog.MessageRemovedRecord)r).transactionId))) continue;
                    mr = (MessageReference)messages.remove(new Long(((IntegrityLog.MessageRemovedRecord)r).messageId));
                    if (mr != null) {
                        this.cache.remove(mr);
                    }
                    --info.liveMessages;
                    continue;
                }
                if (!(o instanceof IntegrityLog.MessageUpdateRecord)) continue;
                r = (IntegrityLog.MessageUpdateRecord)o;
                ((IntegrityLog.MessageUpdateRecord)r).message.header.messageId = ((IntegrityLog.MessageUpdateRecord)r).messageId;
                if (((IntegrityLog.MessageUpdateRecord)r).isTransacted && !committed.contains(new Tx(((IntegrityLog.MessageUpdateRecord)r).transactionId)) || (mr = (MessageReference)messages.get(new Long(((IntegrityLog.MessageUpdateRecord)r).messageId))) == null) continue;
                mr.invalidate();
                mr.hardReference = ((IntegrityLog.MessageUpdateRecord)r).message;
            }
        }
        catch (Exception e) {
            this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
        }
    }

    public synchronized void add(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            if (transactionId == null) {
                this.transactionLog.add(message.header.messageId, false, -1L, message);
            } else {
                this.transactionLog.add(message.header.messageId, true, transactionId.longValue(), message);
            }
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public synchronized void remove(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            if (transactionId == null) {
                this.transactionLog.remove(message.header.messageId, false, -1L);
            } else {
                this.transactionLog.remove(message.header.messageId, true, transactionId.longValue());
            }
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the queue's tranaction log.", e);
        }
    }

    public synchronized void update(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            if (transactionId != null) {
                throw new JMSException("NYI: No code does updates in a transaction");
            }
            this.transactionLog.update(message.header.messageId, false, -1L, message);
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the queue's tranaction log.", e);
        }
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }
}

