/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.security.SecurityManager;
import org.jboss.mq.security.SecurityMetadata;
import org.jboss.mq.server.JMSServerInterceptorSupport;

public class ServerSecurityInterceptor
extends JMSServerInterceptorSupport {
    SecurityManager manager;
    private HashMap tempDests = new HashMap();

    public ServerSecurityInterceptor(SecurityManager manager) {
        this.manager = manager;
    }

    public String authenticate(String name, String password) throws JMSException {
        this.log.trace((Object)("Autenticating user " + name + "/" + password));
        return this.manager.authenticate(name, password);
    }

    public void connectionClosing(ConnectionToken dc) throws JMSException {
        super.connectionClosing(dc);
        this.manager.logout(dc);
        this.removeTemporaryDestinations(dc);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Checking browse authorize on " + dc + " dest=" + dest));
        }
        if (!this.authorizeRead(dc, ((SpyDestination)dest).getName())) {
            throw new JMSSecurityException("Connection not autorized to browse to destination: " + dest);
        }
        return super.browse(dc, dest, selector);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Checking receive authorize on " + dc + " subId=" + subscriberId));
        }
        Subscription sub = super.getSubscription(dc, subscriberId);
        String destName = sub.destination.getName();
        if (!this.authorizeRead(dc, destName)) {
            throw new JMSSecurityException("Connection not autorized to receive from destination: " + destName);
        }
        return super.receive(dc, subscriberId, wait);
    }

    public void subscribe(ConnectionToken dc, Subscription sub) throws JMSException {
        DurableSubscriptionID id;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Checking subscribe authorize on " + dc + " sub=" + sub));
        }
        if (sub == null) {
            throw new JMSException("The subscription is not allowed to be null");
        }
        if (sub.destination == null) {
            throw new InvalidDestinationException("Destination is not allowed to be null");
        }
        SpyDestination dest = sub.destination;
        String destName = dest.getName();
        if (dest instanceof SpyTopic && (id = ((SpyTopic)dest).getDurableSubscriptionID()) != null && !this.authorizeCreate(dc, destName)) {
            throw new JMSSecurityException("Connection not authorized to do durable subscription on topic: " + destName);
        }
        if (!this.authorizeRead(dc, destName)) {
            throw new JMSSecurityException("Connection not authorized to subscribe to destination: " + destName);
        }
        super.subscribe(dc, sub);
    }

    public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException {
        String dest = ((SpyDestination)message.getJMSDestination()).getName();
        if (!this.authorizeWrite(dc, dest)) {
            throw new JMSSecurityException("Connection not autorized to addMessages to destination: " + dest);
        }
        super.addMessage(dc, message);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        SpyTopic t = super.getDurableTopic(id);
        if (t == null) {
            throw new InvalidDestinationException("No durable topic found for subscription " + id.getSubscriptionName());
        }
        if (!this.authorizeCreate(dc, t.getName())) {
            throw new JMSSecurityException("Connection not autorized to unsubscribe from subscription: " + t.getName());
        }
        super.destroySubscription(dc, id);
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        TemporaryTopic result = super.getTemporaryTopic(dc);
        this.addTemporaryDestination(dc, (Destination)result);
        return result;
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        TemporaryQueue result = super.getTemporaryQueue(dc);
        this.addTemporaryDestination(dc, (Destination)result);
        return result;
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination destination) throws JMSException {
        this.removeTemporaryDestination(dc, destination);
        super.deleteTemporaryDestination(dc, destination);
    }

    public boolean authorizeRead(ConnectionToken dc, String destination) throws JMSException {
        SecurityMetadata m = this.manager.getSecurityMetadata(destination);
        if (m == null) {
            this.log.warn((Object)("No security configuration avaliable for " + destination));
            return false;
        }
        Set readPrincipals = m.getReadPrincipals();
        return this.manager.authorize(dc, readPrincipals);
    }

    public boolean authorizeWrite(ConnectionToken dc, String destination) throws JMSException {
        SecurityMetadata m = this.manager.getSecurityMetadata(destination);
        if (m == null) {
            this.log.warn((Object)("No security configuration avaliable for " + destination));
            return false;
        }
        Set writePrincipals = m.getWritePrincipals();
        return this.manager.authorize(dc, writePrincipals);
    }

    public boolean authorizeCreate(ConnectionToken dc, String destination) throws JMSException {
        SecurityMetadata m = this.manager.getSecurityMetadata(destination);
        if (m == null) {
            this.log.warn((Object)("No security configuration avaliable for " + destination));
            return false;
        }
        Set createPrincipals = m.getCreatePrincipals();
        return this.manager.authorize(dc, createPrincipals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemporaryDestination(ConnectionToken dc, Destination destination) {
        HashMap hashMap = this.tempDests;
        synchronized (hashMap) {
            HashSet<Destination> set = (HashSet<Destination>)this.tempDests.get(dc);
            if (set == null) {
                set = new HashSet<Destination>();
                this.tempDests.put(dc, set);
            }
            set.add(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemporaryDestination(ConnectionToken dc, SpyDestination destination) {
        HashMap hashMap = this.tempDests;
        synchronized (hashMap) {
            HashSet set = (HashSet)this.tempDests.get(dc);
            if (set == null) {
                return;
            }
            set.remove(destination);
        }
        try {
            this.manager.removeDestination(destination.getName());
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to remove temporary destination " + destination), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemporaryDestinations(ConnectionToken dc) {
        HashMap hashMap = this.tempDests;
        synchronized (hashMap) {
            HashSet set = (HashSet)this.tempDests.remove(dc);
            if (set == null) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SpyDestination destination = (SpyDestination)iterator.next();
                try {
                    this.manager.removeDestination(destination.getName());
                }
                catch (Exception e) {
                    this.log.warn((Object)("Unable to remove temporary destination " + destination), (Throwable)e);
                }
            }
        }
    }
}

