/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.jvm.JVMClientIL;
import org.jboss.mq.server.JMSServerInterceptorSupport;

public class ClientMonitorInterceptor
extends JMSServerInterceptorSupport {
    protected static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$server$ClientMonitorInterceptor == null ? (class$org$jboss$mq$server$ClientMonitorInterceptor = ClientMonitorInterceptor.class$("org.jboss.mq.server.ClientMonitorInterceptor")) : class$org$jboss$mq$server$ClientMonitorInterceptor));
    HashMap clients = new HashMap();
    static /* synthetic */ Class class$org$jboss$mq$server$ClientMonitorInterceptor;

    public void disconnectInactiveClients(long disconnectTime) {
        log.debug((Object)"Checking for timedout clients.");
        Iterator i = this.clients.keySet().iterator();
        while (i.hasNext()) {
            ConnectionToken dc = (ConnectionToken)i.next();
            ClientStats cs = (ClientStats)this.clients.get(dc);
            if (!cs.disconnectIfInactive || cs.lastUsed >= disconnectTime) continue;
            try {
                log.debug((Object)("Disconnecting client due to inactivity timeout: " + dc));
                this.connectionClosing(dc);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientStats getClientStats(ConnectionToken dc) throws JMSException {
        ClientStats cq = (ClientStats)this.clients.get(dc);
        if (cq == null) {
            cq = new ClientStats();
            if (dc.clientIL instanceof JVMClientIL) {
                cq.disconnectIfInactive = false;
            }
            HashMap hashMap = this.clients;
            synchronized (hashMap) {
                HashMap<ConnectionToken, ClientStats> m = new HashMap<ConnectionToken, ClientStats>(this.clients);
                m.put(dc, cq);
                this.clients = m;
            }
        }
        return cq;
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().getTemporaryTopic(dc);
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().getTemporaryQueue(dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosing(ConnectionToken dc) throws JMSException {
        HashMap hashMap = this.clients;
        synchronized (hashMap) {
            HashMap m = new HashMap(this.clients);
            m.remove(dc);
            this.clients = m;
        }
        this.getNext().connectionClosing(dc);
    }

    public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().addMessage(dc, message);
    }

    public Queue createQueue(ConnectionToken dc, String dest) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().createQueue(dc, dest);
    }

    public Topic createTopic(ConnectionToken dc, String dest) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().createTopic(dc, dest);
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().deleteTemporaryDestination(dc, dest);
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().transact(dc, t);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().acknowledge(dc, item);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().browse(dc, dest, selector);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().receive(dc, subscriberId, wait);
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().setEnabled(dc, enabled);
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().unsubscribe(dc, subscriptionId);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().destroySubscription(dc, id);
    }

    public void subscribe(ConnectionToken dc, Subscription s) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().subscribe(dc, s);
    }

    public void ping(ConnectionToken dc, long clientTime) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        this.getNext().ping(dc, clientTime);
    }

    public Subscription getSubscription(ConnectionToken dc, int subscriberId) throws JMSException {
        this.getClientStats(dc).lastUsed = System.currentTimeMillis();
        return this.getNext().getSubscription(dc, subscriberId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClientStats {
        private long lastUsed = System.currentTimeMillis();
        boolean disconnectIfInactive = true;

        private ClientStats() {
        }
    }
}

