/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DestinationFullException;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.ExclusiveQueue;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;
import org.jboss.mq.server.SelectorPersistentQueue;

public class JMSTopic
extends JMSDestination {
    HashMap durQueues = new HashMap();
    HashMap tempQueues = new HashMap();

    public JMSTopic(SpyDestination dest, ClientConsumer temporary, JMSDestinationManager server, BasicQueueParameters parameters) throws JMSException {
        super(dest, temporary, server, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator iter = this.durQueues.values().iterator();
            while (iter.hasNext()) {
                ((BasicQueue)iter.next()).clientConsumerStopped(clientConsumer);
            }
        }
        HashMap hashMap2 = this.tempQueues;
        synchronized (hashMap2) {
            Iterator iter = this.tempQueues.values().iterator();
            while (iter.hasNext()) {
                ((BasicQueue)iter.next()).clientConsumerStopped(clientConsumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscription sub) throws JMSException {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            ExclusiveQueue q = new ExclusiveQueue(this.server, this.destination, sub, this.parameters);
            q.createMessageCounter(this.destination.getName(), null, true, false, -1);
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                this.tempQueues.put(sub, q);
            }
        }
        PersistentQueue q = null;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            q = (PersistentQueue)this.durQueues.get(id);
        }
        boolean selectorChanged = false;
        if (q != null) {
            String newSelector = sub.messageSelector;
            String oldSelector = null;
            if (q instanceof SelectorPersistentQueue) {
                oldSelector = ((SelectorPersistentQueue)q).selectorString;
            }
            if (newSelector == null && oldSelector != null || newSelector != null && !newSelector.equals(oldSelector)) {
                selectorChanged = true;
            }
        }
        if (q == null || !q.destination.equals(topic) || selectorChanged) {
            this.server.getStateManager().setDurableSubscription(this.server, id, topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(Subscription sub) throws JMSException {
        BasicQueue queue = null;
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                queue = (BasicQueue)this.tempQueues.get(sub);
            }
        }
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            queue = (BasicQueue)this.durQueues.get(id);
        }
        if (queue == null) {
            ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
        } else {
            queue.removeSubscriber(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nackMessages(Subscription sub) throws JMSException {
        BasicQueue queue = null;
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            HashMap hashMap = this.tempQueues;
            synchronized (hashMap) {
                queue = (BasicQueue)this.tempQueues.get(sub);
            }
        }
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            queue = (BasicQueue)this.durQueues.get(id);
        }
        if (queue != null) {
            queue.nackMessages(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupSubscription(Subscription sub) {
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            BasicQueue queue = (BasicQueue)this.tempQueues.remove(sub);
            try {
                if (queue != null) {
                    queue.removeAllMessages();
                }
            }
            catch (JMSException e) {
                JMSDestination.cat.debug((Object)("Error removing messages for subscription " + sub), (Throwable)e);
            }
        }
    }

    public void addReceiver(Subscription sub) {
        this.getQueue(sub).addReceiver(sub);
    }

    public void removeReceiver(Subscription sub) {
        this.getQueue(sub).removeReceiver(sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreMessage(MessageReference messageRef) {
        block6: {
            try {
                BasicQueue queue;
                SpyMessage spyMessage = messageRef.getMessage();
                JMSTopic jMSTopic = this;
                synchronized (jMSTopic) {
                    this.messageIdCounter = Math.max(this.messageIdCounter, spyMessage.header.messageId + 1L);
                }
                if (spyMessage.header.durableSubscriberID == null) {
                    JMSDestination.cat.debug((Object)"Trying to restore message with null durableSubscriberID");
                    break block6;
                }
                messageRef.queue = queue = (BasicQueue)this.durQueues.get(spyMessage.header.durableSubscriberID);
                queue.restoreMessage(messageRef);
            }
            catch (JMSException e) {
                JMSDestination.cat.error((Object)"Could not restore message:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreMessage(SpyMessage message) {
        block6: {
            try {
                JMSTopic jMSTopic = this;
                synchronized (jMSTopic) {
                    this.messageIdCounter = Math.max(this.messageIdCounter, message.header.messageId + 1L);
                }
                if (message.header.durableSubscriberID == null) {
                    JMSDestination.cat.debug((Object)"Trying to restore message with null durableSubscriberID");
                    break block6;
                }
                BasicQueue queue = (BasicQueue)this.durQueues.get(message.header.durableSubscriberID);
                MessageReference messageRef = this.server.getMessageCache().add(message, queue, 2);
                queue.restoreMessage(messageRef);
            }
            catch (JMSException e) {
                JMSDestination.cat.error((Object)"Could not restore message:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDurableSubscription(DurableSubscriptionID id) throws JMSException {
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        SpyTopic dstopic = new SpyTopic((SpyTopic)this.destination, id);
        PersistentQueue queue = id.getSelector() == null ? new PersistentQueue(this.server, dstopic, this.parameters) : new SelectorPersistentQueue(this.server, dstopic, id.getSelector(), this.parameters);
        queue.createMessageCounter(this.destination.getName(), id.toString(), true, true, -1);
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            this.durQueues.put(id, queue);
        }
        this.server.getPersistenceManager().restoreQueue(this, dstopic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator i = this.durQueues.values().iterator();
            while (i.hasNext()) {
                PersistentQueue queue = (PersistentQueue)i.next();
                this.server.getPersistenceManager().closeQueue(this, queue.getSpyDestination());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyDurableSubscription(DurableSubscriptionID id) throws JMSException {
        BasicQueue queue;
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            queue = (BasicQueue)this.durQueues.remove(id);
        }
        queue.removeAllMessages();
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        return this.getQueue(sub).receive(sub, wait);
    }

    public void acknowledge(AcknowledgementRequest req, Subscription sub, Tx txId) throws JMSException {
        this.getQueue(sub).acknowledge(req, txId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SpyMessage message, Tx txId) throws JMSException {
        StringBuffer errorMessage = null;
        long messageId = 0L;
        JMSTopic jMSTopic = this;
        synchronized (jMSTopic) {
            MessageReference ref;
            SpyMessage clone;
            BasicQueue q;
            messageId = this.messageIdCounter++;
            HashMap hashMap = this.durQueues;
            synchronized (hashMap) {
                Iterator iter = this.durQueues.keySet().iterator();
                while (iter.hasNext()) {
                    DurableSubscriptionID id = (DurableSubscriptionID)iter.next();
                    q = (PersistentQueue)this.durQueues.get(id);
                    clone = message.myClone();
                    clone.header.durableSubscriberID = id;
                    clone.header.messageId = messageId;
                    clone.setJMSDestination(((PersistentQueue)q).getSpyDestination());
                    ref = this.server.getMessageCache().add(clone, q, 1);
                    try {
                        ((PersistentQueue)q).addMessage(ref, txId);
                    }
                    catch (DestinationFullException e) {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer(e.getText());
                            continue;
                        }
                        errorMessage.append(", ").append(e.getText());
                    }
                }
            }
            HashMap hashMap2 = this.tempQueues;
            synchronized (hashMap2) {
                Iterator iter = this.tempQueues.values().iterator();
                while (iter.hasNext()) {
                    q = (BasicQueue)iter.next();
                    clone = message.myClone();
                    clone.header.messageId = messageId;
                    ref = this.server.getMessageCache().add(clone, q, 1);
                    try {
                        q.addMessage(ref, txId);
                    }
                    catch (DestinationFullException e) {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer(e.getText());
                            continue;
                        }
                        errorMessage.append(", ").append(e.getText());
                    }
                }
            }
        }
        if (errorMessage != null) {
            throw new DestinationFullException(errorMessage.toString());
        }
    }

    public int getAllMessageCount() {
        return this.calculateMessageCount(this.getAllQueues());
    }

    public int getDurableMessageCount() {
        return this.calculateMessageCount(this.getPersistentQueues());
    }

    public int getNonDurableMessageCount() {
        return this.calculateMessageCount(this.getTemporaryQueues());
    }

    public ArrayList getAllQueues() {
        ArrayList result = new ArrayList(this.getAllSubscriptionsCount());
        result.addAll(this.getPersistentQueues());
        result.addAll(this.getTemporaryQueues());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTemporaryQueues() {
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            return new ArrayList(this.tempQueues.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPersistentQueues() {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            return new ArrayList(this.durQueues.values());
        }
    }

    public int getAllSubscriptionsCount() {
        return this.durQueues.size() + this.tempQueues.size();
    }

    public int getDurableSubscriptionsCount() {
        return this.durQueues.size();
    }

    public int getNonDurableSubscriptionsCount() {
        return this.tempQueues.size();
    }

    public ArrayList getAllSubscriptions() {
        ArrayList result = new ArrayList(this.getAllSubscriptionsCount());
        result.addAll(this.getDurableSubscriptions());
        result.addAll(this.getNonDurableSubscriptions());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDurableSubscriptions() {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            return new ArrayList(this.durQueues.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getNonDurableSubscriptions() {
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            return new ArrayList(this.tempQueues.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PersistentQueue getDurableSubscription(DurableSubscriptionID id) {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            return (PersistentQueue)this.durQueues.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicQueue getQueue(Subscription sub) {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id != null) {
            return this.getDurableSubscription(id);
        }
        HashMap hashMap = this.tempQueues;
        synchronized (hashMap) {
            return (BasicQueue)this.tempQueues.get(sub);
        }
    }

    public boolean isInUse() {
        if (this.tempQueues.size() > 0) {
            return true;
        }
        Iterator iter = this.durQueues.values().iterator();
        while (iter.hasNext()) {
            PersistentQueue q = (PersistentQueue)iter.next();
            if (!q.isInUse()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages() throws JMSException {
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator i = this.durQueues.values().iterator();
            while (i.hasNext()) {
                PersistentQueue queue = (PersistentQueue)i.next();
                queue.removeAllMessages();
            }
        }
    }

    private int calculateMessageCount(ArrayList queues) {
        int count = 0;
        ListIterator i = queues.listIterator();
        while (i.hasNext()) {
            BasicQueue queue = (BasicQueue)i.next();
            count += queue.getQueueDepth();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageCounter[] getMessageCounter() {
        TreeMap<String, MessageCounter> map = new TreeMap<String, MessageCounter>();
        HashMap hashMap = this.durQueues;
        synchronized (hashMap) {
            Iterator i = this.durQueues.values().iterator();
            while (i.hasNext()) {
                BasicQueue queue = (BasicQueue)i.next();
                MessageCounter counter = queue.getMessageCounter();
                if (counter == null) continue;
                String key = counter.getDestinationName() + counter.getDestinationSubscription();
                map.put(key, counter);
            }
        }
        HashMap hashMap2 = this.tempQueues;
        synchronized (hashMap2) {
            Iterator i = this.tempQueues.values().iterator();
            while (i.hasNext()) {
                BasicQueue queue = (BasicQueue)i.next();
                MessageCounter counter = queue.getMessageCounter();
                if (counter == null) continue;
                String key = counter.getDestinationName() + counter.getDestinationSubscription();
                map.put(key, counter);
            }
        }
        return map.values().toArray(new MessageCounter[0]);
    }
}

