/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jboss.mq.server.BasicQueue;

public class MessageCounter {
    String destName;
    String destSubscription;
    boolean destTopic;
    boolean destDurable;
    BasicQueue destQueue;
    int countTotal;
    int countTotalLast;
    int depthLast;
    long timeLastUpdate;
    int dayCounterMax;
    ArrayList dayCounter;

    public MessageCounter(String name, String subscription, BasicQueue queue, boolean topic, boolean durable, int daycountmax) {
        this.destName = name;
        this.destSubscription = subscription;
        this.destTopic = topic;
        this.destDurable = durable;
        this.destQueue = queue;
        this.resetCounter();
        this.dayCounter = new ArrayList();
        this.setHistoryLimit(daycountmax);
    }

    public String toString() {
        return this.getCounterAsString();
    }

    public void incrementCounter() {
        ++this.countTotal;
        this.timeLastUpdate = System.currentTimeMillis();
        this.updateHistory(true);
    }

    public String getDestinationName() {
        return this.destName;
    }

    public String getDestinationSubscription() {
        return this.destSubscription;
    }

    public boolean getDestinationTopic() {
        return this.destTopic;
    }

    public boolean getDestinationDurable() {
        return this.destDurable;
    }

    public int getCount() {
        return this.countTotal;
    }

    public int getCountDelta() {
        int delta = this.countTotal - this.countTotalLast;
        this.countTotalLast = this.countTotal;
        return delta;
    }

    public int getDepth() {
        return this.destQueue.getQueueDepth();
    }

    public int getDepthDelta() {
        int current = this.destQueue.getQueueDepth();
        int delta = current - this.depthLast;
        this.depthLast = current;
        return delta;
    }

    public long getLastUpdate() {
        return this.timeLastUpdate;
    }

    public void resetCounter() {
        this.countTotal = 0;
        this.countTotalLast = 0;
        this.depthLast = 0;
        this.timeLastUpdate = 0L;
    }

    public String getCounterAsString() {
        String ret = this.destTopic ? "Topic," : "Queue,";
        ret = ret + this.destName + ",";
        ret = this.destSubscription != null ? ret + this.destSubscription + "," : ret + "-,";
        ret = this.destTopic ? (this.destDurable ? ret + "true," : ret + "false,") : ret + "-,";
        ret = ret + this.getCount() + "," + this.getCountDelta() + "," + this.getDepth() + "," + this.getDepthDelta() + ",";
        if (this.timeLastUpdate > 0L) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            ret = ret + dateFormat.format(new Date(this.timeLastUpdate));
        } else {
            ret = ret + "-";
        }
        return ret;
    }

    public int getHistoryLimit() {
        return this.dayCounterMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryLimit(int daycountmax) {
        boolean bInitialize = false;
        this.dayCounterMax = daycountmax;
        ArrayList arrayList = this.dayCounter;
        synchronized (arrayList) {
            if (this.dayCounterMax > 0) {
                int delta = this.dayCounter.size() - this.dayCounterMax;
                int i = 0;
                while (i < delta) {
                    this.dayCounter.remove(0);
                    ++i;
                }
                bInitialize = this.dayCounter.isEmpty();
            } else if (this.dayCounterMax == 0) {
                this.dayCounter.clear();
            } else {
                bInitialize = this.dayCounter.isEmpty();
            }
            if (bInitialize) {
                this.dayCounter.add(new DayCounter(new GregorianCalendar(), true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(boolean incrementCounter) {
        if (this.dayCounter.isEmpty()) {
            return;
        }
        ArrayList arrayList = this.dayCounter;
        synchronized (arrayList) {
            DayCounter counterLast = (DayCounter)this.dayCounter.get(this.dayCounter.size() - 1);
            GregorianCalendar calNow = new GregorianCalendar();
            GregorianCalendar calLast = counterLast.getDate();
            calNow.clear(10);
            calNow.clear(11);
            calNow.clear(12);
            calNow.clear(13);
            calNow.clear(14);
            calLast.clear(10);
            calLast.clear(11);
            calLast.clear(12);
            calLast.clear(13);
            calLast.clear(14);
            long millisPerDay = 86400000L;
            long millisDelta = calNow.getTime().getTime() - calLast.getTime().getTime();
            int dayDelta = (int)(millisDelta / millisPerDay);
            if (dayDelta > 0) {
                DayCounter counterNew;
                counterLast.finalizeDayCounter();
                int i = 1;
                while (i < dayDelta) {
                    calLast.add(6, 1);
                    counterNew = new DayCounter(calLast, false);
                    counterNew.finalizeDayCounter();
                    this.dayCounter.add(counterNew);
                    ++i;
                }
                counterNew = new DayCounter(calNow, false);
                this.dayCounter.add(counterNew);
                this.setHistoryLimit(this.dayCounterMax);
            }
            counterLast = (DayCounter)this.dayCounter.get(this.dayCounter.size() - 1);
            counterLast.updateDayCounter(incrementCounter);
        }
    }

    public void resetHistory() {
        int max = this.dayCounterMax;
        this.setHistoryLimit(0);
        this.setHistoryLimit(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryAsString() {
        String ret = "";
        this.updateHistory(false);
        ArrayList arrayList = this.dayCounter;
        synchronized (arrayList) {
            ret = ret + this.dayCounter.size() + "\n";
            int i = 0;
            while (i < this.dayCounter.size()) {
                DayCounter counter = (DayCounter)this.dayCounter.get(i);
                ret = ret + counter.getDayCounterAsString() + "\n";
                ++i;
            }
        }
        return ret;
    }

    class DayCounter {
        static final int HOURS = 24;
        GregorianCalendar date = null;
        int[] counters = new int[24];

        DayCounter(GregorianCalendar date, boolean isStartDay) {
            this.date = (GregorianCalendar)date.clone();
            int hour = date.get(11);
            int i = 0;
            while (i < 24) {
                this.counters[i] = i < hour ? (isStartDay ? -1 : 0) : -1;
                ++i;
            }
            this.counters[hour] = 0;
        }

        GregorianCalendar getDate() {
            return (GregorianCalendar)this.date.clone();
        }

        void updateDayCounter(boolean incrementCounter) {
            GregorianCalendar cal = new GregorianCalendar();
            int currentIndex = cal.get(11);
            boolean bUpdate = false;
            int i = 0;
            while (i <= currentIndex) {
                if (this.counters[i] > -1) {
                    bUpdate = true;
                }
                if (bUpdate && this.counters[i] == -1) {
                    this.counters[i] = 0;
                }
                ++i;
            }
            if (incrementCounter) {
                int n = currentIndex;
                this.counters[n] = this.counters[n] + 1;
            }
        }

        void finalizeDayCounter() {
            boolean bFinalize = false;
            int i = 0;
            while (i < 24) {
                if (this.counters[i] > -1) {
                    bFinalize = true;
                }
                if (bFinalize && this.counters[i] == -1) {
                    this.counters[i] = 0;
                }
                ++i;
            }
        }

        String getDayCounterAsString() {
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            String strData = dateFormat.format(this.date.getTime());
            int i = 0;
            while (i < 24) {
                strData = strData + "," + this.counters[i];
                ++i;
            }
            return strData;
        }
    }
}

