/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.lang.ref.SoftReference;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.PersistentQueue;

public class MessageReference
implements Comparable {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$server$MessageReference == null ? (class$org$jboss$mq$server$MessageReference = MessageReference.class$("org.jboss.mq.server.MessageReference")) : class$org$jboss$mq$server$MessageReference));
    public static final int NOT_STORED = 1;
    public static final int STORED = 2;
    public static final int REMOVED = 3;
    public long referenceId;
    public SpyMessage hardReference;
    public byte jmsPriority;
    public long messageId;
    public int jmsDeliveryMode;
    public long messageScheduledDelivery;
    public long messageExpiration;
    public BasicQueue queue;
    public MessageCache messageCache;
    public SoftReference softReference;
    public int stored;
    public transient Object persistData;
    static /* synthetic */ Class class$org$jboss$mq$server$MessageReference;

    MessageReference() {
    }

    void init(MessageCache messageCache, long referenceId, SpyMessage message, BasicQueue queue) throws JMSException {
        this.messageCache = messageCache;
        this.hardReference = message;
        this.referenceId = referenceId;
        this.jmsPriority = (byte)message.getJMSPriority();
        this.messageId = message.header.messageId;
        this.stored = 1;
        this.jmsDeliveryMode = message.header.jmsDeliveryMode;
        if (message.propertyExists("JMS_JBOSS_SCHEDULED_DELIVERY")) {
            this.messageScheduledDelivery = message.getLongProperty("JMS_JBOSS_SCHEDULED_DELIVERY");
        }
        this.messageExpiration = message.header.jmsExpiration;
        this.queue = queue;
        this.persistData = null;
    }

    void reset() {
        if (this.hardReference != null) {
            MessagePool.releaseMessage(this.hardReference);
        } else {
            this.hardReference = (SpyMessage)this.softReference.get();
            if (this.hardReference != null) {
                MessagePool.releaseMessage(this.hardReference);
            }
        }
        if (this.softReference != null && this.softReference.get() != null) {
            --this.messageCache.softRefCacheSize;
        }
        this.messageCache = null;
        this.hardReference = null;
        this.softReference = null;
        this.queue = null;
        this.stored = 0;
        this.jmsDeliveryMode = 0;
        this.persistData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpyMessage getMessage() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getMessage lock aquire " + this.toString()));
        }
        SpyMessage result = null;
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.hardReference == null) {
                this.makeHard();
                result = this.hardReference;
                this.messageCache.messageReferenceUsedEvent(this, false, trace);
            } else {
                result = this.hardReference;
                ++this.messageCache.cacheHits;
                this.messageCache.messageReferenceUsedEvent(this, true, trace);
            }
            if (trace) {
                log.trace((Object)("getMessage lock released " + this.toString()));
            }
            return result;
        }
    }

    public boolean isExpired() {
        if (this.messageExpiration == 0L) {
            return false;
        }
        long ts = System.currentTimeMillis();
        return this.messageExpiration < ts;
    }

    public boolean isPersistent() {
        return this.queue instanceof PersistentQueue && this.jmsDeliveryMode == 2;
    }

    public String getPersistentKey() {
        return this.queue.getDescription();
    }

    public SpyMessage.Header getHeaders() throws JMSException {
        return this.getMessage().header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("clear lock aquire " + this.toString()));
        }
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 2) {
                this.messageCache.removeFromStorage(this);
            }
            this.stored = 3;
            if (trace) {
                log.trace((Object)("clear lock relased " + this.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("invalidate lock aquire " + this.toString()));
        }
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 2) {
                if (this.hardReference == null) {
                    this.makeHard();
                    this.messageCache.messageReferenceUsedEvent(this, false, trace);
                }
                this.messageCache.removeFromStorage(this);
            }
            if (trace) {
                log.trace((Object)("invalidate lock relased " + this.toString()));
            }
        }
    }

    public void removeDelayed() throws JMSException {
        this.messageCache.removeDelayed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeSoft() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("makeSoft lock aquire " + this.toString()));
        }
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 3) {
                throw new JMSException("CACHE ERROR: makeSoft() on a removed message " + this);
            }
            if (this.softReference != null) {
                if (this.stored == 1) {
                    throw new JMSException("CACHE ERROR: soft reference to unstored message " + this);
                }
                return;
            }
            if (this.stored == 1) {
                this.messageCache.saveToStorage(this, this.hardReference);
            }
            if (this.stored != 2) {
                if (trace) {
                    log.trace((Object)("saveToStorage rejected by cache " + this.toString()));
                }
                return;
            }
            this.softReference = new SoftReference<SpyMessage>(this.hardReference, this.messageCache.referenceQueue);
            this.messageCache.soften(this);
            this.hardReference = null;
            if (trace) {
                log.trace((Object)("makeSoft lock released " + this.toString()));
            }
        }
    }

    public void setStored(int stored) {
        this.stored = stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeHard() throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("makeHard lock aquire " + this.toString()));
        }
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 3) {
                throw new JMSException("CACHE ERROR: makeHard() on a removed message " + this);
            }
            if (this.hardReference != null) {
                return;
            }
            this.hardReference = (SpyMessage)this.softReference.get();
            if (this.hardReference == null) {
                this.hardReference = this.messageCache.loadFromStorage(this);
                ++this.messageCache.cacheMisses;
            } else {
                ++this.messageCache.cacheHits;
            }
            if (this.softReference != null && this.softReference.get() != null) {
                --this.messageCache.softRefCacheSize;
            }
            this.softReference = null;
            if (trace) {
                log.trace((Object)("makeHard lock released " + this.toString()));
            }
        }
    }

    public boolean equals(Object o) {
        try {
            return this.referenceId == ((MessageReference)o).referenceId;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int compareTo(Object o) {
        MessageReference sm = (MessageReference)o;
        if (this.jmsPriority > sm.jmsPriority) {
            return -1;
        }
        if (this.jmsPriority < sm.jmsPriority) {
            return 1;
        }
        return (int)(this.messageId - sm.messageId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        if (this.messageCache == null) {
            buffer.append(" NOT IN CACHE hashCode=").append(this.hashCode());
        } else {
            buffer.append(this.referenceId);
            buffer.append(" msg=").append(this.messageId);
            if (this.hardReference != null) {
                buffer.append(" hard");
            }
            if (this.softReference != null) {
                buffer.append(" soft");
            }
            switch (this.stored) {
                case 1: {
                    buffer.append(" NOT_STORED");
                    break;
                }
                case 2: {
                    buffer.append(" STORED");
                    break;
                }
                case 3: {
                    buffer.append(" REMOVED");
                }
            }
            switch (this.jmsDeliveryMode) {
                case 1: {
                    buffer.append(" NON_PERSISTENT");
                    break;
                }
                case 2: {
                    buffer.append(" PERSISTENT");
                }
            }
            if (this.persistData != null) {
                buffer.append(" persistData=").append(this.persistData);
            }
            if (this.queue != null) {
                buffer.append(" queue=").append(this.queue.getDescription());
            } else {
                buffer.append(" NO_QUEUE");
            }
            buffer.append(" priority=").append(this.jmsPriority);
            buffer.append(" hashCode=").append(this.hashCode());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

