/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import EDU.oswego.cs.dl.util.concurrent.Heap;
import org.jboss.mq.server.SimpleTimerTask;

final class SimpleTimer
extends Thread {
    private static int creationCount = 0;
    private Heap heap = new Heap(16);
    private boolean canceled = false;

    public SimpleTimer() {
        this.setName("SimpleTimer-" + creationCount++);
        this.setDaemon(true);
    }

    public int size() {
        return this.heap.size();
    }

    public void clear() {
        this.heap.clear();
    }

    public synchronized void cancel() {
        this.clear();
        this.canceled = true;
        this.interrupt();
    }

    private SimpleTimerTask peekNextTask() {
        return (SimpleTimerTask)this.heap.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SimpleTimerTask task, long at) {
        task.scheduled = at;
        SimpleTimer simpleTimer = this;
        synchronized (simpleTimer) {
            if (!this.isAlive()) {
                this.start();
            }
            this.heap.insert((Object)task);
            if (task == this.peekNextTask()) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                SimpleTimerTask task;
                boolean execute = false;
                SimpleTimer simpleTimer = this;
                synchronized (simpleTimer) {
                    while ((task = this.peekNextTask()) == null && !this.canceled) {
                        this.wait();
                    }
                    if (this.canceled) {
                        break;
                    }
                    long now = System.currentTimeMillis();
                    long duration = task.scheduled - now;
                    if (duration > 0L) {
                        this.wait(duration);
                    } else {
                        execute = true;
                        this.heap.extract();
                    }
                }
                if (!execute) continue;
                task.run();
            }
            catch (InterruptedException e) {}
        }
    }

    protected void finalize() {
        this.cancel();
    }
}

