/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.StringTokenizer;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.jmx.DestinationMBean;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public abstract class DestinationMBeanSupport
extends ServiceMBeanSupport
implements DestinationMBean,
MBeanRegistration {
    SpyDestination spyDest;
    String destinationName;
    String jndiName;
    boolean jndiBound;
    ObjectName jbossMQService;
    Element securityConf;
    BasicQueueParameters parameters = new BasicQueueParameters();
    ObjectName securityManager;

    public ObjectName getDestinationManager() {
        return this.jbossMQService;
    }

    public void setDestinationManager(ObjectName jbossMQService) {
        this.jbossMQService = jbossMQService;
    }

    protected SpyDestination getSpyDest() {
        return this.spyDest;
    }

    public void setSecurityConf(Element securityConf) throws Exception {
        this.log.debug((Object)("Setting securityConf: " + securityConf));
        this.securityConf = securityConf;
    }

    protected Element getSecurityConf() {
        return this.securityConf;
    }

    public void setSecurityManager(ObjectName securityManager) {
        this.securityManager = securityManager;
    }

    protected ObjectName getSecurityManager() {
        return this.securityManager;
    }

    public void startService() throws Exception {
        if (this.securityManager != null) {
            this.getServer().invoke(this.securityManager, "addDestination", new Object[]{this.spyDest.getName(), this.securityConf}, new String[]{"java.lang.String", "org.w3c.dom.Element"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        if (this.jndiBound) {
            InitialContext ctx = new InitialContext();
            try {
                Util.unbind((Context)ctx, (String)this.jndiName);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ctx.close();
                throw throwable;
            }
            ctx.close();
            this.jndiName = null;
            this.jndiBound = false;
        }
        if (this.securityManager != null) {
            this.getServer().invoke(this.securityManager, "removeDestination", new Object[]{this.spyDest.getName()}, new String[]{"java.lang.String"});
        }
    }

    protected void destroyService() throws Exception {
        JMSDestinationManager jmsServer = (JMSDestinationManager)this.server.getAttribute(this.jbossMQService, "Interceptor");
        if (jmsServer != null) {
            jmsServer.closeDestination(this.spyDest);
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.destinationName = name.getKeyProperty("name");
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new MalformedObjectNameException("Property 'name' not provided");
        }
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.destinationName));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setJNDIName(String name) throws Exception {
        if (this.spyDest == null) {
            this.jndiName = name;
            return;
        }
        if (name == null) {
            throw new InvalidAttributeValueException("Destination JNDI names can not be null");
        }
        InitialContext ic = new InitialContext();
        try {
            if (this.jndiName != null && this.jndiBound) {
                Util.unbind((Context)ic, (String)this.jndiName);
                this.jndiName = null;
                this.jndiBound = false;
            }
            Util.rebind((Context)ic, (String)name, (Object)this.spyDest);
            this.jndiName = name;
            this.jndiBound = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ic.close();
            throw throwable;
        }
        ic.close();
        this.log.info((Object)("Bound to JNDI name: " + this.jndiName));
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public abstract MessageCounter[] getMessageCounter();

    public String listMessageCounter() {
        MessageCounter[] counter = this.getMessageCounter();
        String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
        int i = 0;
        while (i < counter.length) {
            String data = counter[i].getCounterAsString();
            StringTokenizer token = new StringTokenizer(data, ",");
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            String value = token.nextToken();
            if (value.equalsIgnoreCase("0")) {
                value = "-";
            }
            ret = ret + "<td>" + value + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            value = token.nextToken();
            if (value.equalsIgnoreCase("0")) {
                value = "-";
            }
            ret = ret + "<td>" + value + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "</tr>";
            ++i;
        }
        ret = ret + "</table>";
        return ret;
    }

    public void resetMessageCounter() {
        MessageCounter[] counter = this.getMessageCounter();
        int i = 0;
        while (i < counter.length) {
            counter[i].resetCounter();
            ++i;
        }
    }

    public String listMessageCounterHistory() {
        MessageCounter[] counter = this.getMessageCounter();
        String ret = "";
        int i = 0;
        while (i < counter.length) {
            ret = ret + (counter[i].getDestinationTopic() ? "Topic '" : "Queue '");
            ret = ret + counter[i].getDestinationName() + "'";
            if (counter[i].getDestinationSubscription() != null) {
                ret = ret + "Subscription '" + counter[i].getDestinationSubscription() + "'";
            }
            ret = ret + "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Date</th>";
            int j = 0;
            while (j < 24) {
                ret = ret + "<th width=\"4%\">" + j + "</th>";
                ++j;
            }
            ret = ret + "<th>Total</th></tr>";
            StringTokenizer tokens = new StringTokenizer(counter[i].getHistoryAsString(), ",\n");
            int days = Integer.parseInt(tokens.nextToken());
            int j2 = 0;
            while (j2 < days) {
                ret = ret + "<tr bgcolor=\"#" + (j2 % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ret = ret + "<td>" + tokens.nextToken() + "</td>";
                int total = 0;
                int k = 0;
                while (k < 24) {
                    int value = Integer.parseInt(tokens.nextToken().trim());
                    if (value == -1) {
                        ret = ret + "<td></td>";
                    } else {
                        ret = ret + "<td>" + value + "</td>";
                        total += value;
                    }
                    ++k;
                }
                ret = ret + "<td>" + total + "</td></tr>";
                ++j2;
            }
            ret = ret + "</table><br><br>";
            ++i;
        }
        return ret;
    }

    public void resetMessageCounterHistory() {
        MessageCounter[] counter = this.getMessageCounter();
        int i = 0;
        while (i < counter.length) {
            counter[i].resetHistory();
            ++i;
        }
    }

    public void setMessageCounterHistoryDayLimit(int days) {
        if (days < -1) {
            days = -1;
        }
        MessageCounter[] counter = this.getMessageCounter();
        int i = 0;
        while (i < counter.length) {
            counter[i].setHistoryLimit(days);
            ++i;
        }
    }

    public int getMessageCounterHistoryDayLimit() {
        MessageCounter[] counter = this.getMessageCounter();
        int days = 0;
        if (counter.length > 0) {
            days = counter[0].getHistoryLimit();
        }
        return days;
    }

    public int getMaxDepth() {
        return this.parameters.maxDepth;
    }

    public void setMaxDepth(int depth) {
        this.parameters.maxDepth = depth;
    }
}

