/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.sm.AbstractStateManager;
import org.jboss.mq.sm.StateManager;
import org.jboss.mq.sm.jdbc.JDBCStateManagerMBean;
import org.jboss.tm.TransactionManagerService;

public class JDBCStateManager
extends AbstractStateManager
implements JDBCStateManagerMBean {
    static final Logger log = Logger.getLogger((Class)(class$org$jboss$mq$sm$jdbc$JDBCStateManager == null ? (class$org$jboss$mq$sm$jdbc$JDBCStateManager = JDBCStateManager.class$("org.jboss.mq.sm.jdbc.JDBCStateManager")) : class$org$jboss$mq$sm$jdbc$JDBCStateManager));
    private ObjectName connectionManagerName;
    private DataSource dataSource;
    private boolean hasSecurityManager = true;
    private TransactionManager tm;
    private Properties sqlProperties = new Properties();
    private boolean createTables = true;
    private String CREATE_USER_TABLE = "CREATE TABLE JMS_USERS (USERID VARCHAR(32) NOT NULL, PASSWD VARCHAR(32) NOT NULL, CLIENTID VARCHAR(128), PRIMARY KEY(USERID))";
    private String CREATE_ROLE_TABLE = "CREATE TABLE JMS_ROLES (ROLEID VARCHAR(32) NOT NULL, USERID VARCHAR(32) NOT NULL, PRIMARY KEY(USERID, ROLEID))";
    private String CREATE_SUBSCRIPTION_TABLE = "CREATE TABLE JMS_SUBSCRIPTIONS (CLIENTID VARCHAR(128) NOT NULL, NAME VARCHAR(128) NOT NULL, TOPIC VARCHAR(255) NOT NULL, SELECTOR VARCHAR(255), PRIMARY KEY(CLIENTID, NAME))";
    private String GET_SUBSCRIPTION = "SELECT TOPIC, SELECTOR FROM JMS_SUBSCRIPTIONS WHERE CLIENTID=? AND NAME=?";
    private String GET_SUBSCRIPTIONS_FOR_TOPIC = "SELECT CLIENTID, NAME, SELECTOR FROM JMS_SUBSCRIPTIONS WHERE TOPIC=?";
    private String LOCK_SUBSCRIPTION = "SELECT TOPIC, SELECTOR FROM JMS_SUBSCRIPTIONS WHERE CLIENTID=? AND NAME=?";
    private String INSERT_SUBSCRIPTION = "INSERT INTO JMS_SUBSCRIPTIONS (CLIENTID, NAME, TOPIC, SELECTOR) VALUES(?,?,?,?)";
    private String UPDATE_SUBSCRIPTION = "UPDATE JMS_SUBSCRIPTIONS SET TOPIC=?, SELECTOR=? WHERE CLIENTID=? AND NAME=?";
    private String REMOVE_SUBSCRIPTION = "DELETE FROM JMS_SUBSCRIPTIONS WHERE CLIENTID=? AND NAME=?";
    private String GET_USER_BY_CLIENTID = "SELECT USERID, PASSWD, CLIENTID FROM JMS_USERS WHERE CLIENTID=?";
    private String GET_USER = "SELECT PASSWD, CLIENTID FROM JMS_USERS WHERE USERID=?";
    static /* synthetic */ Class class$org$jboss$mq$sm$jdbc$JDBCStateManager;

    public ObjectName getConnectionManager() {
        return this.connectionManagerName;
    }

    public void setConnectionManager(ObjectName connectionManagerName) {
        this.connectionManagerName = connectionManagerName;
    }

    public boolean hasSecurityManager() {
        return this.hasSecurityManager;
    }

    public void setHasSecurityManager(boolean hasSecurityManager) {
        this.hasSecurityManager = hasSecurityManager;
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException shouldnothappen) {}
    }

    protected AbstractStateManager.DurableSubscription getDurableSubscription(DurableSubscriptionID sub) throws JMSException {
        AbstractStateManager.DurableSubscription durableSubscription;
        ResultSet rs;
        JDBCSession session;
        block5: {
            session = new JDBCSession();
            PreparedStatement statement = session.prepareStatement(this.GET_SUBSCRIPTION);
            statement.setString(1, sub.getClientID());
            statement.setString(2, sub.getSubscriptionName());
            rs = statement.executeQuery();
            if (rs.next()) break block5;
            AbstractStateManager.DurableSubscription durableSubscription2 = null;
            Object var8_7 = null;
            session.close();
            return durableSubscription2;
        }
        try {
            durableSubscription = new AbstractStateManager.DurableSubscription(sub.getClientID(), sub.getSubscriptionName(), rs.getString(1), rs.getString(2));
            Object var8_8 = null;
        }
        catch (SQLException e) {
            try {
                session.setRollbackOnly();
                throw new SpyJMSException("Error getting durable subscription " + sub, e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                session.close();
                throw throwable;
            }
        }
        session.close();
        return durableSubscription;
    }

    protected void saveDurableSubscription(AbstractStateManager.DurableSubscription ds) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            try {
                PreparedStatement statement = session.prepareStatement(this.LOCK_SUBSCRIPTION);
                statement.setString(1, ds.getClientID());
                statement.setString(2, ds.getName());
                ResultSet rs = statement.executeQuery();
                if (!rs.next()) {
                    statement = session.prepareStatement(this.INSERT_SUBSCRIPTION);
                    statement.setString(1, ds.getClientID());
                    statement.setString(2, ds.getName());
                    statement.setString(3, ds.getTopic());
                    statement.setString(4, ds.getSelector());
                } else {
                    statement = session.prepareStatement(this.UPDATE_SUBSCRIPTION);
                    statement.setString(1, ds.getTopic());
                    statement.setString(2, ds.getSelector());
                    statement.setString(3, ds.getClientID());
                    statement.setString(4, ds.getName());
                }
                if (statement.executeUpdate() != 1) {
                    session.setRollbackOnly();
                    throw new SpyJMSException("Insert subscription failed " + ds);
                }
                Object var6_6 = null;
            }
            catch (SQLException e) {
                session.setRollbackOnly();
                throw new SpyJMSException("Error saving durable subscription " + ds, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            session.close();
            throw throwable;
        }
        session.close();
    }

    protected void removeDurableSubscription(AbstractStateManager.DurableSubscription ds) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            try {
                PreparedStatement statement = session.prepareStatement(this.REMOVE_SUBSCRIPTION);
                statement.setString(1, ds.getClientID());
                statement.setString(2, ds.getName());
                if (statement.executeUpdate() != 1) {
                    throw new JMSException("Durable subscription does not exist " + ds);
                }
                Object var5_5 = null;
            }
            catch (SQLException e) {
                session.setRollbackOnly();
                throw new SpyJMSException("Error removing durable subscription " + ds, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            session.close();
            throw throwable;
        }
        session.close();
    }

    public Collection getDurableSubscriptionIdsForTopic(SpyTopic topic) throws JMSException {
        ArrayList<DurableSubscriptionID> arrayList;
        ArrayList<DurableSubscriptionID> result = new ArrayList<DurableSubscriptionID>();
        JDBCSession session = new JDBCSession();
        try {
            PreparedStatement statement = session.prepareStatement(this.GET_SUBSCRIPTIONS_FOR_TOPIC);
            statement.setString(1, topic.getName());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                result.add(new DurableSubscriptionID(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            arrayList = result;
            Object var8_8 = null;
        }
        catch (SQLException e) {
            try {
                session.setRollbackOnly();
                throw new SpyJMSException("Error getting durable subscriptions for topic " + topic, e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                session.close();
                throw throwable;
            }
        }
        session.close();
        return arrayList;
    }

    protected void checkLoggedOnClientId(String clientID) throws JMSException {
        JDBCSession session = new JDBCSession();
        try {
            try {
                PreparedStatement statement = session.prepareStatement(this.GET_USER_BY_CLIENTID);
                statement.setString(1, clientID);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    throw new InvalidClientIDException("This client id is password protected " + clientID);
                }
                Object var6_6 = null;
            }
            catch (SQLException e) {
                session.setRollbackOnly();
                throw new SpyJMSException("Error checking logged on client id " + clientID, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            session.close();
            throw throwable;
        }
        session.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPreconfClientId(String logon, String passwd) throws JMSException {
        String string;
        JDBCSession session;
        block8: {
            String string2;
            block7: {
                session = new JDBCSession();
                try {
                    try {
                        PreparedStatement statement = session.prepareStatement(this.GET_USER);
                        statement.setString(1, logon);
                        ResultSet rs = statement.executeQuery();
                        if (!rs.next()) {
                            if (!this.hasSecurityManager) throw new JMSSecurityException("This user does not exist " + logon);
                            string2 = null;
                            Object var8_9 = null;
                            break block7;
                        }
                        if (!this.hasSecurityManager && !passwd.equals(rs.getString(1))) {
                            throw new JMSSecurityException("Bad password for user " + logon);
                        }
                        string = rs.getString(2);
                        break block8;
                    }
                    catch (SQLException e) {
                        session.setRollbackOnly();
                        throw new SpyJMSException("Error retrieving preconfigured user " + logon, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    session.close();
                    throw throwable;
                }
            }
            session.close();
            return string2;
        }
        Object var8_10 = null;
        session.close();
        return string;
    }

    public StateManager getInstance() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        if (this.connectionManagerName == null) {
            throw new IllegalStateException("No connection manager configured");
        }
        String dsName = (String)this.getServer().getAttribute(this.connectionManagerName, "JndiName");
        InitialContext ctx = new InitialContext();
        try {
            this.dataSource = (DataSource)ctx.lookup("java:/" + dsName);
            this.tm = (TransactionManager)ctx.lookup(TransactionManagerService.JNDI_NAME);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        this.initDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDB() throws Exception {
        this.CREATE_USER_TABLE = this.sqlProperties.getProperty("CREATE_USER_TABLE", this.CREATE_USER_TABLE);
        this.CREATE_ROLE_TABLE = this.sqlProperties.getProperty("CREATE_ROLE_TABLE", this.CREATE_ROLE_TABLE);
        this.CREATE_SUBSCRIPTION_TABLE = this.sqlProperties.getProperty("CREATE_SUBSCRIPTION_TABLE", this.CREATE_SUBSCRIPTION_TABLE);
        this.GET_SUBSCRIPTION = this.sqlProperties.getProperty("GET_SUBSCRIPTION", this.GET_SUBSCRIPTION);
        this.GET_SUBSCRIPTIONS_FOR_TOPIC = this.sqlProperties.getProperty("GET_SUBSCRIPTIONS_FOR_TOPIC", this.GET_SUBSCRIPTIONS_FOR_TOPIC);
        this.LOCK_SUBSCRIPTION = this.sqlProperties.getProperty("LOCK_SUBSCRIPTION", this.LOCK_SUBSCRIPTION);
        this.INSERT_SUBSCRIPTION = this.sqlProperties.getProperty("INSERT_SUBSCRIPTION", this.INSERT_SUBSCRIPTION);
        this.UPDATE_SUBSCRIPTION = this.sqlProperties.getProperty("UPDATE_SUBSCRIPTION", this.UPDATE_SUBSCRIPTION);
        this.REMOVE_SUBSCRIPTION = this.sqlProperties.getProperty("REMOVE_SUBSCRIPTION", this.REMOVE_SUBSCRIPTION);
        this.GET_USER_BY_CLIENTID = this.sqlProperties.getProperty("GET_USER_BY_CLIENTID", this.GET_USER_BY_CLIENTID);
        this.GET_USER = this.sqlProperties.getProperty("GET_USER", this.GET_USER);
        this.createTables = this.sqlProperties.getProperty("CREATE_TABLES_ON_START_UP", "true").equalsIgnoreCase("true");
        if (this.createTables) {
            JDBCSession session = new JDBCSession();
            try {
                PreparedStatement statement;
                try {
                    statement = session.prepareStatement(this.CREATE_USER_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.debug((Object)("Error creating table: " + this.CREATE_USER_TABLE), (Throwable)ignored);
                }
                try {
                    statement = session.prepareStatement(this.CREATE_ROLE_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.debug((Object)("Error creating table: " + this.CREATE_ROLE_TABLE), (Throwable)ignored);
                }
                try {
                    statement = session.prepareStatement(this.CREATE_SUBSCRIPTION_TABLE);
                    statement.executeUpdate();
                }
                catch (SQLException ignored) {
                    log.debug((Object)("Error creating table: " + this.CREATE_SUBSCRIPTION_TABLE), (Throwable)ignored);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                session.close();
                throw throwable;
            }
            session.close();
            {
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JDBCSession {
        boolean trace = log.isTraceEnabled();
        Transaction threadTx;
        Connection connection;
        HashSet statements = new HashSet();

        JDBCSession() throws JMSException {
            try {
                this.threadTx = JDBCStateManager.this.tm.suspend();
                JDBCStateManager.this.tm.begin();
                this.connection = JDBCStateManager.this.dataSource.getConnection();
            }
            catch (Exception e) {
                block9: {
                    block8: {
                        try {
                            if (this.connection != null) {
                                this.connection.close();
                            }
                        }
                        catch (Throwable ignored) {
                            if (!this.trace) break block8;
                            log.trace((Object)"Unable to close connection", ignored);
                        }
                    }
                    try {
                        if (this.threadTx != null) {
                            JDBCStateManager.this.tm.resume(this.threadTx);
                        }
                    }
                    catch (Throwable ignored) {
                        if (!this.trace) break block9;
                        log.trace((Object)("Unable to resume transaction " + this.threadTx), ignored);
                    }
                }
                throw new SpyJMSException("Error creating connection to the database.", e);
            }
        }

        PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement result = this.connection.prepareStatement(sql);
            this.statements.add(result);
            return result;
        }

        void setRollbackOnly() throws JMSException {
            try {
                JDBCStateManager.this.tm.setRollbackOnly();
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not mark the transaction for rollback.", e);
            }
        }

        void close() throws JMSException {
            block18: {
                Iterator i = this.statements.iterator();
                while (i.hasNext()) {
                    Statement s = (Statement)i.next();
                    try {
                        s.close();
                    }
                    catch (Throwable ignored) {
                        if (!this.trace) continue;
                        log.trace((Object)"Unable to close statement", ignored);
                    }
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (Throwable ignored) {
                    if (!this.trace) break block18;
                    log.trace((Object)"Unable to close connection", ignored);
                }
            }
            try {
                if (JDBCStateManager.this.tm.getStatus() == 1) {
                    JDBCStateManager.this.tm.rollback();
                } else {
                    JDBCStateManager.this.tm.commit();
                }
            }
            catch (Exception e) {
                throw new SpyJMSException("Could not commit/rollback a transaction with the transaction manager.", e);
            }
            finally {
                block20: {
                    try {
                        if (this.threadTx != null) {
                            JDBCStateManager.this.tm.resume(this.threadTx);
                        }
                    }
                    catch (Throwable ignored) {
                        if (!this.trace) break block20;
                        log.trace((Object)("Unable to resume transaction " + this.threadTx), ignored);
                    }
                }
            }
        }
    }
}

