/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.threadpool;

import java.util.ArrayList;
import java.util.LinkedList;
import org.jboss.mq.threadpool.Work;

public class ThreadPool {
    private String name;
    private boolean daemon;
    private ThreadGroup threadGroup;
    private ArrayList workers;
    private int maxWorkers;
    private int idleWorkers;
    private volatile boolean stopping;
    private LinkedList queue;

    public ThreadPool(String name, ThreadGroup threadGroup, int maxWorkers, boolean daemon) {
        if (name == null || threadGroup == null || maxWorkers <= 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.daemon = daemon;
        this.threadGroup = threadGroup;
        this.workers = new ArrayList();
        this.maxWorkers = maxWorkers;
        this.idleWorkers = 0;
        this.stopping = false;
        this.queue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        this.stopping = true;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
            this.queue.notifyAll();
        }
        ArrayList arrayList = this.workers;
        synchronized (arrayList) {
            while (this.workers.size() > 0) {
                try {
                    this.workers.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(Work work) {
        ArrayList arrayList = this.workers;
        synchronized (arrayList) {
            if (this.idleWorkers == 0 && !this.stopping && this.workers.size() < this.maxWorkers) {
                new WorkerThread(this.name + "-" + (this.workers.size() + 1)).start();
            }
        }
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.stopping) {
                return;
            }
            this.queue.addLast(work);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWork(Work work) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            while (this.queue.remove(work)) {
            }
        }
    }

    private class WorkerThread
    extends Thread {
        WorkerThread(String name) {
            super(ThreadPool.this.threadGroup, name);
            this.setDaemon(ThreadPool.this.daemon);
            ThreadPool.this.workers.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void idle() {
            try {
                try {
                    ArrayList arrayList = ThreadPool.this.workers;
                    synchronized (arrayList) {
                        ++ThreadPool.this.idleWorkers;
                    }
                    ThreadPool.this.queue.wait();
                }
                catch (InterruptedException ex) {
                    Object var4_4 = null;
                    ArrayList arrayList = ThreadPool.this.workers;
                    synchronized (arrayList) {
                        --ThreadPool.this.idleWorkers;
                        return;
                    }
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ArrayList arrayList2 = ThreadPool.this.workers;
                synchronized (arrayList2) {
                    --ThreadPool.this.idleWorkers;
                    throw throwable;
                }
            }
            ArrayList arrayList = ThreadPool.this.workers;
            synchronized (arrayList) {
                --ThreadPool.this.idleWorkers;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ThreadPool.this.stopping) {
                Work work = null;
                LinkedList linkedList = ThreadPool.this.queue;
                synchronized (linkedList) {
                    if (ThreadPool.this.queue.size() == 0) {
                        this.idle();
                    }
                    if (!ThreadPool.this.stopping && ThreadPool.this.queue.size() > 0) {
                        work = (Work)ThreadPool.this.queue.removeFirst();
                    }
                }
                if (work == null) continue;
                work.doWork();
            }
            ArrayList arrayList = ThreadPool.this.workers;
            synchronized (arrayList) {
                ThreadPool.this.workers.remove(this);
                ThreadPool.this.workers.notify();
            }
        }
    }
}

