/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ConsoleInputHandler
implements CallbackHandler {
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            BufferedReader br;
            InputStreamReader isr;
            String prompt;
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                prompt = nc.getPrompt();
                if (prompt == null) {
                    prompt = "Enter Username: ";
                }
                System.out.print(prompt);
                isr = new InputStreamReader(System.in);
                br = new BufferedReader(isr);
                try {
                    String username = br.readLine();
                    nc.setName(username);
                }
                catch (IOException e) {
                    throw new SecurityException("Failed to obtain username, ioe=" + e.getMessage());
                }
            } else if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                prompt = pc.getPrompt();
                if (prompt == null) {
                    prompt = "Enter Password: ";
                }
                System.out.print(prompt);
                isr = new InputStreamReader(System.in);
                br = new BufferedReader(isr);
                try {
                    String password = br.readLine();
                    pc.setPassword(password.toCharArray());
                }
                catch (IOException e) {
                    throw new SecurityException("Failed to obtain password, ioe=" + e.getMessage());
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            ++i;
        }
    }
}

