/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class RunAsLoginModule
implements LoginModule {
    private String roleName;
    private boolean pushedRole;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.roleName = (String)options.get("roleName");
        if (this.roleName == null) {
            this.roleName = "nobody";
        }
    }

    public boolean login() {
        SimplePrincipal runAsRole = new SimplePrincipal(this.roleName);
        SecurityAssociation.pushRunAsRole(runAsRole);
        this.pushedRole = true;
        return true;
    }

    public boolean commit() {
        return this.abort();
    }

    public boolean abort() {
        if (!this.pushedRole) {
            return false;
        }
        SecurityAssociation.popRunAsRole();
        return true;
    }

    public boolean logout() {
        return true;
    }
}

