/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JaasSecurityManager
implements SubjectSecurityManager,
RealmMapping {
    private String securityDomain;
    private CachePolicy domainCache;
    private CallbackHandler handler;
    private Method setSecurityInfo;
    protected Logger log;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo;
    static /* synthetic */ Class class$java$security$Principal;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$security$acl$Group;

    public static Subject getActiveSubject(String securityDomain) {
        Subject subject = null;
        return subject;
    }

    public static LoginContext getActiveSubjectLoginContext(String securityDomain, CallbackHandler handler) throws LoginException {
        LoginContext lc = null;
        Subject subject = JaasSecurityManager.getActiveSubject(securityDomain);
        if (subject == null) {
            throw new LoginException("No active subject found in securityDomain: " + securityDomain);
        }
        lc = handler != null ? new LoginContext(securityDomain, subject, handler) : new LoginContext(securityDomain, subject);
        return lc;
    }

    public JaasSecurityManager() {
        this("other", new SecurityAssociationHandler());
    }

    public JaasSecurityManager(String securityDomain, CallbackHandler handler) {
        this.securityDomain = securityDomain;
        this.handler = handler;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger((String)categoryName);
        Class[] sig = new Class[]{class$java$security$Principal == null ? (class$java$security$Principal = JaasSecurityManager.class$("java.security.Principal")) : class$java$security$Principal, class$java$lang$Object == null ? (class$java$lang$Object = JaasSecurityManager.class$("java.lang.Object")) : class$java$lang$Object};
        try {
            this.setSecurityInfo = handler.getClass().getMethod("setSecurityInfo", sig);
        }
        catch (Exception e) {
            String msg = "Failed to find setSecurityInfo(Princpal, Object) method in handler";
            throw new UndeclaredThrowableException(e, msg);
        }
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        this.log.debug((Object)("CachePolicy set to: " + domainCache));
    }

    public void flushCache() {
        if (this.domainCache != null) {
            this.domainCache.flush();
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Subject getActiveSubject() {
        return SecurityAssociation.getSubject();
    }

    public boolean isValid(Principal principal, Object credential) {
        return this.isValid(principal, credential, null);
    }

    public synchronized boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        Subject theSubject;
        DomainInfo cacheInfo = this.getCacheInfo(principal, true);
        boolean isValid = false;
        if (cacheInfo != null) {
            isValid = this.validateCache(cacheInfo, credential);
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential);
        }
        if (isValid && activeSubject != null && (theSubject = this.getActiveSubject()) != null) {
            Set<Principal> principals = theSubject.getPrincipals();
            Set<Principal> principals2 = activeSubject.getPrincipals();
            Iterator<Object> iter = principals.iterator();
            while (iter.hasNext()) {
                principals2.add(iter.next());
            }
            Set<Object> privateCreds = theSubject.getPrivateCredentials();
            Set<Object> privateCreds2 = activeSubject.getPrivateCredentials();
            iter = privateCreds.iterator();
            while (iter.hasNext()) {
                privateCreds2.add(iter.next());
            }
            Set<Object> publicCreds = theSubject.getPublicCredentials();
            Set<Object> publicCreds2 = activeSubject.getPublicCredentials();
            iter = publicCreds.iterator();
            while (iter.hasNext()) {
                publicCreds2.add(iter.next());
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getPrincipal(Principal principal) {
        Principal result = principal;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            DomainInfo info = this.getCacheInfo(principal, false);
            if (info != null && (result = info.callerPrincipal) == null) {
                result = principal;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesUserHaveRole(Principal principal, Set rolePrincipals) {
        boolean hasRole = false;
        Subject subject = this.getActiveSubject();
        if (subject != null) {
            CachePolicy cachePolicy = this.domainCache;
            synchronized (cachePolicy) {
                DomainInfo info = this.getCacheInfo(principal, false);
                Group roles = null;
                if (info != null) {
                    roles = info.roles;
                }
                if (roles != null) {
                    Iterator iter = rolePrincipals.iterator();
                    while (!hasRole && iter.hasNext()) {
                        Principal role = (Principal)iter.next();
                        hasRole = this.doesRoleGroupHaveRole(role, roles);
                    }
                }
            }
        }
        return hasRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesUserHaveRole(Principal principal, Principal role) {
        boolean hasRole = false;
        Subject subject = this.getActiveSubject();
        if (subject != null) {
            CachePolicy cachePolicy = this.domainCache;
            synchronized (cachePolicy) {
                DomainInfo info = this.getCacheInfo(principal, false);
                Group roles = null;
                if (info != null) {
                    roles = info.roles;
                }
                if (roles != null) {
                    hasRole = this.doesRoleGroupHaveRole(role, roles);
                }
            }
        }
        return hasRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getUserRoles(Principal principal) {
        HashSet<Principal> userRoles = null;
        Subject subject = this.getActiveSubject();
        if (subject != null) {
            CachePolicy cachePolicy = this.domainCache;
            synchronized (cachePolicy) {
                DomainInfo info = this.getCacheInfo(principal, false);
                Group roles = null;
                if (info != null) {
                    roles = info.roles;
                }
                if (roles != null) {
                    userRoles = new HashSet<Principal>();
                    Enumeration members = roles.members();
                    while (members.hasMoreElements()) {
                        Principal role = (Principal)members.nextElement();
                        userRoles.add(role);
                    }
                }
            }
        }
        return userRoles;
    }

    protected boolean doesRoleGroupHaveRole(Principal role, Group userRoles) {
        if (role instanceof NobodyPrincipal) {
            return false;
        }
        boolean isMember = userRoles.isMember(role);
        if (!isMember) {
            isMember = role instanceof AnybodyPrincipal;
        }
        return isMember;
    }

    private boolean authenticate(Principal principal, Object credential) {
        boolean authenticated;
        block3: {
            Subject subject = null;
            authenticated = false;
            try {
                SecurityAssociation.setSubject(null);
                LoginContext lc = this.defaultLogin(principal, credential);
                subject = lc.getSubject();
                if (subject != null) {
                    SecurityAssociation.setSubject(subject);
                    authenticated = true;
                    this.updateCache(lc, subject, principal, credential);
                }
            }
            catch (LoginException e) {
                if ((principal == null || principal.getName() == null) && !this.log.isTraceEnabled()) break block3;
                this.log.debug((Object)"Login failure", (Throwable)e);
            }
        }
        return authenticated;
    }

    private LoginContext defaultLogin(Principal principal, Object credential) throws LoginException {
        Object[] securityInfo = new Object[]{principal, credential};
        try {
            this.setSecurityInfo.invoke((Object)this.handler, securityInfo);
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Failed to setSecurityInfo on handler", (Throwable)e);
            }
            throw new LoginException("Failed to setSecurityInfo on handler, msg=" + e.getMessage());
        }
        Subject subject = new Subject();
        LoginContext lc = new LoginContext(this.securityDomain, subject, this.handler);
        lc.login();
        return lc;
    }

    private boolean validateCache(DomainInfo info, Object credential) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("validateCache, info=" + info));
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            if (subjectCredential instanceof Comparable) {
                Comparable c = (Comparable)subjectCredential;
                isValid = c.compareTo(credential) == 0;
            } else if (subjectCredential instanceof char[]) {
                char[] a1 = (char[])subjectCredential;
                char[] a2 = (char[])credential;
                isValid = Arrays.equals(a1, a2);
            } else if (subjectCredential instanceof byte[]) {
                byte[] a1 = (byte[])subjectCredential;
                byte[] a2 = (byte[])credential;
                isValid = Arrays.equals(a1, a2);
            } else {
                isValid = subjectCredential.equals(credential);
            }
        }
        if (isValid) {
            SecurityAssociation.setSubject(info.subject);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainInfo getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        DomainInfo cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (DomainInfo)this.domainCache.get((Object)principal) : (DomainInfo)this.domainCache.peek((Object)principal);
        }
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(LoginContext lc, Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return;
        }
        int lifetime = 0;
        if (this.domainCache instanceof TimedCachePolicy) {
            TimedCachePolicy cache = (TimedCachePolicy)this.domainCache;
            lifetime = cache.getDefaultLifetime();
        }
        DomainInfo info = new DomainInfo(lifetime);
        info.loginCtx = lc;
        info.subject = subject;
        info.credential = credential;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("updateCache, subject=" + subject));
        }
        Set subjectGroups = subject.getPrincipals(class$java$security$acl$Group == null ? (class$java$security$acl$Group = JaasSecurityManager.class$("java.security.acl.Group")) : class$java$security$acl$Group);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (name.equals("CallerPrincipal")) {
                Enumeration members = grp.members();
                if (!members.hasMoreElements()) continue;
                info.callerPrincipal = (Principal)members.nextElement();
                continue;
            }
            if (!name.equals("Roles")) continue;
            info.roles = grp;
        }
        if (principal == null && info.callerPrincipal == null) {
            Set subjectPrincipals = subject.getPrincipals(class$java$security$Principal == null ? (class$java$security$Principal = JaasSecurityManager.class$("java.security.Principal")) : class$java$security$Principal);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek((Object)principal) != null) {
                this.domainCache.remove((Object)principal);
            }
            this.domainCache.insert((Object)principal, (Object)info);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DomainInfo
    implements TimedCachePolicy.TimedEntry {
        private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo == null ? (class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo = JaasSecurityManager.class$("org.jboss.security.plugins.JaasSecurityManager$DomainInfo")) : class$org$jboss$security$plugins$JaasSecurityManager$DomainInfo));
        LoginContext loginCtx;
        Subject subject;
        Object credential;
        Principal callerPrincipal;
        Group roles;
        long expirationTime;

        public DomainInfo(int lifetime) {
            this.expirationTime = 1000 * lifetime;
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            return this.expirationTime > now;
        }

        public boolean refresh() {
            return false;
        }

        public void destroy() {
            block2: {
                try {
                    this.loginCtx.logout();
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block2;
                    log.trace((Object)"Cache entry logout failed", (Throwable)e);
                }
            }
        }

        public Object getValue() {
            return this;
        }
    }
}

