/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;

public class DomainServerSocketFactory
extends SSLServerSocketFactory {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$ssl$DomainServerSocketFactory == null ? (class$org$jboss$security$ssl$DomainServerSocketFactory = DomainServerSocketFactory.class$("org.jboss.security.ssl.DomainServerSocketFactory")) : class$org$jboss$security$ssl$DomainServerSocketFactory));
    private transient SecurityDomain securityDomain;
    private transient InetAddress bindAddress;
    private transient SSLContext sslCtx = null;
    static /* synthetic */ Class class$org$jboss$security$ssl$DomainServerSocketFactory;

    public DomainServerSocketFactory() {
    }

    public DomainServerSocketFactory(SecurityDomain securityDomain) throws IOException {
        if (securityDomain == null) {
            throw new IOException("The securityDomain may not be null");
        }
        this.securityDomain = securityDomain;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50, this.bindAddress);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, this.bindAddress);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        this.initSSLContext();
        SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
        ServerSocket socket = factory.createServerSocket(port, backlog, ifAddress);
        return socket;
    }

    public static ServerSocketFactory getDefault() {
        DomainServerSocketFactory ssf = null;
        try {
            InitialContext iniCtx = new InitialContext();
            SecurityDomain sd = (SecurityDomain)iniCtx.lookup("java:/jaas/other");
            ssf = new DomainServerSocketFactory(sd);
        }
        catch (Exception e) {
            log.error((Object)"Failed to create default ServerSocketFactory", (Throwable)e);
        }
        return ssf;
    }

    public String[] getDefaultCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
            cipherSuites = factory.getDefaultCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLServerSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    public String[] getSupportedCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLServerSocketFactory factory = this.sslCtx.getServerSocketFactory();
            cipherSuites = factory.getSupportedCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLServerSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    private void initSSLContext() throws IOException {
        if (this.sslCtx != null) {
            return;
        }
        try {
            this.sslCtx = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory keyMgr = this.securityDomain.getKeyManagerFactory();
            if (keyMgr == null) {
                throw new IOException("KeyManagerFactory is null for security domain: " + this.securityDomain.getSecurityDomain());
            }
            TrustManagerFactory trustMgr = this.securityDomain.getTrustManagerFactory();
            TrustManager[] trustMgrs = null;
            if (trustMgr != null) {
                trustMgrs = trustMgr.getTrustManagers();
            }
            this.sslCtx.init(keyMgr.getKeyManagers(), trustMgrs, null);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Failed to get SSLContext for TLS algorithm", (Throwable)e);
            throw new IOException("Failed to get SSLContext for TLS algorithm");
        }
        catch (KeyManagementException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
        catch (SecurityException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

