/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.spi.ResolveResult;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingParser;

public class NamingServer
implements Naming,
Serializable {
    protected Hashtable table = new Hashtable();
    protected Name prefix;
    protected NamingParser parser = new NamingParser();
    protected NamingServer parent;
    static /* synthetic */ Class class$org$jnp$interfaces$NamingContext;

    public NamingServer() throws NamingException {
        this(null, null);
    }

    public NamingServer(Name prefix, NamingServer parent) throws NamingException {
        if (prefix == null) {
            prefix = this.parser.parse("");
        }
        this.prefix = prefix;
        this.parent = parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void bind(Name name, Object obj, String className) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx == null) throw new NameNotFoundException();
            if (ctx instanceof NamingServer) {
                ((NamingServer)ctx).bind(name.getSuffix(1), obj, className);
                return;
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) throw new NotContextException();
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            throw new InvalidNameException();
        }
        try {
            this.getBinding(name);
            throw new NameAlreadyBoundException();
        }
        catch (NameNotFoundException e) {
            this.setBinding(name, obj, className);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void rebind(Name name, Object obj, String className) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx instanceof NamingServer) {
                ((NamingServer)ctx).rebind(name.getSuffix(1), obj, className);
                return;
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) throw new NotContextException();
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            throw new InvalidNameException();
        }
        this.setBinding(name, obj, className);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx instanceof NamingServer) {
                ((NamingServer)ctx).unbind(name.getSuffix(1));
                return;
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) throw new NotContextException();
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            throw new InvalidNameException();
        }
        if (this.getBinding(name) == null) throw new NameNotFoundException();
        this.removeBinding(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContext(null, (Name)this.prefix.clone(), this.getRoot());
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx instanceof NamingServer) {
                return ((NamingServer)ctx).lookup(name.getSuffix(1));
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) return new ResolveResult(ctx, name.getSuffix(1));
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            return new NamingContext(null, this.prefix, this.getRoot());
        }
        Object res = this.getObject(name);
        if (!(res instanceof NamingServer)) return res;
        Name fullName = (Name)this.prefix.clone();
        fullName.addAll(name);
        return new NamingContext(null, fullName, this.getRoot());
    }

    public Collection list(Name name) throws NamingException {
        if (name.isEmpty()) {
            Vector<NameClassPair> list = new Vector<NameClassPair>();
            Enumeration keys = this.table.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Binding b = this.getBinding(key);
                list.addElement(new NameClassPair(b.getName(), b.getClassName(), true));
            }
            return list;
        }
        Object ctx = this.getObject(name);
        if (ctx instanceof NamingServer) {
            return ((NamingServer)ctx).list(name.getSuffix(1));
        }
        if (ctx instanceof Reference) {
            if (((Reference)ctx).get("nns") != null) {
                CannotProceedException cpe = new CannotProceedException();
                cpe.setResolvedObj(ctx);
                cpe.setRemainingName(name.getSuffix(1));
                throw cpe;
            }
            throw new NotContextException();
        }
        throw new NotContextException();
    }

    public Collection listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            Collection bindings = this.table.values();
            Vector<Binding> newBindings = new Vector<Binding>(bindings.size());
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                Binding b = (Binding)iterator.next();
                if (b.getObject() instanceof NamingServer) {
                    Name n = (Name)this.prefix.clone();
                    n.add(b.getName());
                    newBindings.add(new Binding(b.getName(), b.getClassName(), new NamingContext(null, n, this.getRoot())));
                    continue;
                }
                newBindings.add(b);
            }
            return newBindings;
        }
        Object ctx = this.getObject(name);
        if (ctx instanceof NamingServer) {
            return ((NamingServer)ctx).listBindings(name.getSuffix(1));
        }
        if (ctx instanceof Reference) {
            if (((Reference)ctx).get("nns") != null) {
                CannotProceedException cpe = new CannotProceedException();
                cpe.setResolvedObj(ctx);
                cpe.setRemainingName(name.getSuffix(1));
                throw cpe;
            }
            throw new NotContextException();
        }
        throw new NotContextException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        NamingException ex = null;
        Context subCtx = null;
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx != null) {
                Name subCtxName = name.getSuffix(1);
                if (ctx instanceof NamingServer) {
                    return ((NamingServer)ctx).createSubcontext(subCtxName);
                }
                if (ctx instanceof Reference) {
                    if (((Reference)ctx).get("nns") != null) {
                        CannotProceedException cpe = new CannotProceedException();
                        cpe.setResolvedObj(ctx);
                        cpe.setRemainingName(subCtxName);
                        throw cpe;
                    }
                    ex = new NotContextException();
                    ex.setResolvedName(name.getPrefix(0));
                    ex.setRemainingName(subCtxName);
                    throw ex;
                }
                ex = new NotContextException();
                ex.setResolvedName(name.getPrefix(0));
                ex.setRemainingName(subCtxName);
                throw ex;
            }
            ex = new NameNotFoundException();
            ex.setRemainingName(name);
            throw ex;
        }
        Object binding = this.table.get(name.get(0));
        if (binding != null) {
            ex = new NameAlreadyBoundException();
            ex.setResolvedName(this.prefix);
            ex.setRemainingName(name);
            throw ex;
        }
        Name fullName = (Name)this.prefix.clone();
        fullName.addAll(name);
        NamingServer subContext = new NamingServer(fullName, this);
        this.setBinding(name, subContext, (class$org$jnp$interfaces$NamingContext == null ? (class$org$jnp$interfaces$NamingContext = NamingServer.class$("org.jnp.interfaces.NamingContext")) : class$org$jnp$interfaces$NamingContext).getName());
        return new NamingContext(null, fullName, this.getRoot());
    }

    public Naming getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    private void setBinding(Name name, Object obj, String className) {
        String n = name.toString();
        this.table.put(n, new Binding(n, className, obj, true));
    }

    private Binding getBinding(String key) throws NameNotFoundException {
        Binding b = (Binding)this.table.get(key);
        if (b == null) {
            throw new NameNotFoundException(key + " not bound");
        }
        return b;
    }

    private Binding getBinding(Name key) throws NameNotFoundException {
        return this.getBinding(key.get(0));
    }

    private Object getObject(Name key) throws NameNotFoundException {
        return this.getBinding(key).getObject();
    }

    private void removeBinding(Name name) {
        this.table.remove(name.get(0));
    }

    private NamingServer getParent() {
        return this.parent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

