/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mojo.sbb;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractSbbPluginMojo
extends AbstractMojo {
    public static final String MANIFEST_URI = "META-INF/MANIFEST.MF";
    protected MavenProject project;
    private File manifestFile;
    private String outputDirectory;
    protected File targetDirectory;
    private String classpathPrefix = "";
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public abstract File getTargetDirectory();

    public abstract void execute() throws MojoExecutionException;

    public MavenProject getProject() {
        return this.project;
    }

    public String[] getAlternateDeploymentDescriptorFilenames() {
        return null;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    protected void includeCustomManifestFile(JarArchiver anArchiver) throws MojoExecutionException, DependencyResolutionRequiredException {
        File customManifestFile = this.manifestFile;
        if (!customManifestFile.exists()) {
            this.getLog().info((CharSequence)("Could not find manifest file: " + this.manifestFile + " - Generating one"));
            this.generateManifest(anArchiver);
        } else {
            this.getLog().info((CharSequence)("Including custom manifest file[" + customManifestFile + "]"));
            this.archive.setManifestFile(customManifestFile);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateManifest(JarArchiver anArchiver) throws MojoExecutionException, DependencyResolutionRequiredException {
        Manifest mf = null;
        File manifestDir = new File(this.getTargetDirectory(), "META-INF");
        if (!manifestDir.exists()) {
            manifestDir.mkdirs();
        }
        File manifestFile = new File(manifestDir.getAbsolutePath(), "MANIFEST.MF");
        MavenArchiver ma = new MavenArchiver();
        ma.setArchiver(anArchiver);
        ma.setOutputFile(manifestFile);
        PrintWriter printWriter = null;
        try {
            mf = ma.getManifest(this.getProject(), this.archive.getManifest());
            Manifest.Attribute classpathAttrib = mf.getMainSection().getAttribute("Class-Path");
            if (classpathAttrib == null) {
                this.getLog().info((CharSequence)"Class-Path Attribute to MANIFEST");
                StringBuffer classpath = new StringBuffer();
                List artifacts = this.project.getRuntimeClasspathElements();
                Iterator iter = artifacts.iterator();
                while (iter.hasNext()) {
                    File f = new File((String)iter.next());
                    if (!f.isFile()) continue;
                    if (classpath.length() > 0) {
                        classpath.append(" ");
                    }
                    if (!this.classpathPrefix.equals("")) {
                        classpath.append(this.classpathPrefix + "/");
                    }
                    classpath.append(f.getName());
                }
                if (classpath.length() > 0) {
                    classpathAttrib = new Manifest.Attribute("Class-Path", classpath.toString());
                    mf.addConfiguredAttribute(classpathAttrib);
                }
            }
            this.getLog().info((CharSequence)("\nClass-Path\n" + classpathAttrib.getValue() + "\n"));
            printWriter = new PrintWriter(new FileWriter(manifestFile));
            mf.write(printWriter);
            anArchiver.addConfiguredManifest(mf);
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)((Object)e));
                catch (DependencyResolutionRequiredException e2) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e2.getMessage(), (Exception)((Object)e2));
                }
                catch (IOException e3) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e3.getMessage(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                this.manifestFile = manifestFile;
                throw throwable;
            }
        }
        IOUtil.close((Writer)printWriter);
        this.manifestFile = manifestFile;
    }
}

