/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mojo.sbb;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.mobicents.mojo.sbb.AbstractSbbPluginMojo;
import org.mobicents.mojo.sbb.PropertyUtils;
import org.mobicents.mojo.sbb.ReflectionProperties;

public class SbbPluginMojo
extends AbstractSbbPluginMojo {
    private static final String SEPARATOR = new String("/");
    private static final String SCORE = new String("-");
    private static final String DU_PREFIX = new String("DU");
    private static final String JAR_PREFIX = new String(".jar");
    private static final String DEPLOYABLE_UNIT_XML = "deployable-unit.xml";
    private static final String SERVICE_XML = "service.xml";
    private static final String SBB_JAR_XML = "sbb-jar.xml";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.*"};
    private static final String[] JAR_DEFAULT_EXCLUDES = new String[]{"**/deployable-unit.xml"};
    private static final String[] JAR_DEFAULT_INCLUDES = new String[]{"**/sbb-jar.xml", "**/*.class", "**/*.properties", "**/*.xml", "**/*.wav"};
    private static final String[] DU_DEFAULT_EXCLUDES = new String[]{"**/sbb-jar.xml", "**/*.class"};
    private static final String[] DU_DEFAULT_INCLUDES = new String[]{"**/deployable-unit.xml", "**/*.xml"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String encoding;
    private File basedir;
    private File resourcesDir;
    private File metainfResourcesDir;
    private File metainfTargetDir;
    private String finalName;
    private String classpathPrefix = "library";
    private JarArchiver jarArchiver;
    private JarArchiver duArchiver;
    private MavenProjectHelper projectHelper;
    private File contentDirectory;
    private File metainfContentDirectory;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository local;
    ArtifactHandler artifactHandler;
    protected ArtifactInstaller installer;
    private Properties filterProperties;
    private List filters;
    private List resources;
    private String outputDirectory;

    public File createArchives() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Start processing " + this.project.getArtifactId()));
            File jarFile = this.performPackaging();
            this.performDUPackaging();
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling DU ", e);
        }
    }

    private File performPackaging() {
        File jarFile = new File(this.targetDirectory, this.finalName + JAR_PREFIX);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        FileUtils.mkdir((String)this.contentDirectory.getAbsolutePath());
        FileUtils.mkdir((String)this.metainfContentDirectory.toString());
        try {
            archiver.getArchiver().addDirectory(new File(this.contentDirectory.getAbsolutePath() + SEPARATOR), JAR_DEFAULT_INCLUDES, JAR_DEFAULT_EXCLUDES);
        }
        catch (ArchiverException e) {
            this.getLog().warn((CharSequence)"Error add Directory ", (Throwable)e);
        }
        try {
            archiver.createArchive(this.project, new MavenArchiveConfiguration());
        }
        catch (ArchiverException e) {
            this.getLog().warn((CharSequence)"Error create Archive ", (Throwable)e);
        }
        catch (ManifestException e) {
            this.getLog().warn((CharSequence)"Error create Archive ", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error create Archive ", (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().warn((CharSequence)"Error create Archive ", (Throwable)e);
        }
        this.getLog().info((CharSequence)("Successfully create " + jarFile.getAbsolutePath()));
        return jarFile;
    }

    private void performDUPackaging() throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, ArtifactInstallationException, MojoExecutionException {
        this.initializeFiltering();
        if (this.encoding == null || this.encoding.length() < 1) {
            this.getLog().info((CharSequence)"Using default encoding to copy filtered resources.");
        } else {
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' to copy filtered resources."));
        }
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String targetPath = resource.getTargetPath();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.exists()) {
                this.getLog().info((CharSequence)("Resource directory does not exist: " + resourceDirectory));
                continue;
            }
            File outputDir = new File(this.outputDirectory);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new MojoExecutionException("Cannot create resource output directory: " + outputDir);
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resource.getDirectory());
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLog().info((CharSequence)("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath)));
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name;
                String destination = name = j.next();
                if (targetPath != null) {
                    destination = targetPath + "/" + name;
                }
                File source = new File(resource.getDirectory(), name);
                File destinationFile = new File(this.outputDirectory, destination);
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                try {
                    this.copyFile(source, destinationFile, resource.isFiltering());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying resource " + source, (Exception)e);
                }
            }
        }
        String duJarName = this.project.getArtifactId() + SCORE + DU_PREFIX + SCORE + this.project.getVersion();
        File duFile = new File(this.targetDirectory, duJarName + JAR_PREFIX);
        MavenArchiver archiverDu = new MavenArchiver();
        archiverDu.setArchiver(this.duArchiver);
        archiverDu.setOutputFile(duFile);
        try {
            archiverDu.getArchiver().addFile(new File(this.contentDirectory, SERVICE_XML), SERVICE_XML);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Not found a service.xml to include");
        }
        String sbbJarPath = this.targetDirectory.getAbsolutePath();
        String sbbJarName = this.project.getArtifactId() + SCORE + this.project.getVersion() + JAR_PREFIX;
        archiverDu.getArchiver().addFile(new File(sbbJarPath, sbbJarName), sbbJarName);
        archiverDu.getArchiver().addDirectory(new File(this.contentDirectory.getAbsolutePath() + SEPARATOR), DU_DEFAULT_INCLUDES, DU_DEFAULT_EXCLUDES);
        Set artifacts = this.project.getDependencyArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!artifact.getScope().equals("provided")) continue;
            this.getLog().info((CharSequence)("ArtifactId " + artifact.getArtifactId() + " scope " + artifact.getScope() + " adding"));
            if (!this.classpathPrefix.equals("")) {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)new File(this.contentDirectory.getAbsolutePath() + SEPARATOR + this.classpathPrefix));
                SbbPluginMojo.addDirectory(archiverDu, new File(this.contentDirectory.getAbsolutePath() + SEPARATOR + this.classpathPrefix));
            } else {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)new File(this.contentDirectory.getAbsolutePath()));
                SbbPluginMojo.addDirectory(archiverDu, new File(this.contentDirectory.getAbsolutePath()));
            }
            this.getLog().info((CharSequence)("add dependencies " + artifact + " to " + this.project.getArtifactId()));
        }
        this.includeCustomManifestFile(archiverDu.getArchiver());
        archiverDu.createArchive(this.project, new MavenArchiveConfiguration());
        this.getLog().info((CharSequence)("Successfully create " + duFile.getAbsolutePath()));
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId() + SCORE + DU_PREFIX, VersionRange.createFromVersion((String)this.project.getVersion()), "runtime", "jar", "", this.artifactHandler);
        artifact.setFile(duFile);
        this.installer.install(duFile, (Artifact)artifact, this.local);
        this.getLog().info((CharSequence)"sbb deployable unit successfully deployed on local repository");
    }

    private static void addDirectory(MavenArchiver archiver, File file) throws ArchiverException {
        if (file.exists()) {
            archiver.getArchiver().addDirectory(file, file.getName() + SEPARATOR, DEFAULT_INCLUDES, FileUtils.getDefaultExcludes());
        }
    }

    private void initializeFiltering() throws MojoExecutionException {
        this.filterProperties = new Properties();
        ((Hashtable)this.filterProperties).putAll(System.getProperties());
        ((Hashtable)this.filterProperties).putAll(this.project.getProperties());
        Properties baseProps = new Properties();
        ((Hashtable)baseProps).putAll(this.filterProperties);
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            String filtersfile = (String)i.next();
            try {
                Properties properties = PropertyUtils.loadPropertyFile(new File(filtersfile), baseProps);
                ((Hashtable)this.filterProperties).putAll(properties);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error loading property file '" + filtersfile + "'", (Exception)e);
            }
        }
    }

    private void copyFile(File from, final File to, boolean filtering) throws IOException {
        FileUtils.FilterWrapper[] wrappers = null;
        if (filtering) {
            wrappers = new FileUtils.FilterWrapper[]{new FileUtils.FilterWrapper(){

                public Reader getReader(Reader reader) {
                    return new InterpolationFilterReader(reader, (Map)SbbPluginMojo.this.filterProperties, "${", "}");
                }
            }, new FileUtils.FilterWrapper(){

                public Reader getReader(Reader reader) {
                    return new InterpolationFilterReader(reader, (Map)SbbPluginMojo.this.filterProperties, "@", "@");
                }
            }, new FileUtils.FilterWrapper(){

                public Reader getReader(Reader reader) {
                    boolean isPropertiesFile = false;
                    if (to.isFile() && to.getName().endsWith(".properties")) {
                        isPropertiesFile = true;
                    }
                    return new InterpolationFilterReader(reader, (Map)new ReflectionProperties(SbbPluginMojo.this.project, isPropertiesFile), "${", "}");
                }
            }};
        }
        FileUtils.copyFile((File)from, (File)to, (String)this.encoding, wrappers);
    }

    public void execute() throws MojoExecutionException {
        File jarFile = this.createArchives();
        this.project.getArtifact().setFile(jarFile);
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }
}

