package org.mobicents.mojo.sbb;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.InterpolationFilterReader;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
/**
 * Package sbb.
 * 
 * @author La Porta
 * @goal mobicents-sbb-plugin
 * @phase package
 */
public class SbbPluginMojo extends AbstractSbbPluginMojo
{

    private static final String SEPARATOR = new String("/");

    private static final String SCORE = new String( "-" );
    
    private static final String DU_PREFIX = new String( "DU" );

    private static final String JAR_PREFIX = new String( ".jar" );

    private static final String DEPLOYABLE_UNIT_XML = "deployable-unit.xml";

    private static final String SERVICE_XML = "service.xml";

    private static final String SBB_JAR_XML = "sbb-jar.xml";

    private static final String[] DEFAULT_INCLUDES = new String[] { "**/*.*" };

    private static final String[] JAR_DEFAULT_EXCLUDES = new String[] { "**/deployable-unit.xml" };

    private static final String[] JAR_DEFAULT_INCLUDES = new String[] { "**/sbb-jar.xml", "**/*.class", "**/*.properties", "**/*.xml" ,"**/*.wav"};

    private static final String[] DU_DEFAULT_EXCLUDES = new String[] { "**/sbb-jar.xml", "**/*.class" };

    private static final String[] DU_DEFAULT_INCLUDES = new String[] { "**/" +DEPLOYABLE_UNIT_XML ,"**/*.xml"};
    
    private static final String[] EMPTY_STRING_ARRAY = {};    

    /**
     * The character encoding scheme to be applied.
     * 
     * @parameter
     */
    private String encoding;
   

    /**
     * Base directory.
     * 
     * @parameter expression="${basedir}"
     * @required
     * @readonly
     */
    private File basedir;


    /**
     * Base directory.
     * 
     * @parameter expression="${basedir}/src/main/resources/"
     * @required
     * @readonly
     */
    private File resourcesDir;

    /**
     * Base META-INF resources directory.
     * 
     * @parameter expression="${basedir}/src/main/resources/META-INF/"
     * @required
     * @readonly
     */
    private File metainfResourcesDir;

    /**
     * Target META-INF directory.
     * 
     * @parameter expression="${project.build.directory}/META-INF/"
     * @required
     * @readonly
     */
    private File metainfTargetDir;


    /**
     * Name of the generated JAR.
     * 
     * @parameter expression="${project.build.finalName}"
     * @required
     */
    private String finalName;

    /**
     * 
     * 
     * @parameter default-value=""
     */
    private String classpathPrefix = "library";


    /**
     * The Jar archiver.
     * 
     * @parameter expression="${component.org.codehaus.plexus.archiver.Archiver#jar}"
     * @required
     */
    private JarArchiver jarArchiver;

    /**
     * The Jar archiver.
     * 
     * @parameter expression="${component.org.codehaus.plexus.archiver.Archiver#jar}"
     * @required
     */
    private JarArchiver duArchiver;

    /**
     * @component
     * @todo Write Javadoc for this
     */
    private MavenProjectHelper projectHelper;

    /**
     * Directory that contains the compiled classes to include in the jar.
     * 
     * @parameter expression="${project.build.outputDirectory}"
     * @required
     */
    private File contentDirectory;

    /**
     * META-INF content directory.
     * 
     * @parameter expression="${project.build.outputDirectory}/META-INF"
     * @required
     */
    private File metainfContentDirectory;


    /**
     * Used to look up Artifacts in the remote repository.
     * 
     * @parameter expression="${component.org.apache.maven.artifact.factory.ArtifactFactory}"
     * @required
     * @readonly
     */
    protected org.apache.maven.artifact.factory.ArtifactFactory factory;

    /**
     * Used to look up Artifacts in the remote repository.
     * 
     * @parameter expression="${component.org.apache.maven.artifact.resolver.ArtifactResolver}"
     * @required
     * @readonly
     */
    protected org.apache.maven.artifact.resolver.ArtifactResolver resolver;

    /**
     * Location of the local repository.
     * 
     * @parameter expression="${localRepository}"
     * @readonly
     * @required
     */
    protected org.apache.maven.artifact.repository.ArtifactRepository local;
    
    
    /**
     * @parameter expression="${component.org.apache.maven.artifact.deployer.ArtifactDeployer}"
     * @required
     * @readonly
     */
    //private ArtifactDeployer deployer;


    /**
     * Default artifact handler.
     * 
     * @parameter expression="${component.org.apache.maven.artifact.handler.ArtifactHandler}"
     * @readonly
     * @required
     */
    org.apache.maven.artifact.handler.ArtifactHandler artifactHandler;

    /**
     * @parameter expression="${component.org.apache.maven.artifact.installer.ArtifactInstaller}"
     * @required
     * @readonly
     */
    protected ArtifactInstaller installer;
    
    private Properties filterProperties;

    /**
     * The list of additional key-value pairs aside from that of the System, 
     * and that of the project, which would be used for the filtering. 
     * 
     * @parameter expression="${project.build.filters}"
     */
    private List filters;

    /**
     * The list of resources we want to transfer.
     *
     * @parameter expression="${project.resources}"
     * @required
     */
    private List resources;

    /**
     * The output directory into which to copy the resources.
     *
     * @parameter expression="${project.build.outputDirectory}"
     * @required
     */
    private String outputDirectory;

    /**
     * Generates the JAR.
     * 
     * @todo Add license files in META-INF directory.
     */
    public File createArchives() throws MojoExecutionException
    {
        
        try
        {
            getLog().info( "Start processing " + project.getArtifactId() );
            
            File jarFile = performPackaging();
            
            performDUPackaging();

            return jarFile;
        }
        catch ( Exception e )
        {
            // TODO: improve error handling
            throw new MojoExecutionException( "Error assembling DU ", e );
//            getLog().warn( "Error assembling DU ", e );
        	
        }
    }
    
    private File performPackaging()
        /*throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException*/
    {
    	
        // jar file with sbb-jar.xml
        File jarFile = new File( targetDirectory, finalName + JAR_PREFIX );
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver( jarArchiver );
        archiver.setOutputFile( jarFile );

        FileUtils.mkdir( contentDirectory.getAbsolutePath() );
        FileUtils.mkdir( metainfContentDirectory.toString() );
        
//        try {
//        	
//			FileUtils.copyFileToDirectory( metainfResourcesDir + SEPARATOR + SBB_JAR_XML,
//			                               metainfContentDirectory.toString() );
//			
//			
//		} catch (IOException e) {
//	        getLog().warn( "Error copy sbb-jar.xml ",e );
//		}
        
        try {
			archiver.getArchiver().addDirectory( new File( contentDirectory.getAbsolutePath() + SEPARATOR ),
			                                     JAR_DEFAULT_INCLUDES, JAR_DEFAULT_EXCLUDES );
		} catch (ArchiverException e) {
	        getLog().warn( "Error add Directory ",e );
		}
        
        try {
			archiver.createArchive( project, new MavenArchiveConfiguration() );
		} catch (ArchiverException e) {
	        getLog().warn( "Error create Archive ",e );
		} catch (ManifestException e) {
	        getLog().warn( "Error create Archive ",e );
		} catch (IOException e) {
	        getLog().warn( "Error create Archive ",e );
		} catch (DependencyResolutionRequiredException e) {
	        getLog().warn( "Error create Archive ",e );
		}

        getLog().info( "Successfully create " + jarFile.getAbsolutePath() );
        return jarFile;
    }

    private void performDUPackaging()
        throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException,
        ArtifactInstallationException, MojoExecutionException
    {
    	initializeFiltering();

        if ( encoding == null || encoding.length() < 1 )
        {
            getLog().info( "Using default encoding to copy filtered resources." );
        }
        else
        {
            getLog().info( "Using '" + encoding + "' to copy filtered resources." );
        }
        
        for ( Iterator i = resources.iterator(); i.hasNext(); )
        {
            Resource resource = (Resource) i.next();

            String targetPath = resource.getTargetPath();

            File resourceDirectory = new File( resource.getDirectory() );

            if ( !resourceDirectory.exists() )
            {
                getLog().info( "Resource directory does not exist: " + resourceDirectory );
                continue;
            }

            // this part is required in case the user specified "../something" as destination
            // see MNG-1345
            File outputDir = new File( outputDirectory );
            if ( !outputDir.exists() )
            {
                if ( !outputDir.mkdirs() )
                {
                    throw new MojoExecutionException( "Cannot create resource output directory: " + outputDir );
                }
            }

            DirectoryScanner scanner = new DirectoryScanner();

            scanner.setBasedir( resource.getDirectory() );
            if ( resource.getIncludes() != null && !resource.getIncludes().isEmpty() )
            {
                scanner.setIncludes( (String[]) resource.getIncludes().toArray( EMPTY_STRING_ARRAY ) );
            }
            else
            {
                scanner.setIncludes( DEFAULT_INCLUDES );
            }

            if ( resource.getExcludes() != null && !resource.getExcludes().isEmpty() )
            {
                scanner.setExcludes( (String[]) resource.getExcludes().toArray( EMPTY_STRING_ARRAY ) );
            }

            scanner.addDefaultExcludes();
            scanner.scan();

            List includedFiles = Arrays.asList( scanner.getIncludedFiles() );

            getLog().info( "Copying " + includedFiles.size() + " resource"
                + ( includedFiles.size() > 1 ? "s" : "" )
                + ( targetPath == null ? "" : " to " + targetPath ) );

            for ( Iterator j = includedFiles.iterator(); j.hasNext(); )
            {
                String name = (String) j.next();

                String destination = name;

                if ( targetPath != null )
                {
                    destination = targetPath + "/" + name;
                }

                File source = new File( resource.getDirectory(), name );

                File destinationFile = new File( outputDirectory, destination );

                if ( !destinationFile.getParentFile().exists() )
                {
                    destinationFile.getParentFile().mkdirs();
                }

                try
                {
                    copyFile( source, destinationFile, resource.isFiltering() );
                }
                catch ( IOException e )
                {
                    throw new MojoExecutionException( "Error copying resource " + source, e );
                }
            }
        }
    	
        // DU
        String duJarName = project.getArtifactId() + SCORE + DU_PREFIX + SCORE + project.getVersion();
        File duFile = new File( targetDirectory, duJarName + JAR_PREFIX );
        MavenArchiver archiverDu = new MavenArchiver();
        archiverDu.setArchiver( duArchiver );
        archiverDu.setOutputFile( duFile );

        // add service xml
        try {
            archiverDu.getArchiver().addFile( new File( contentDirectory, SERVICE_XML ), SERVICE_XML );
		} catch (Exception e) {
			getLog().warn("Not found a service.xml to include");
		}

        // add sbb jar
        String sbbJarPath = targetDirectory.getAbsolutePath();
        String sbbJarName = project.getArtifactId() + SCORE + project.getVersion() + JAR_PREFIX;
        archiverDu.getArchiver().addFile( new File( sbbJarPath, sbbJarName ), sbbJarName );

        // add deployable unit xml
        archiverDu.getArchiver().addDirectory( new File( contentDirectory.getAbsolutePath() + SEPARATOR ),
                                               DU_DEFAULT_INCLUDES, DU_DEFAULT_EXCLUDES );

        // do not include compile scope dependencies these should be provided by container
        Set artifacts = project.getDependencyArtifacts();
        for ( Iterator iter = artifacts.iterator(); iter.hasNext(); )
        {
            Artifact artifact = (Artifact) iter.next();

            if ( artifact.getScope().equals( Artifact.SCOPE_PROVIDED ) )
            {
                getLog().info( "ArtifactId " + artifact.getArtifactId() + " scope " + artifact.getScope() + " adding" );

                if ( !classpathPrefix.equals( "" ) )
                {
                    FileUtils.copyFileToDirectory( artifact.getFile(), new File( contentDirectory.getAbsolutePath()
                                    + SEPARATOR + classpathPrefix ) );
                    addDirectory( archiverDu, new File( contentDirectory.getAbsolutePath() + SEPARATOR
                                    + classpathPrefix ) );
                }
                else
                {
                    FileUtils.copyFileToDirectory( artifact.getFile(), new File( contentDirectory.getAbsolutePath() ) );
                    addDirectory( archiverDu, new File( contentDirectory.getAbsolutePath() ) );
                }
                getLog().info( "add dependencies " + artifact + " to " + project.getArtifactId() );
            }
        }

        // add manifest if necessary
        includeCustomManifestFile( archiverDu.getArchiver() );
        
        archiverDu.createArchive( project, new MavenArchiveConfiguration() );
        getLog().info( "Successfully create " + duFile.getAbsolutePath() );

        Artifact artifact =
            new DefaultArtifact( project.getGroupId(), project.getArtifactId() + SCORE + DU_PREFIX,
                                 VersionRange.createFromVersion( project.getVersion() ), Artifact.SCOPE_RUNTIME, "jar",
                                 "", artifactHandler );
        artifact.setFile( duFile );

        // deployer.deploy( duFile, artifact, local, local );
        installer.install( duFile, artifact, local );
        getLog().info( "sbb deployable unit successfully deployed on local repository" );
    }

    private static void addDirectory( MavenArchiver archiver, File file ) throws ArchiverException
    {
        if ( file.exists() )
        {
            archiver.getArchiver().addDirectory( file, file.getName() + SEPARATOR, DEFAULT_INCLUDES,
                                                 FileUtils.getDefaultExcludes() );
        }
    }


    private void initializeFiltering()
    throws MojoExecutionException
    {
    filterProperties = new Properties();
    
    // System properties
    filterProperties.putAll( System.getProperties() );
    
    // Project properties
    filterProperties.putAll( project.getProperties() );
    
    // Take a copy of filterProperties to ensure that evaluated filterTokens are not propagated 
    // to subsequent filter files. NB this replicates current behaviour and seems to make sense. 
    final Properties baseProps = new Properties();
    baseProps.putAll( this.filterProperties );
    
    for ( Iterator i = filters.iterator(); i.hasNext(); )
    {
        String filtersfile = (String) i.next();
        
        try
        {
            Properties properties = PropertyUtils.loadPropertyFile( new File( filtersfile ), baseProps );
            
            filterProperties.putAll( properties );
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Error loading property file '" + filtersfile + "'", e );
        }
    }
}
    
    private void copyFile( File from, final File to, boolean filtering )
    throws IOException
{
    FileUtils.FilterWrapper[] wrappers = null;
    if (filtering) {
        wrappers = new FileUtils.FilterWrapper[]{
                // support ${token}
                new FileUtils.FilterWrapper() {
                    public Reader getReader(Reader reader) {
                        return new InterpolationFilterReader(reader, filterProperties, "${", "}");
                    }
                },
                // support @token@
                new FileUtils.FilterWrapper() {
                    public Reader getReader(Reader reader) {
                        return new InterpolationFilterReader(reader, filterProperties, "@", "@");
                    }
                },

                new FileUtils.FilterWrapper() {
                    public Reader getReader(Reader reader) {
                        boolean isPropertiesFile = false;

                        if (to.isFile() && to.getName().endsWith(".properties")) {
                            isPropertiesFile = true;
                        }

                        return new InterpolationFilterReader(reader, new ReflectionProperties(project, isPropertiesFile), "${", "}");
                    }
                }
        };
    }
    FileUtils.copyFile(from, to, encoding, wrappers);
}    

    /**
     * Generates the JAR.
     *
     * @todo Add license files in META-INF directory.
     */
    public void execute() throws MojoExecutionException
    {

        File jarFile = createArchives();
        project.getArtifact().setFile( jarFile );
        
    }

    public File getTargetDirectory()
    {
        return this.targetDirectory;
    }
}
