/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.container.entitiesRemoval;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceEventImpl;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.connection.SleeConnection;
import org.mobicents.slee.connector.server.RemoteSleeService;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class EntitiesRemovalTest
extends AbstractSleeTCKTest {
    protected FutureResult result;
    private TCKActivityID tckActivityID = null;
    private String activityName = null;
    private String jnpHostURL = "jnp://127.0.0.1:1099";
    private String serviceID = "EntitiesRemovalTestService#mobicents#0.1";
    private ComponentKey sid = new ComponentKey(this.serviceID);
    private ServiceIDImpl service = new ServiceIDImpl(this.sid);
    private SleeConnection connection = null;
    private RemoteSleeService sleeService = null;
    private String xEventName = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X";
    private String yEventName = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y";
    private String vendor = "jain.slee.tck";
    private String version = "1.0";
    private ExternalActivityHandle ah = null;

    public void setUp() throws Exception {
        super.setUp();
        this.getLog().info("\n========================\nConnecting to resource\n========================\n");
        TestResourceListenerImpl resourceListener = new TestResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
    }

    private void sendRequest(boolean isX) {
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            String tmpIp = "127.0.0.1";
            properties.put("java.naming.provider.url", "jnp://" + tmpIp + ":1099");
            InitialContext ctx = new InitialContext(properties);
            this.sleeService = (RemoteSleeService)ctx.lookup("/SleeService");
        }
        catch (NamingException ne) {
            this.result.setError((Throwable)ne);
            ne.printStackTrace();
        }
        catch (Exception E) {
            this.result.setError((Throwable)E);
            E.printStackTrace();
        }
        if (this.sleeService != null) {
            try {
                String eventName = isX ? this.xEventName + "1" : this.yEventName + "1";
                EventTypeID requestType = this.sleeService.getEventTypeID(eventName, this.vendor, this.version);
                TCKResourceEventImpl event = new TCKResourceEventImpl(1L, isX ? "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1" : "com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", (Object)"TEST", null);
                if (this.ah == null) {
                    ExternalActivityHandle handle;
                    this.ah = handle = this.sleeService.createActivityHandle();
                }
                this.sleeService.fireEvent((Object)event, requestType, this.ah, null);
            }
            catch (RemoteException RE) {
                this.result.setError((Throwable)RE);
                RE.printStackTrace();
            }
        }
    }

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.activityName = this.utils().getTestParams().getProperty("activityName");
        this.tckActivityID = resource.createActivity(this.activityName);
        this.utils().getLog().info("\n===================\nSTARTING DEPLOYMENT IN FEW uS\n===================\nACTIVITY:" + this.activityName + "\n=======================================");
        SleeCommandInterface SCI = new SleeCommandInterface(this.jnpHostURL);
        this.getLog().info(" FIRING X1 - should be received");
        this.sendRequest(true);
        Thread.sleep(100L);
        try {
            Object opResult = null;
            this.getLog().info(" == DEACTIVATING SERVICE ==");
            opResult = SCI.invokeOperation("-deactivateService", this.service.toString(), null, null);
            this.getLog().info(" == SERVICE DEACTIVATED:" + opResult + " ==");
        }
        catch (Exception e) {
            result.setError((Throwable)e);
            e.printStackTrace();
        }
        Thread.currentThread();
        Thread.sleep(100L);
        this.getLog().info(" == FIRING Y1(should not be received) ==");
        this.sendRequest(false);
        Thread.sleep(150L);
        this.getLog().info(" == FIRING  X1(should be received) ==");
        this.sendRequest(true);
    }

    private class TestResourceListenerImpl
    extends BaseTCKResourceListener {
        private TestResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            EntitiesRemovalTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                EntitiesRemovalTest.this.result.setPassed();
            } else {
                EntitiesRemovalTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            EntitiesRemovalTest.this.getLog().warning("Received exception from SBB or resource:");
            EntitiesRemovalTest.this.getLog().warning((Throwable)exception);
            EntitiesRemovalTest.this.result.setError((Throwable)exception);
        }
    }
}

