/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.container.entitiesRemoval;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventY;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceEventImpl;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javax.transaction.SystemException;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.resource.EventLookup;

public abstract class EntitiesRemovalTestSbb
extends BaseTCKSbb {
    private static int Y1Count = 0;
    private String serviceID = "EntitiesRemovalTestService#mobicents#0.1";
    private ComponentKey sid = new ComponentKey(this.serviceID);
    private ServiceIDImpl service = new ServiceIDImpl(this.sid);
    protected ActivityContextInterface nullACIForTimer = null;
    protected TimerOptions tOptions = new TimerOptions(false, 5000L, TimerPreserveMissed.LAST);
    protected static Logger logger = Logger.getLogger(EntitiesRemovalTestSbb.class.toString());
    protected TimerFacility tf = null;
    private static SleeContainer container = null;
    private static EventLookup eventLookup = null;
    protected SbbContext sbbContext;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        container = SleeContainer.lookupFromJndi();
        eventLookup = container.getEventLookupFacility();
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected TimerFacility retrieveTimerFacility() {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            TimerFacility tf = (TimerFacility)myEnv.lookup("slee/facilities/timer");
            return tf;
        }
        catch (NamingException NE) {
            logger.info("COULDNT GET TIMERFACILITY: " + NE.getMessage());
            return null;
        }
    }

    protected ActivityContextInterface retrieveNullActivityContext() {
        ActivityContextInterface localACI = null;
        NullActivityFactory nullACFactory = null;
        NullActivityContextInterfaceFactory nullActivityContextFactory = null;
        try {
            logger.info("Creating nullActivity!!!");
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            nullACFactory = (NullActivityFactory)myEnv.lookup("slee/nullactivity/factory");
            NullActivity na = nullACFactory.createNullActivity();
            nullActivityContextFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            localACI = nullActivityContextFactory.getActivityContextInterface(na);
        }
        catch (NamingException ne) {
            logger.info("Could not create nullActivityFactory: " + ne.getMessage());
        }
        catch (UnrecognizedActivityException UAE) {
            logger.info("Could not create nullActivityContextInterfaceFactory: " + UAE.getMessage());
        }
        return localACI;
    }

    protected void setResultPassed(String msg) throws Exception {
        logger.info("Success: " + msg);
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("result", Boolean.TRUE);
        sbbData.put("message", msg);
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    protected void setResultFailed(String msg) throws Exception {
        logger.info("Failed: " + msg);
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("result", Boolean.FALSE);
        sbbData.put("message", msg);
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    protected void activateTimer() {
        this.tf.setTimer(this.nullACIForTimer, null, System.currentTimeMillis() + 20000L, this.tOptions);
    }

    protected void activateTimer(int miliseconds) {
        this.tf.setTimer(this.nullACIForTimer, null, System.currentTimeMillis() + (long)miliseconds * 1000L, this.tOptions);
    }

    public void onTimeEvent(TimerEvent event, ActivityContextInterface aci) {
    }

    public void onStartServiceEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        logger.info(" == SERVICE ACTIVATED ==");
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        logger.info("\n------------------------- X1 -----------------------");
        Object svcComponent = null;
        Set activeServiceIDs = null;
        try {
            activeServiceIDs = SleeContainer.lookupFromJndi().getDeploymentManager().getActiveServiceIDs();
        }
        catch (SystemException e1) {
            TCKSbbUtils.handleException((Exception)((Object)e1));
            e1.printStackTrace();
        }
        if (!this.getGotX1()) {
            this.setGotX1(true);
            logger.info(" == RECEIVED FIRST X1, SERVICE STATE - Active[" + activeServiceIDs.contains(this.service) + "], ACTIVITY[" + aci.getActivity() + "] ==");
        } else {
            logger.info(" == RECEIVED SECOND X1, SERVICE STATE - Active[" + activeServiceIDs.contains(this.service) + "], ACTIVITY[" + aci.getActivity() + "] ==");
            try {
                this.setResultPassed("== RECEIVED SECOND X1, SERVICE STATE - Active[" + activeServiceIDs.contains(this.service) + "] ==");
            }
            catch (Exception e) {
                TCKSbbUtils.handleException((Exception)e);
                e.printStackTrace();
            }
        }
    }

    public void onTCKResourceEventY1(TCKResourceEventY event, ActivityContextInterface aci) {
        ++Y1Count;
        Set activeServiceIDs = null;
        try {
            activeServiceIDs = container.getDeploymentManager().getActiveServiceIDs();
        }
        catch (SystemException e1) {
            e1.printStackTrace();
        }
        logger.info("\n------------------------- Y1[" + Y1Count + "] -----------------------");
        if (Y1Count >= 2) {
            try {
                this.setResultFailed(" == RECEIVED Y1[" + Y1Count + "], THIS SHOULD NOT HAPPEN, SERVICE STATE - Active[" + activeServiceIDs.contains(this.service) + "], ACTIVITY[" + aci.getActivity() + "] ==");
            }
            catch (Exception e) {
                TCKSbbUtils.handleException((Exception)e);
                e.printStackTrace();
            }
        } else {
            logger.info("\n--------------------- INITIAL SBB RECEIVED Y1 --------------");
        }
    }

    public InitialEventSelector chooseService(InitialEventSelector ies) {
        Object event = ies.getEvent();
        logger.info("IES CALLED");
        try {
            if (event instanceof TCKResourceEventImpl) {
                TCKResourceEventImpl tckEvent = (TCKResourceEventImpl)event;
                String eventName = tckEvent.getEventTypeName();
                if (eventName.indexOf("X.X1") != -1) {
                    String name = "X_NAME";
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                } else if (eventName.indexOf("Y.Y1") != -1) {
                    String name = "Y_NAME";
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                }
            } else {
                ies.setInitialEvent(false);
            }
            return ies;
        }
        catch (Exception e) {
            e.printStackTrace();
            ies.setInitialEvent(false);
            return ies;
        }
    }

    public abstract void setGotX1(boolean var1);

    public abstract boolean getGotX1();
}

