/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.container.installService;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class InstallServiceTest
extends AbstractSleeTCKTest {
    protected FutureResult result;
    private TCKActivityID tckActivityID = null;
    private String activityName = null;
    private String jnpHostURL = "jnp://127.0.0.1:1099";
    private String raTypeDUName = "sip-ra-type.jar";
    private String raDUName = "sip-local-ra.jar";
    private String raLINK = "SipRA";
    private String testServiceDUName = "DummySbbService-DU.jar";
    private String raID = "JSIPSTUB#net.java.slee.sip#1.2";
    private String serviceID = "StateEventsPassedTestService#mobicents#0.1";
    private ComponentKey sid = new ComponentKey(this.serviceID);
    private ServiceIDImpl service = new ServiceIDImpl(this.sid);
    private ComponentKey raId = new ComponentKey(this.raID);
    private ResourceAdaptorIDImpl ra = new ResourceAdaptorIDImpl(this.raId);

    public void setUp() throws Exception {
        super.setUp();
        this.getLog().info("\n========================\nConnecting to resource\n========================\n");
        TestResourceListenerImpl resourceListener = new TestResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
    }

    public void run(FutureResult result) throws Exception {
        Object opResult;
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.activityName = this.utils().getTestParams().getProperty("activityName");
        this.tckActivityID = resource.createActivity(this.activityName);
        Properties props = new Properties();
        try {
            this.getLog().info(" == LOADING PROPS FROM: test.properties ==");
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("test.properties"));
            this.jnpHostURL = props.getProperty("jnpHost", this.jnpHostURL);
            this.raTypeDUName = props.getProperty("raTypeDUName", this.raTypeDUName);
            this.raDUName = props.getProperty("raDUName", this.raDUName);
            this.raLINK = props.getProperty("raLINK", this.raLINK);
            this.testServiceDUName = props.getProperty("testServiceDUName", this.testServiceDUName);
            this.raID = props.getProperty("raID", this.raID);
            this.serviceID = props.getProperty("serviceID", this.serviceID);
            this.sid = new ComponentKey(this.serviceID);
            this.service = new ServiceIDImpl(this.sid);
            this.raId = new ComponentKey(this.raID);
            this.ra = new ResourceAdaptorIDImpl(this.raId);
            this.getLog().info(" == FINISHED LOADING PROPS ==");
        }
        catch (Exception IOE) {
            this.getLog().info("FAILED TO LOAD: test.properties");
        }
        this.utils().getLog().info("\n===================\nSTARTING DEPLOYMENT IN FEW uS\n===================\nACTIVITY:" + this.activityName + "\n=======================================");
        String mcHOME = System.getProperty("MOBICENTS_HOME");
        if (mcHOME == null) {
            result.setError(" == The System Property MOBICENTS_HOME is required, but does not exist!! ==");
        }
        SleeCommandInterface SCI = new SleeCommandInterface(this.jnpHostURL);
        String dusPATH = "file://" + mcHOME + "/tests/lib/container/";
        this.getLog().info(" == STARTIGN DEPLOYMENT ==");
        ArrayList<Exception> errors = new ArrayList<Exception>(2);
        boolean serviceInstalled = false;
        boolean serviceActivated = false;
        boolean raLinkCreated = false;
        boolean raEntityCreated = false;
        boolean raEntityActivated = false;
        boolean raInstalled = false;
        boolean raTypeInstalled = false;
        try {
            opResult = null;
            this.getLog().info(" == DEPOYING RA TYPE:" + dusPATH + this.raTypeDUName + " ==");
            opResult = SCI.invokeOperation("-install", dusPATH + this.raTypeDUName, null, null);
            this.getLog().info(" == DEPLOLYED RA TYPE:" + opResult + " ==");
            raTypeInstalled = true;
            this.getLog().info(" == DEPOYING RA :" + dusPATH + dusPATH + " ==");
            opResult = SCI.invokeOperation("-install", dusPATH + this.raDUName, null, null);
            this.getLog().info(" == DEPLOYED RA:" + opResult + " ==");
            raInstalled = true;
            this.getLog().info(" == CREATING RA ENTITY:" + this.ra + " ==");
            opResult = SCI.invokeOperation("-createRaEntity", this.ra.toString(), this.raLINK, null);
            this.getLog().info(" == RA ENTITY CREATED:" + opResult + " ==");
            raEntityCreated = true;
            this.getLog().info(" == ACTIVATING RA ENTITY:" + this.ra + " ==");
            opResult = SCI.invokeOperation("-activateRaEntity", this.raLINK, null, null);
            this.getLog().info(" == RA ENTITY ACTIVATED:" + opResult + " ==");
            raEntityActivated = true;
            this.getLog().info(" == CREATING RA LINK:" + this.raLINK + " ==");
            opResult = SCI.invokeOperation("-createRaLink", this.raLINK, this.raLINK, null);
            this.getLog().info(" == RA LINK CREATED:" + opResult + " ==");
            raLinkCreated = true;
            this.getLog().info(" == INSTALLING TEST SERVICE:" + dusPATH + this.testServiceDUName + " ==");
            opResult = SCI.invokeOperation("-install", dusPATH + this.testServiceDUName, null, null);
            this.getLog().info(" == SERVICE INSTALLED:" + opResult + " ==");
            serviceInstalled = true;
            this.getLog().info(" == ACTIVATING SERVICE ==");
            opResult = SCI.invokeOperation("-activateService", this.service.toString(), null, null);
            this.getLog().info(" == SERVICE ACTIVATED:" + opResult + " ==");
            serviceActivated = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add(e);
        }
        try {
            opResult = null;
            if (serviceActivated) {
                opResult = SCI.invokeOperation("-deactivateService", this.service.toString(), null, null);
                serviceActivated = !serviceActivated;
                this.getLog().info(" == SERVICE DEACTIVATED:" + opResult + " ==");
            }
            if (serviceInstalled) {
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.testServiceDUName, null, null);
                serviceInstalled = !serviceInstalled;
                this.getLog().info(" == SERVICE UNINSTALLED:" + opResult + " ==");
            }
            if (raLinkCreated) {
                opResult = SCI.invokeOperation("-removeRaLink", this.raLINK, null, null);
                raLinkCreated = !raLinkCreated;
                this.getLog().info(" == RA LINK REMOVED:" + opResult + " ==");
            }
            if (raEntityActivated) {
                opResult = SCI.invokeOperation("-deactivateRaEntity", this.raLINK, null, null);
                raEntityActivated = !raEntityActivated;
                this.getLog().info(" == RA ENTITY DEACTIVATED:" + opResult + " ==");
            }
            if (raEntityCreated) {
                opResult = SCI.invokeOperation("-removeRaEntity", this.raLINK, null, null);
                raEntityCreated = !raEntityCreated;
                this.getLog().info(" == RA ENTITY REMOVED:" + opResult + " ==");
            }
            if (raInstalled) {
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.raDUName, null, null);
                raInstalled = !raInstalled;
                this.getLog().info(" == RA UNINSTALLED:" + opResult + " ==");
            }
            if (raTypeInstalled) {
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.raTypeDUName, null, null);
                raTypeInstalled = !raTypeInstalled;
                this.getLog().info(" == RA TYPE UNINSTALLED:" + opResult + " ==");
            }
        }
        catch (Exception e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            this.getLog().info(" == SOME ERRORS OCURED!!: ==");
            StringBuffer sb = new StringBuffer(400);
            StringBuffer stackTraceSb = null;
            Iterator it = errors.iterator();
            int i = 0;
            while (it.hasNext()) {
                Exception ex = (Exception)it.next();
                StackTraceElement[] ste = ex.getStackTrace();
                if (ste != null && ste.length > 0) {
                    stackTraceSb = new StringBuffer(1000);
                    stackTraceSb.append("\n");
                    for (int c = 0; c < ste.length; ++c) {
                        stackTraceSb.append("=>" + ste[c].getClassName() + " -> " + ste[c].getMethodName() + ":" + ste[c].getLineNumber() + "\n");
                    }
                }
                sb.append("\n[#" + i++ + "] -> " + ex.getMessage());
                if (stackTraceSb != null) {
                    sb.append("\nTRACE:\n" + stackTraceSb + "\n");
                }
                stackTraceSb = null;
            }
            this.getLog().info(" == ERROR INFO: ==\n" + sb);
        }
    }

    private class TestResourceListenerImpl
    extends BaseTCKResourceListener {
        private TestResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            InstallServiceTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                InstallServiceTest.this.result.setPassed();
            } else {
                InstallServiceTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            InstallServiceTest.this.getLog().warning("Received exception from SBB or resource:");
            InstallServiceTest.this.getLog().warning((Throwable)exception);
            InstallServiceTest.this.result.setError((Throwable)exception);
        }
    }
}

