/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.container.installService;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventY;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceEventImpl;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.CreateException;
import javax.slee.EventTypeID;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.container.management.SbbEventEntry;
import org.mobicents.slee.container.management.ServiceDescriptorImpl;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.resource.EventLookup;
import org.mobicents.slee.resource.ResourceAdaptorType;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;

public abstract class InstallServiceTestSbb
extends BaseTCKSbb {
    public static final int SERVICE_NAME_POSITION = 0;
    public static final int EVENT_IDS_POSITION = 1;
    public static final int RESOURCE_OPTIONS_POSITION = 2;
    public static final int RA_TYPE_COMPONENT_KEY = 3;
    public static final int RA_COMPONENT_KEY = 4;
    public static final int COMPONENTKEYS_TO_SERVICEIDS_POSITION = 5;
    public static final int COMPONENTKEYS_TO_OPTIONS_POSITION = 6;
    private ServiceDescriptorImpl serviceDesc = null;
    protected ActivityContextInterface nullACIForTimer = null;
    protected TimerOptions tOptions = new TimerOptions(false, 5000L, TimerPreserveMissed.LAST);
    protected static Logger logger = Logger.getLogger("InstallServiceTestSbb.class");
    protected TimerFacility tf = null;
    private static SleeContainer container = null;
    private static EventLookup eventLookup = null;
    protected SbbContext sbbContext;

    public abstract void setServiceID(String var1);

    public abstract String getServiceID();

    public abstract void setSvc(ServiceComponent var1);

    public abstract ServiceComponent getSvc();

    public abstract void setRaTypeKey(ComponentKey var1);

    public abstract ComponentKey getRaTypeKey();

    public abstract void setRaKey(ComponentKey var1);

    public abstract ComponentKey getRaKey();

    public abstract void setX1_eventIDsPassedToRABySleeContainer(int[] var1);

    public abstract int[] getX1_eventIDsPassedToRABySleeContainer();

    public abstract void setX1_optionsPassedToRABySleeContainer(String[] var1);

    public abstract String[] getX1_optionsPassedToRABySleeContainer();

    public abstract void setX1_eventComponentKeysToServiceIdSets_RA_STATE(Map var1);

    public abstract Map getX1_eventComponentKeysToServiceIdSets_RA_STATE();

    public abstract void setX1_areAllPassedEventIDsInRaTypeDesc(boolean var1);

    public abstract boolean getX1_areAllPassedEventIDsInRaTypeDesc();

    public abstract void setX1_eventComponentKeysThatAreNotInRaDesc(HashSet var1);

    public abstract HashSet getX1_eventComponentKeysThatAreNotInRaDesc();

    public abstract void setX1_haveEventIDPassedbySleeContainerBeenDoubled(boolean var1);

    public abstract boolean getX1_haveEventIDPassedbySleeContainerBeenDoubled();

    public abstract void setX1_areAllEventIDsPassedToRADecalredByService(boolean var1);

    public abstract boolean getX1_areAllEventIDsPassedToRADecalredByService();

    public abstract void setEndMessage(StringBuffer var1);

    public abstract StringBuffer getEndMessage();

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        container = SleeContainer.lookupFromJndi();
        eventLookup = container.getEventLookupFacility();
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected TimerFacility retrieveTimerFacility() {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            TimerFacility tf = (TimerFacility)myEnv.lookup("slee/facilities/timer");
            return tf;
        }
        catch (NamingException NE) {
            logger.info("COULDNT GET TIMERFACILITY: " + NE.getMessage());
            return null;
        }
    }

    protected ActivityContextInterface retrieveNullActivityContext() {
        ActivityContextInterface localACI = null;
        NullActivityFactory nullACFactory = null;
        NullActivityContextInterfaceFactory nullActivityContextFactory = null;
        try {
            logger.info("Creating nullActivity!!!");
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            nullACFactory = (NullActivityFactory)myEnv.lookup("slee/nullactivity/factory");
            NullActivity na = nullACFactory.createNullActivity();
            nullActivityContextFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            localACI = nullActivityContextFactory.getActivityContextInterface(na);
        }
        catch (NamingException ne) {
            logger.info("Could not create nullActivityFactory: " + ne.getMessage());
        }
        catch (UnrecognizedActivityException UAE) {
            logger.info("Could not create nullActivityContextInterfaceFactory: " + UAE.getMessage());
        }
        return localACI;
    }

    protected void setResultPassed(String msg) throws Exception {
        logger.info("Success: " + msg);
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("result", Boolean.TRUE);
        sbbData.put("message", msg);
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    protected void setResultFailed(String msg) throws Exception {
        logger.info("Failed: " + msg);
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("result", Boolean.FALSE);
        sbbData.put("message", msg);
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    protected void activateTimer() {
        this.tf.setTimer(this.nullACIForTimer, null, System.currentTimeMillis() + 20000L, this.tOptions);
    }

    protected void activateTimer(int miliseconds) {
        this.tf.setTimer(this.nullACIForTimer, null, System.currentTimeMillis() + (long)miliseconds * 1000L, this.tOptions);
    }

    public void onTimeEvent(TimerEvent event, ActivityContextInterface aci) {
    }

    public void onStartServiceEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            HashSet set;
            logger.info("\n------------------------- X1 -----------------------");
            Object[] message = (Object[])event.getMessage();
            this.setServiceID((String)message[0]);
            this.setRaTypeKey((ComponentKey)message[3]);
            this.setRaKey((ComponentKey)message[4]);
            this.setX1_eventIDsPassedToRABySleeContainer((int[])message[1]);
            this.setX1_eventComponentKeysToServiceIdSets_RA_STATE((Map)message[5]);
            String serviceClearID = this.getServiceID().toString().split("\\[")[1].split("\\]")[0];
            ComponentKey serviceKey = new ComponentKey(serviceClearID);
            ServiceIDImpl serviceID = new ServiceIDImpl(serviceKey);
            this.serviceDesc = (ServiceDescriptorImpl)container.getComponentDescriptor((ComponentID)serviceID);
            if (this.serviceDesc == null) {
                throw new IllegalStateException(" SERVICE DESC FOR:\"" + serviceID + "\" RETURNED BY SleeContainerImpl is null.");
            }
            this.setSvc(new ServiceComponent(this.serviceDesc));
            this.setX1_eventComponentKeysThatAreNotInRaDesc(new HashSet());
            this.setEndMessage(new StringBuffer("\n"));
            StringBuffer raport = this.getEndMessage();
            raport.append("\n|========================================================================================|");
            raport.append("\n|                         FINAL RAPORT FOR:                                              |");
            raport.append("\n|========================================================================================|");
            String text = "| RATYPE:" + this.getRaTypeKey();
            String white = "                                                                                                                            ";
            raport.append("\n" + text + white.substring(0, 90 - text.length() - 1) + "|");
            text = "| RA    :" + this.getRaKey();
            raport.append("\n" + text + white.substring(0, 90 - text.length() - 1) + "|");
            raport.append("\n|========================================================================================|");
            logger.info("\n============== X1 ====================\n" + this.getServiceID() + "\n" + this.getRaTypeKey() + "\n" + "" + this.getRaKey() + "\n==================================");
            this.doFirstStageTest();
            String dots = "................................................................................................................";
            text = "| 1. Events passed to RA by container:";
            raport.append("\n" + text + dots.substring(0, 80 - text.length()) + (this.getX1_areAllPassedEventIDsInRaTypeDesc() ? "[PASSED] |" : "[FAILED] |"));
            text = "| 2. Test ids of events passed against doubling.";
            raport.append("\n" + text + dots.substring(0, 80 - text.length()) + (!this.getX1_haveEventIDPassedbySleeContainerBeenDoubled() ? "[PASSED] |" : "[FAILED] |"));
            text = "| 3. Test service against event ids.";
            raport.append("\n" + text + dots.substring(0, 80 - text.length()) + (this.getX1_areAllEventIDsPassedToRADecalredByService() ? "[PASSED] |" : "[FAILED] |"));
            raport.append("\n|----------------------------------------------------------------------------------------|");
            raport.append("\n| TESTs EXAPLANATIONS:                                                                   |");
            raport.append("\n| Tests 1-3 are meant to test if SleeContainerImpl conforms to Slee Specs 1.1            |");
            raport.append("\n| section 15.4.2.15 page 302.                                                            |");
            raport.append("\n|----------------------------------------------------------------------------------------|");
            raport.append("\n| 1. Checks if SleeContainer passes eventIDs of events that are decalred in              |");
            raport.append("\n|    RA TYPE that this RA implements.                                                    |");
            raport.append("\n| 2. Chcecks if SleeContainer did not double eventIDs - this can happen when             |");
            raport.append("\n|    more than one sbb decalres that it wants to receive particualr event.               |");
            raport.append("\n| 3. Checks if eventIDs passed by SleeContainer are of interest of service.              |");
            raport.append("\n|========================================================================================|");
            raport.append("\n| SOME DEBUG INFO:                                                                       |");
            raport.append("\n|----------------------------------------------------------------------------------------|");
            raport.append("\n| EVENTS DECALRED BY RA TYPE:                                                            |");
            ResourceAdaptorTypeIDImpl raTypeID = new ResourceAdaptorTypeIDImpl(this.getRaTypeKey());
            ResourceAdaptorType raType = container.getResourceAdaptorType((ResourceAdaptorTypeID)raTypeID);
            ComponentKey[] raTypEventRefs = raType.getRaTypeDescr().getEventTypeRefEntries();
            text = "\n| ";
            try {
                for (int i = 0; i < raTypEventRefs.length; ++i) {
                    if (89 - text.length() <= 0) {
                        white = white + white;
                    }
                    if ((text + raTypEventRefs[i]).length() > 88) {
                        raport.append(text + white.substring(0, 89 - text.length()) + " |");
                        text = "\n| ";
                        continue;
                    }
                    text = text + raTypEventRefs[i];
                }
                raport.append(text + white.substring(0, 89 - text.length()) + " |");
            }
            catch (Exception e) {
                text = text + "ERROR!!!";
                if (89 - text.length() <= 0) {
                    white = white + white;
                }
                raport.append(text + white.substring(0, 89 - text.length()) + " |");
                e.printStackTrace();
            }
            raport.append("\n|                                                                                        |");
            raport.append("\n| EVENTS PASSED TO RA ON INSTALL:                                                        |");
            text = "\n| ";
            int[] eventIDs = this.getX1_eventIDsPassedToRABySleeContainer();
            logger.info("EVENT NUMBER:" + eventIDs.length);
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    ComponentKey key = container.getEventKey(eventLookup.getEventTypeID(eventIDs[i]));
                    logger.info("KEY:" + key);
                    text = text + key;
                    if (89 - text.length() <= 0) {
                        white = white + white;
                    }
                    raport.append(text + white.substring(0, 89 - text.length()) + " |");
                    text = "\n| ";
                }
                raport.append(text + white.substring(0, 89 - text.length()) + " |");
            }
            catch (Exception e) {
                text = text + "ERROR!!!";
                if (89 - text.length() <= 0) {
                    white = white + white;
                }
                raport.append(text + white.substring(0, 89 - text.length()) + " |");
                e.printStackTrace();
            }
            raport.append("\n|                                                                                        |");
            raport.append("\n| EVENTS DECLARED BY SERVICE:                                                            |");
            try {
                HashSet sbbIDs = this.getSvc().getSbbComponents();
                Iterator sbbIdsIterator = sbbIDs.iterator();
                int sbbNum = 0;
                while (sbbIdsIterator.hasNext()) {
                    SbbDescriptorImpl sbbdesc = (SbbDescriptorImpl)container.getSbbComponent((SbbID)sbbIdsIterator.next());
                    if (sbbdesc == null) continue;
                    HashMap eventTypeIdToEventEntriesMappings = sbbdesc.getEventTypesMappings();
                    Iterator it = eventTypeIdToEventEntriesMappings.values().iterator();
                    text = "\n| SBB:" + sbbNum++ + "#EVENTS COUNT:" + eventTypeIdToEventEntriesMappings.values().size();
                    if (89 - text.length() <= 0) {
                        white = white + white;
                    }
                    raport.append(text + white.substring(0, 89 - text.length()) + " |");
                    text = "\n| ";
                    ComponentKey key = null;
                    String valueOfKey = null;
                    int counter = 0;
                    while (it.hasNext()) {
                        Object o = it.next();
                        SbbEventEntry eventEntry = (SbbEventEntry)o;
                        try {
                            key = eventEntry.getEventTypeRefKey();
                            valueOfKey = key.toString();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            valueOfKey = "[" + counter + "] -> VALUE NOT VALID?: " + o;
                        }
                        catch (Error er) {
                            er.printStackTrace();
                            valueOfKey = "[" + counter + "] -> VALUE NOT VALID?: " + o;
                        }
                        text = text + "\"" + valueOfKey + "\"";
                        if (89 - text.length() <= 0) {
                            white = white + white;
                        }
                        raport.append(text + white.substring(0, 89 - text.length()) + " |");
                        text = "\n| ";
                        ++counter;
                    }
                }
                raport.append(text + white.substring(0, 89 - text.length()) + " |");
            }
            catch (Exception e) {
                text = text + "ERROR!!!";
                e.printStackTrace();
            }
            raport.append("\n|                                                                                        |");
            if (this.getX1_eventComponentKeysThatAreNotInRaDesc() == null) {
                this.setX1_eventComponentKeysThatAreNotInRaDesc(new HashSet());
            }
            if ((set = this.getX1_eventComponentKeysThatAreNotInRaDesc()).size() > 0) {
                raport.append("\n| EVENTS PASSED BUT NOT PRESENT IN RA TYPE DESC:                                         |");
                logger.log(Level.FINEST, "\n========================== 1 ===========================");
                Iterator it = set.iterator();
                try {
                    text = "\n| ";
                    while (it.hasNext()) {
                        logger.log(Level.FINEST, "\n========================== 2 ===========================");
                        ComponentKey key = (ComponentKey)it.next();
                        if (89 - (text + key).length() <= 0) {
                            white = white + white;
                        }
                        if ((text + key).length() > 88) {
                            logger.log(Level.FINEST, "\n========================== 3 ===========================");
                            raport.append(text + white.substring(0, 89 - text.length()) + " |");
                            text = "\n| ";
                            continue;
                        }
                        text = text + key;
                    }
                    logger.log(Level.FINEST, "\n========================== 4 ===========================");
                    raport.append(text + white.substring(0, 89 - text.length()) + " |");
                }
                catch (Exception e) {
                    text = text + "ERROR!!!";
                    raport.append(text + white.substring(0, 89 - text.length()) + " |");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            try {
                this.setResultFailed(this.getEndMessage() + "\nERROR:\n" + e);
            }
            catch (Exception e1) {
                TCKSbbUtils.handleException((Exception)e1);
                e1.printStackTrace();
                return;
            }
            e.printStackTrace();
            return;
        }
        try {
            if (this.getX1_areAllPassedEventIDsInRaTypeDesc() && !this.getX1_haveEventIDPassedbySleeContainerBeenDoubled() && this.getX1_areAllEventIDsPassedToRADecalredByService()) {
                this.setResultPassed(this.getEndMessage().toString());
            } else {
                this.setResultFailed(this.getEndMessage().toString());
            }
        }
        catch (Exception e) {
            try {
                this.setResultFailed(this.getEndMessage() + "\nERROR:\n" + e);
            }
            catch (Exception e1) {
                TCKSbbUtils.handleException((Exception)e1);
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void doFirstStageTest() throws Exception {
        ResourceAdaptorTypeIDImpl raTypeID = new ResourceAdaptorTypeIDImpl(this.getRaTypeKey());
        ResourceAdaptorType raType = container.getResourceAdaptorType((ResourceAdaptorTypeID)raTypeID);
        EventTypeID[] eventTypeIDs = raType.getRaTypeDescr().getEventTypes();
        HashSet<EventTypeID> setOfEventIDsRaTypeDecalers = new HashSet<EventTypeID>(20);
        for (int i = 0; i < eventTypeIDs.length; ++i) {
            ComponentKey key = container.getEventKey(eventTypeIDs[i]);
            int eventID = eventLookup.getEventID(key);
            if (eventID == -1) {
                throw new Exception(" EVENT: " + key + " IS NOT REGISTERED EVENT TYPE!!!");
            }
            setOfEventIDsRaTypeDecalers.add(eventLookup.getEventTypeID(eventID));
        }
        HashSet<EventTypeID> eventsPassedToRABySleeContainer = new HashSet<EventTypeID>();
        int[] X1_eventIDsPassedToRABySleeContainer = this.getX1_eventIDsPassedToRABySleeContainer();
        for (int i = 0; i < X1_eventIDsPassedToRABySleeContainer.length; ++i) {
            if (X1_eventIDsPassedToRABySleeContainer[i] == -1) {
                throw new Exception(" EVENT PASSED FROM SLEE  IS NOT REGISTERED EVENT TYPE!!!");
            }
            eventsPassedToRABySleeContainer.add(eventLookup.getEventTypeID(X1_eventIDsPassedToRABySleeContainer[i]));
        }
        if (X1_eventIDsPassedToRABySleeContainer.length != eventsPassedToRABySleeContainer.size()) {
            this.setX1_haveEventIDPassedbySleeContainerBeenDoubled(true);
        } else {
            this.setX1_haveEventIDPassedbySleeContainerBeenDoubled(false);
        }
        this.setX1_areAllPassedEventIDsInRaTypeDesc(setOfEventIDsRaTypeDecalers.containsAll(eventsPassedToRABySleeContainer));
        if (!this.getX1_areAllPassedEventIDsInRaTypeDesc()) {
            HashSet tmp = new HashSet(eventsPassedToRABySleeContainer);
            tmp.removeAll(setOfEventIDsRaTypeDecalers);
            Iterator it = tmp.iterator();
            if (this.getX1_eventComponentKeysThatAreNotInRaDesc() == null) {
                this.setX1_eventComponentKeysThatAreNotInRaDesc(new HashSet());
            }
            while (it.hasNext()) {
                EventTypeID id = (EventTypeID)it.next();
                ComponentKey wrongEventKey = container.getEventKey(id);
                this.getX1_eventComponentKeysThatAreNotInRaDesc().add(wrongEventKey);
            }
        }
        HashSet sbbIDs = this.getSvc().getSbbComponents();
        Iterator sbbIdsIterator = sbbIDs.iterator();
        HashSet eventTypeIDsOfServiceInterest = new HashSet();
        while (sbbIdsIterator.hasNext()) {
            SbbDescriptorImpl sbbdesc = (SbbDescriptorImpl)container.getSbbComponent((SbbID)sbbIdsIterator.next());
            if (sbbdesc == null) continue;
            HashMap eventTypeIdToEventEntriesMappings = sbbdesc.getEventTypesMappings();
            eventTypeIDsOfServiceInterest.addAll(eventTypeIdToEventEntriesMappings.keySet());
        }
        this.setX1_areAllEventIDsPassedToRADecalredByService(eventTypeIDsOfServiceInterest.containsAll(eventsPassedToRABySleeContainer));
    }

    public InitialEventSelector chooseService(InitialEventSelector ies) {
        Object event = ies.getEvent();
        try {
            if (event instanceof TCKResourceEventImpl) {
                TCKResourceEventImpl tckEvent = (TCKResourceEventImpl)event;
                String eventName = tckEvent.getEventTypeName();
                if (eventName.indexOf("X.X") != -1) {
                    TCKResourceEventX xEvent = (TCKResourceEventX)event;
                    Object[] message = (Object[])xEvent.getMessage();
                    String serviceID = message[0].toString();
                    String name = serviceID.split("\\[")[1].split("\\]")[0];
                    name = message[3] + "_" + message[4] + "_" + name;
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                    logger.log(Level.FINEST, "\n================= NAMEX ================================\n" + name + "\n=======================================================");
                } else {
                    TCKResourceEventY yEvent = (TCKResourceEventY)event;
                    Object[] message = (Object[])yEvent.getMessage();
                    String serviceID = message[0].toString();
                    String name = serviceID.split("\\[")[1].split("\\]")[0];
                    name = message[1] + "_" + message[2] + "_" + name;
                    logger.log(Level.FINEST, "\n================= NAMEY ================================\n" + name + "\n=======================================================");
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                }
            } else {
                ies.setInitialEvent(false);
            }
            logger.log(Level.FINEST, "\n----------------------------------------------------\nISE:\n" + ies + "\n-------------------------------------------------");
            return ies;
        }
        catch (Exception e) {
            e.printStackTrace();
            ies.setInitialEvent(false);
            return ies;
        }
    }
}

