/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.container.raconfig;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.io.DataInputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Map;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class RaConfigTest
extends AbstractSleeTCKTest {
    protected FutureResult result;
    private String ra = "ResourceAdaptorID[DUMMYRA#org.mobicents#1.0]";
    private String raLink = "test-link";
    SleeCommandInterface sleeCommandInterface = null;
    String path = null;

    public void setUp() throws Exception {
        super.setUp();
        String home = System.getProperty("user.dir");
        System.out.println("***** HOME*****\n" + home);
        this.sleeCommandInterface = new SleeCommandInterface("jnp://127.0.0.1:1099");
        this.path = "file:" + home + "/tests/lib/container/";
        this.getLog().info("\n========================\nConnecting to resource\n========================\n");
        TestResourceListenerImpl resourceListener = new TestResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
    }

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String activityName = this.utils().getTestParams().getProperty("activityName");
        TCKActivityID activityID = resource.createActivity(activityName);
        this.checkDefaultConfig();
        this.checkProvisionedConfig();
        this.utils().getLog().fine("Firing TCKResourceEventX.X1 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", (Object)"com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDefaultConfig() throws Exception {
        Socket socket;
        Object opResult;
        boolean entityActivated;
        boolean entityCreated;
        boolean raInstalled;
        boolean ratypeInstalled;
        block24: {
            ratypeInstalled = false;
            raInstalled = false;
            entityCreated = false;
            entityActivated = false;
            boolean linkCreated = false;
            opResult = null;
            socket = null;
            try {
                String stringProperty;
                short shortProperty;
                long longProperty;
                int intProperty;
                float floatProperty;
                double doubleProperty;
                byte byteProperty;
                this.getLog().info("== DEPOYING DUMMY RA TYPE ==");
                opResult = this.sleeCommandInterface.invokeOperation("-install", this.path + "dummy-ratype.jar", null, null);
                this.getLog().info("Result: " + opResult);
                ratypeInstalled = true;
                this.getLog().info("== DEPOYING DUMMY RA ==");
                opResult = this.sleeCommandInterface.invokeOperation("-install", this.path + "dummy-local-ra.jar", null, null);
                this.getLog().info(" == DEPLOYED RA:" + opResult + " ==");
                raInstalled = true;
                this.getLog().info(" == CREATING RA ENTITY:" + this.ra + " ==");
                opResult = this.sleeCommandInterface.invokeOperation("-createRaEntity", this.ra, this.raLink, null);
                this.getLog().info(" == RA ENTITY CREATED:" + opResult + " ==");
                entityCreated = true;
                this.getLog().info(" == ACTIVATING RA ENTITY:" + this.ra + " ==");
                opResult = this.sleeCommandInterface.invokeOperation("-activateRaEntity", this.raLink, null, null);
                this.getLog().info(" == RA ENTITY ACTIVATED:" + opResult + " ==");
                entityActivated = true;
                this.getLog().info(" == CREATING RA LINK:" + this.raLink + " ==");
                opResult = this.sleeCommandInterface.invokeOperation("-createRaLink", this.raLink, this.raLink, null);
                this.getLog().info(" == RA LINK CREATED:" + opResult + " ==");
                linkCreated = true;
                socket = new Socket("localhost", 9201);
                socket.getOutputStream().write(1);
                DataInputStream in = new DataInputStream(socket.getInputStream());
                boolean booleanProperty = in.readBoolean();
                if (!booleanProperty) {
                    this.result.setFailed(0, "Boolean value is wrong. Should be true");
                }
                if ((byteProperty = in.readByte()) != 1) {
                    this.result.setFailed(0, "Default byte value should be equal to 1. Instead it is " + byteProperty);
                }
                if ((doubleProperty = in.readDouble()) != 1.0) {
                    this.result.setFailed(0, "Default double value should be equal to 1. Instead it is " + doubleProperty);
                }
                if ((floatProperty = in.readFloat()) != 1.0f) {
                    this.result.setFailed(0, "Default float value should be equal to 1. Instead it is " + floatProperty);
                }
                if ((intProperty = in.readInt()) != 1) {
                    this.result.setFailed(0, "Default int value should be equal to 1. Instead it is " + intProperty);
                }
                if ((longProperty = in.readLong()) != 1L) {
                    this.result.setFailed(0, "Default long value should be equal to 1. Instead it is " + longProperty);
                }
                if ((shortProperty = in.readShort()) != 1) {
                    this.result.setFailed(0, "Default short value should be equal to 1. Instead it is " + shortProperty);
                }
                if (!(stringProperty = in.readUTF()).equals("text1")) {
                    this.result.setFailed(0, "Default string value should be equal to 'text1'. Instead it is '" + stringProperty + "'");
                }
                Object var20_17 = null;
                if (!linkCreated) break block24;
            }
            catch (Throwable throwable) {
                Object var20_18 = null;
                if (linkCreated) {
                    opResult = this.sleeCommandInterface.invokeOperation("-removeRaLink", this.raLink, null, null);
                    this.getLog().info(" == RA LINK REMOVED:" + opResult + " ==");
                }
                if (entityActivated) {
                    opResult = this.sleeCommandInterface.invokeOperation("-deactivateRaEntity", this.raLink, null, null);
                    this.getLog().info(" == RA ENTITY DEACTIVATED:" + opResult + " ==");
                }
                if (entityCreated) {
                    opResult = this.sleeCommandInterface.invokeOperation("-removeRaEntity", this.raLink, null, null);
                    this.getLog().info(" == RA ENTITY REMOVED:" + opResult + " ==");
                }
                if (raInstalled) {
                    opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-local-ra.jar", null, null);
                    this.getLog().info(" == RA UNINSTALLED:" + opResult + " ==");
                }
                if (ratypeInstalled) {
                    opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-ratype.jar", null, null);
                    this.getLog().info(" == RA TYPE UNINSTALLED:" + opResult + " ==");
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            opResult = this.sleeCommandInterface.invokeOperation("-removeRaLink", this.raLink, null, null);
            this.getLog().info(" == RA LINK REMOVED:" + opResult + " ==");
        }
        if (entityActivated) {
            opResult = this.sleeCommandInterface.invokeOperation("-deactivateRaEntity", this.raLink, null, null);
            this.getLog().info(" == RA ENTITY DEACTIVATED:" + opResult + " ==");
        }
        if (entityCreated) {
            opResult = this.sleeCommandInterface.invokeOperation("-removeRaEntity", this.raLink, null, null);
            this.getLog().info(" == RA ENTITY REMOVED:" + opResult + " ==");
        }
        if (raInstalled) {
            opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-local-ra.jar", null, null);
            this.getLog().info(" == RA UNINSTALLED:" + opResult + " ==");
        }
        if (ratypeInstalled) {
            opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-ratype.jar", null, null);
            this.getLog().info(" == RA TYPE UNINSTALLED:" + opResult + " ==");
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkProvisionedConfig() throws Exception {
        Socket socket;
        Object opResult;
        String provisionedLink;
        boolean entityActivated;
        boolean entityCreated;
        boolean raInstalled;
        boolean ratypeInstalled;
        block24: {
            ratypeInstalled = false;
            raInstalled = false;
            entityCreated = false;
            entityActivated = false;
            boolean linkCreated = false;
            provisionedLink = this.raLink + "-provisioned";
            opResult = null;
            socket = null;
            try {
                String stringProperty;
                short shortProperty;
                long longProperty;
                int intProperty;
                float floatProperty;
                double doubleProperty;
                byte byteProperty;
                this.getLog().info("== DEPOYING DUMMY RA TYPE ==");
                opResult = this.sleeCommandInterface.invokeOperation("-install", this.path + "dummy-ratype.jar", null, null);
                this.getLog().info("Result: " + opResult);
                ratypeInstalled = true;
                this.getLog().info("== DEPOYING DUMMY RA ==");
                opResult = this.sleeCommandInterface.invokeOperation("-install", this.path + "dummy-local-ra.jar", null, null);
                this.getLog().info(" == DEPLOYED RA:" + opResult + " ==");
                raInstalled = true;
                this.getLog().info(" == CREATING RA ENTITY:" + this.ra + " ==");
                opResult = this.sleeCommandInterface.invokeOperation("-createRaEntity", this.ra, provisionedLink, this.path + "dummy-ra.properties");
                this.getLog().info(" == RA ENTITY CREATED:" + opResult + " ==");
                entityCreated = true;
                this.getLog().info(" == ACTIVATING RA ENTITY:" + this.ra + " ==");
                opResult = this.sleeCommandInterface.invokeOperation("-activateRaEntity", provisionedLink, null, null);
                this.getLog().info(" == RA ENTITY ACTIVATED:" + opResult + " ==");
                entityActivated = true;
                this.getLog().info(" == CREATING RA LINK:" + this.raLink + " ==");
                opResult = this.sleeCommandInterface.invokeOperation("-createRaLink", provisionedLink, provisionedLink, null);
                this.getLog().info(" == RA LINK CREATED:" + opResult + " ==");
                linkCreated = true;
                socket = new Socket("localhost", 9201);
                socket.getOutputStream().write(1);
                DataInputStream in = new DataInputStream(socket.getInputStream());
                boolean booleanProperty = in.readBoolean();
                if (booleanProperty) {
                    this.result.setFailed(0, "Provisioned boolean value is wrong. Should be false.");
                }
                if ((byteProperty = in.readByte()) != 2) {
                    this.result.setFailed(0, "Provisioned byte value should be equal to 2. Instead it is " + byteProperty);
                }
                if ((doubleProperty = in.readDouble()) != 2.0) {
                    this.result.setFailed(0, "Provisioned double value should be equal to 2. Instead it is " + doubleProperty);
                }
                if ((floatProperty = in.readFloat()) != 2.0f) {
                    this.result.setFailed(0, "Provisioned float value should be equal to 2. Instead it is " + floatProperty);
                }
                if ((intProperty = in.readInt()) != 2) {
                    this.result.setFailed(0, "Provisioned int value should be equal to 2. Instead it is " + intProperty);
                }
                if ((longProperty = in.readLong()) != 2L) {
                    this.result.setFailed(0, "Provisioned long value should be equal to 2. Instead it is " + longProperty);
                }
                if ((shortProperty = in.readShort()) != 2) {
                    this.result.setFailed(0, "Provisioned short value should be equal to 2. Instead it is " + shortProperty);
                }
                if (!(stringProperty = in.readUTF()).equals("text2")) {
                    this.result.setFailed(0, "Provisioned string value should be equal to 'text2'. Instead it is '" + stringProperty + "'");
                }
                Object var21_18 = null;
                if (!linkCreated) break block24;
            }
            catch (Throwable throwable) {
                Object var21_19 = null;
                if (linkCreated) {
                    opResult = this.sleeCommandInterface.invokeOperation("-removeRaLink", provisionedLink, null, null);
                    this.getLog().info(" == RA LINK REMOVED:" + opResult + " ==");
                }
                if (entityActivated) {
                    opResult = this.sleeCommandInterface.invokeOperation("-deactivateRaEntity", provisionedLink, null, null);
                    this.getLog().info(" == RA ENTITY DEACTIVATED:" + opResult + " ==");
                }
                if (entityCreated) {
                    opResult = this.sleeCommandInterface.invokeOperation("-removeRaEntity", provisionedLink, null, null);
                    this.getLog().info(" == RA ENTITY REMOVED:" + opResult + " ==");
                }
                if (raInstalled) {
                    opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-local-ra.jar", null, null);
                    this.getLog().info(" == RA UNINSTALLED:" + opResult + " ==");
                }
                if (ratypeInstalled) {
                    opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-ratype.jar", null, null);
                    this.getLog().info(" == RA TYPE UNINSTALLED:" + opResult + " ==");
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            opResult = this.sleeCommandInterface.invokeOperation("-removeRaLink", provisionedLink, null, null);
            this.getLog().info(" == RA LINK REMOVED:" + opResult + " ==");
        }
        if (entityActivated) {
            opResult = this.sleeCommandInterface.invokeOperation("-deactivateRaEntity", provisionedLink, null, null);
            this.getLog().info(" == RA ENTITY DEACTIVATED:" + opResult + " ==");
        }
        if (entityCreated) {
            opResult = this.sleeCommandInterface.invokeOperation("-removeRaEntity", provisionedLink, null, null);
            this.getLog().info(" == RA ENTITY REMOVED:" + opResult + " ==");
        }
        if (raInstalled) {
            opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-local-ra.jar", null, null);
            this.getLog().info(" == RA UNINSTALLED:" + opResult + " ==");
        }
        if (ratypeInstalled) {
            opResult = this.sleeCommandInterface.invokeOperation("-uninstall", this.path + "dummy-ratype.jar", null, null);
            this.getLog().info(" == RA TYPE UNINSTALLED:" + opResult + " ==");
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e) {}
        }
    }

    private class TestResourceListenerImpl
    extends BaseTCKResourceListener {
        private TestResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            RaConfigTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                RaConfigTest.this.result.setPassed();
            } else {
                RaConfigTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            RaConfigTest.this.getLog().warning("Received exception from SBB or resource:");
            RaConfigTest.this.getLog().warning((Throwable)exception);
            RaConfigTest.this.result.setError((Throwable)exception);
        }
    }
}

