/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.du.dependencyRemoval1;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.slee.management.DependencyException;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class DependencyRemovalTest1
extends AbstractSleeTCKTest {
    protected FutureResult result;
    private TCKActivityID tckActivityID = null;
    private String activityName = null;
    private String jnpHostURL = "jnp://127.0.0.1:1099";
    private String du1_name = "DU2-DU.jar";
    private String du2_name = "DU3-DU.jar";
    private String service1_id = "Service2#mobicents#0.1";
    private String service2_id = "Service3#mobicents#0.1";
    private ComponentKey s1_id = new ComponentKey(this.service1_id);
    private ServiceIDImpl service_1 = new ServiceIDImpl(this.s1_id);
    private ComponentKey s2_id = new ComponentKey(this.service2_id);
    private ServiceIDImpl service_2 = new ServiceIDImpl(this.s2_id);
    private DeployableUnitIDImpl duID1Impl;
    private DeployableUnitIDImpl duID2Impl;

    public void setUp() throws Exception {
        super.setUp();
        this.getLog().info("\n========================\nConnecting to resource\n========================\n");
        TestResourceListenerImpl resourceListener = new TestResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
    }

    public void run(FutureResult result) throws Exception {
        Object opResult;
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.activityName = this.utils().getTestParams().getProperty("activityName");
        this.tckActivityID = resource.createActivity(this.activityName);
        Properties props = new Properties();
        try {
            this.getLog().info(" == LOADING PROPS FROM: test.properties ==");
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("test.properties"));
            this.jnpHostURL = props.getProperty("jnpHost", this.jnpHostURL);
            this.du1_name = props.getProperty("du1.name", this.du1_name);
            this.du2_name = props.getProperty("du2.name", this.du2_name);
            this.service1_id = props.getProperty("service1.id", this.service1_id);
            this.service2_id = props.getProperty("service2.id", this.service2_id);
            this.s1_id = new ComponentKey(this.service1_id);
            this.service_1 = new ServiceIDImpl(this.s1_id);
            this.s2_id = new ComponentKey(this.service2_id);
            this.service_2 = new ServiceIDImpl(this.s2_id);
            this.getLog().info(" == FINISHED LOADING PROPS ==");
        }
        catch (Exception IOE) {
            this.getLog().info("FAILED TO LOAD: test.properties");
        }
        this.utils().getLog().info("\n===================\nSTARTING DEPLOYMENT IN FEW uS\n===================\nACTIVITY:" + this.activityName + "\n=======================================");
        String mcHOME = System.getProperty("MOBICENTS_HOME");
        if (mcHOME == null) {
            result.setError(" == The System Property MOBICENTS_HOME is required, but does not exist!! ==");
        }
        SleeCommandInterface SCI = new SleeCommandInterface(this.jnpHostURL);
        String dusPATH = "file://" + mcHOME + "/tests/lib/container/";
        this.getLog().info(" == STARTIGN DEPLOYMENT ==");
        ArrayList<Exception> errors = new ArrayList<Exception>(2);
        boolean s2_activated = false;
        boolean s1_activated = false;
        boolean du2_installed = false;
        boolean du1_installed = false;
        try {
            opResult = null;
            this.getLog().info(" == INSTALLING TEST SERVICE1:" + dusPATH + this.du1_name + " ==");
            opResult = SCI.invokeOperation("-install", dusPATH + this.du1_name, null, null);
            this.getLog().info(" == SERVICE INSTALLED:" + opResult + " ==");
            this.duID1Impl = (DeployableUnitIDImpl)opResult;
            du1_installed = true;
            this.getLog().info(" == INSTALLING TEST SERVICE2:" + dusPATH + this.du2_name + " ==");
            opResult = SCI.invokeOperation("-install", dusPATH + this.du2_name, null, null);
            this.getLog().info(" == SERVICE INSTALLED:" + opResult + " ==");
            this.duID2Impl = (DeployableUnitIDImpl)opResult;
            du2_installed = true;
            this.getLog().info(" == ACTIVATING SERVICE [" + this.service_1 + "] ==");
            opResult = SCI.invokeOperation("-activateService", this.service_1.toString(), null, null);
            this.getLog().info(" == SERVICE ACTIVATED:" + opResult + " ==");
            s1_activated = true;
            this.getLog().info(" == ACTIVATING SERVICE [" + this.service_2 + "] ==");
            opResult = SCI.invokeOperation("-activateService", this.service_2.toString(), null, null);
            this.getLog().info(" == SERVICE ACTIVATED:" + opResult + " ==");
            s2_activated = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add(e);
        }
        this.getLog().info("FIRING X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", (Object)"com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.tckActivityID, null);
        this.getLog().info("WAITING FOR 4 RECEIVALS ");
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getLog().info(" === TRYING TO REMOVE DU1[" + this.du1_name + "] , THIS SHOULD FAIL - DependencyException");
        opResult = null;
        try {
            if (s2_activated) {
                this.getLog().info(" == DEACTIVATING SERVICE[" + this.service_1 + "] ==");
                opResult = SCI.invokeOperation("-deactivateService", this.service_1.toString(), null, null);
                s1_activated = !s1_activated;
                this.getLog().info(" == SERVICE DEACTIVATED:" + opResult + " ==");
            }
            if (du2_installed) {
                this.getLog().info(" == REMOVING DU[" + this.du1_name + "] ==");
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.du1_name, null, null);
                du1_installed = !du1_installed;
                this.getLog().info(" == SERVICE UNINSTALLED:" + opResult + " ==");
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null || !(cause instanceof DependencyException)) {
                result.setFailed(0, " DIDNT REECEIVE DEPENDENCY EXCEPTION, GOT [" + cause + "]");
            }
            this.getLog().info("== Seems like DU1 has nto been uninstalled, testing Sbb1,2 and 3");
        }
        Object[] message = new Object[]{this.duID1Impl, this.service1_id, this.duID2Impl, this.service2_id};
        this.getLog().info("FIRING X2");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", (Object)message, this.tckActivityID, null);
        try {
            Thread.currentThread();
            Thread.sleep(2500L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getLog().info("START REMOVAL OF SERVICES[" + s2_activated + "]");
            if (s2_activated) {
                this.getLog().info(" == DEACTIVATING SERVICE[" + this.service_2 + "] ==");
                opResult = SCI.invokeOperation("-deactivateService", this.service_2.toString(), null, null);
                s2_activated = !s2_activated;
                this.getLog().info(" == SERVICE DEACTIVATED:" + opResult + " ==");
            }
            if (du2_installed) {
                this.getLog().info(" == REMOVING DU[" + this.du2_name + "] ==");
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.du2_name, null, null);
                du2_installed = !du2_installed;
                this.getLog().info(" == SERVICE UNINSTALLED:" + opResult + " ==");
            }
        }
        catch (Exception e) {
            result.setFailed(0, " == FAILED REMOVING DU2[" + e + "] ==");
            return;
        }
        this.getLog().info("== DU2 REMOVED - Testing if Sbb2 is still present ==");
        message = new Object[]{this.duID1Impl, this.service1_id, this.duID2Impl, this.service2_id};
        this.getLog().info("FIRING Y1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", (Object)message, this.tckActivityID, null);
        try {
            Thread.currentThread();
            Thread.sleep(2500L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getLog().info("START REMOVAL OF SERVICES[" + s2_activated + "]");
            if (s2_activated) {
                this.getLog().info(" == DEACTIVATING SERVICE[" + this.service_2 + "] ==");
                opResult = SCI.invokeOperation("-deactivateService", this.service_2.toString(), null, null);
                s2_activated = !s2_activated;
                this.getLog().info(" == SERVICE DEACTIVATED:" + opResult + " ==");
            }
            if (du2_installed) {
                this.getLog().info(" == REMOVING DU[" + this.du2_name + "] ==");
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.du2_name, null, null);
                du2_installed = !du2_installed;
                this.getLog().info(" == SERVICE UNINSTALLED:" + opResult + " ==");
            }
            if (s1_activated) {
                this.getLog().info(" == DEACTIVATING SERVICE[" + this.service_1 + "] ==");
                opResult = SCI.invokeOperation("-deactivateService", this.service_1.toString(), null, null);
                s1_activated = !s1_activated;
                this.getLog().info(" == SERVICE DEACTIVATED:" + opResult + " ==");
            }
            if (du1_installed) {
                this.getLog().info(" == REMOVING DU[" + this.du1_name + "] ==");
                opResult = SCI.invokeOperation("-uninstall", dusPATH + this.du1_name, null, null);
                du1_installed = !du1_installed;
                this.getLog().info(" == SERVICE UNINSTALLED:" + opResult + " ==");
            }
        }
        catch (Exception e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            this.getLog().info(" == SOME ERRORS OCURED!!: ==");
            StringBuffer sb = new StringBuffer(400);
            StringBuffer stackTraceSb = null;
            Iterator it = errors.iterator();
            int i = 0;
            while (it.hasNext()) {
                Exception ex = (Exception)it.next();
                StackTraceElement[] ste = ex.getStackTrace();
                if (ste != null && ste.length > 0) {
                    stackTraceSb = new StringBuffer(1000);
                    stackTraceSb.append("\n");
                    for (int c = 0; c < ste.length; ++c) {
                        stackTraceSb.append("=>" + ste[c].getClassName() + " -> " + ste[c].getMethodName() + ":" + ste[c].getLineNumber() + "\n");
                    }
                }
                sb.append("\n[#" + i++ + "] -> " + ex.getMessage());
                if (stackTraceSb != null) {
                    sb.append("\nTRACE:\n" + stackTraceSb + "\n");
                }
                stackTraceSb = null;
            }
            this.getLog().info(" == ERROR INFO: ==\n" + sb);
        }
    }

    private class TestResourceListenerImpl
    extends BaseTCKResourceListener {
        private TestResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            DependencyRemovalTest1.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                DependencyRemovalTest1.this.result.setPassed();
            } else {
                DependencyRemovalTest1.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            DependencyRemovalTest1.this.getLog().warning("Received exception from SBB or resource:");
            DependencyRemovalTest1.this.getLog().warning((Throwable)exception);
            DependencyRemovalTest1.this.result.setError((Throwable)exception);
        }
    }
}

