/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.junit.wrapper;

import com.opencloud.sleetck.lib.resource.impl.TCKResourceEventImpl;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;

public abstract class JunitTestSbb
extends BaseTCKSbb {
    protected ActivityContextInterface nullACIForTimer = null;
    protected TimerOptions tOptions = new TimerOptions(false, 5000L, TimerPreserveMissed.LAST);
    protected static Logger logger = Logger.getLogger(JunitTestSbb.class.toString());
    protected TimerFacility tf = null;
    protected SbbContext sbbContext;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected TimerFacility retrieveTimerFacility() {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            TimerFacility tf = (TimerFacility)myEnv.lookup("slee/facilities/timer");
            return tf;
        }
        catch (NamingException NE) {
            logger.info("COULDNT GET TIMERFACILITY: " + NE.getMessage());
            return null;
        }
    }

    protected ActivityContextInterface retrieveNullActivityContext() {
        ActivityContextInterface localACI = null;
        NullActivityFactory nullACFactory = null;
        NullActivityContextInterfaceFactory nullActivityContextFactory = null;
        try {
            logger.info("Creating nullActivity!!!");
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            nullACFactory = (NullActivityFactory)myEnv.lookup("slee/nullactivity/factory");
            NullActivity na = nullACFactory.createNullActivity();
            nullActivityContextFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            localACI = nullActivityContextFactory.getActivityContextInterface(na);
        }
        catch (NamingException ne) {
            logger.info("Could not create nullActivityFactory: " + ne.getMessage());
        }
        catch (UnrecognizedActivityException UAE) {
            logger.info("Could not create nullActivityContextInterfaceFactory: " + UAE.getMessage());
        }
        return localACI;
    }

    protected void setResultPassed(String msg) throws Exception {
        logger.info("Success: " + msg);
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("result", Boolean.TRUE);
        sbbData.put("message", msg);
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    protected void setResultFailed(String msg) throws Exception {
        logger.info("Failed: " + msg);
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("result", Boolean.FALSE);
        sbbData.put("message", msg);
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    protected void activateTimer() {
        this.tf.setTimer(this.nullACIForTimer, null, System.currentTimeMillis() + 20000L, this.tOptions);
    }

    protected void activateTimer(int miliseconds) {
        this.tf.setTimer(this.nullACIForTimer, null, System.currentTimeMillis() + (long)miliseconds * 1000L, this.tOptions);
    }

    public void onTimeEvent(TimerEvent event, ActivityContextInterface aci) {
    }

    public void onStartServiceEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        logger.info(" == SERVICE ACTIVATED ==");
    }

    public InitialEventSelector chooseService(InitialEventSelector ies) {
        Object event = ies.getEvent();
        logger.info("IES CALLED");
        try {
            if (event instanceof TCKResourceEventImpl) {
                TCKResourceEventImpl tckEvent = (TCKResourceEventImpl)event;
                String eventName = tckEvent.getEventTypeName();
                if (eventName.indexOf("X.X1") != -1) {
                    String name = "X1_NAME";
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                } else if (eventName.indexOf("X.X2") != -1) {
                    String name = "X2_NAME";
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                } else if (eventName.indexOf("Y.Y1") != -1) {
                    String name = "Y_NAME";
                    ies.setCustomName(name);
                    ies.setInitialEvent(true);
                }
            } else {
                ies.setInitialEvent(false);
            }
            return ies;
        }
        catch (Exception e) {
            e.printStackTrace();
            ies.setInitialEvent(false);
            return ies;
        }
    }
}

