/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.junit.wrapper;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JunitWrapperTest
extends AbstractSleeTCKTest {
    protected FutureResult result;
    private TCKActivityID tckActivityID = null;
    private String activityName = null;
    private final String defaultFileName = "junit-test.xml";
    private final String propsFileName = "test.properties";
    private final String FAILURE = "FAILED";
    private final String PASS = "PASSED";
    private final String ERROR = "ERROR";

    public void setUp() throws Exception {
        super.setUp();
        this.getLog().info("\n========================\nConnecting to resource\n========================\n");
        TestResourceListenerImpl resourceListener = new TestResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
    }

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.activityName = this.utils().getTestParams().getProperty("activityName");
        String home = System.getProperty("MOBICENTS_HOME");
        if (home == null) {
            result.setError("ENV variable MOBIENTS_HOME cant be null, how You even managed to get this far?");
        }
        InputStream IS = ((Object)((Object)this)).getClass().getResourceAsStream("test.properties");
        String fileNameToRead = null;
        if (IS == null) {
            fileNameToRead = "junit-test.xml";
        } else {
            Properties props = new Properties();
            try {
                props.load(IS);
                fileNameToRead = props.getProperty("org.mobicents.sleetests.cache.junit.Test_Result_File");
                if (fileNameToRead == null) {
                    fileNameToRead = "junit-test.xml";
                }
            }
            catch (IOException e) {
                fileNameToRead = "junit-test.xml";
            }
        }
        String fileURL = home + "/" + fileNameToRead;
        File file = new File(fileURL);
        Document xmlDocument = null;
        ArrayList<ResultHolder> results = new ArrayList<ResultHolder>();
        int failed = 0;
        int errors = 0;
        int passed = 0;
        int totalTests = 0;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            BufferedInputStream docIS = new BufferedInputStream(new FileInputStream(file));
            xmlDocument = builder.parse(docIS);
            NodeList nlist = xmlDocument.getDocumentElement().getElementsByTagName("testcase");
            this.getLog().info("TOTAL TESTS[" + nlist.getLength() + "]");
            totalTests = nlist.getLength();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node node = nlist.item(i);
                ResultHolder holder = new ResultHolder();
                if (node.getChildNodes().getLength() > 0) {
                    for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                        if (node.getChildNodes().item(j).getNodeName().equals("failure")) {
                            ++failed;
                            holder.result = "FAILED";
                            holder.message = node.getChildNodes().item(j).getNodeValue();
                            continue;
                        }
                        if (!node.getChildNodes().item(j).getNodeName().equals("error")) continue;
                        ++errors;
                        holder.result = "ERROR";
                        holder.message = node.getChildNodes().item(j).getNodeValue();
                    }
                }
                holder.testClassName = node.getAttributes().getNamedItem("classname").getNodeValue();
                holder.testName = node.getAttributes().getNamedItem("name").getNodeValue();
                results.add(holder);
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        passed = totalTests - errors - failed;
        Iterator it = results.iterator();
        StringBuffer sb = new StringBuffer(1000);
        sb.append("\n");
        sb.append("=====================================================================================\n");
        sb.append("| TOTAL TESTS: " + totalTests + " |PASSED: " + passed + " |FAILED: " + failed + " |ERRORS: " + errors + "\n");
        sb.append("=====================================================================================\n");
        while (it.hasNext()) {
            ResultHolder holder = (ResultHolder)it.next();
            sb.append("\n***********");
            sb.append("| TESTCLASS: " + holder.testClassName + " \n|TEST: " + holder.testName + " \n|RESULT: " + holder.result + " \n|MESSAGE: " + holder.message + "");
            sb.append("\n***********");
        }
        sb.append("\n");
        sb.append("=====================================================================================\n");
        if (errors > 0) {
            result.setError(sb.toString());
        } else if (failed > 0) {
            result.setFailed(0, sb.toString());
        } else {
            this.getLog().info(sb.toString());
            result.setPassed();
        }
    }

    class ResultHolder {
        String testClassName = null;
        String testName = null;
        String result = "PASSED";
        String message = null;

        ResultHolder() {
        }
    }

    private class TestResourceListenerImpl
    extends BaseTCKResourceListener {
        private TestResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            JunitWrapperTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                JunitWrapperTest.this.result.setPassed();
            } else {
                JunitWrapperTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            JunitWrapperTest.this.getLog().warning("Received exception from SBB or resource:");
            JunitWrapperTest.this.getLog().warning((Throwable)exception);
            JunitWrapperTest.this.result.setError((Throwable)exception);
        }
    }
}

