/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.runtime.facilities.timerfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class HandleAndSetTimerTest
extends AbstractSleeTCKTest {
    private static final int TEST_ID = 1;
    private FutureResult result;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String activityName = this.utils().getTestParams().getProperty("activityName");
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils().getLog().fine("Firing TCKResourceEventX.X1 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", (Object)"com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        result.waitForResultOrFail(60000L, "Timeout waiting for SBB to receive ActivityEndEvent", 1);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        TCKResourceListenerImpl resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
        this.setupService("serviceDUPath", true);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            HandleAndSetTimerTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                HandleAndSetTimerTest.this.result.setPassed();
            } else {
                HandleAndSetTimerTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            HandleAndSetTimerTest.this.getLog().warning("Received exception from SBB or resource:");
            HandleAndSetTimerTest.this.getLog().warning((Throwable)exception);
            HandleAndSetTimerTest.this.result.setError((Throwable)exception);
        }
    }
}

