/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.sbb.events;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class RootChildBlockingTest
extends AbstractSleeTCKTest {
    private FutureResult result;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String activityName = this.utils().getTestParams().getProperty("activityName");
        TCKActivityID activityID = resource.createActivity(activityName);
        int time_to_wait = Integer.parseInt(this.utils().getTestParams().getProperty("time_to_wait"));
        this.utils().getLog().fine("Firing TCKResourceEventX.X1 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", (Object)"com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        this.utils().getLog().fine("Sleeping for " + time_to_wait + " ms");
        Thread.sleep(time_to_wait);
        this.utils().getLog().fine("Firing TCKResourceEventX.X2 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", (Object)"com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        TCKResourceListenerImpl resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
        this.setupService("serviceDUPath", true);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            RootChildBlockingTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                RootChildBlockingTest.this.result.setPassed();
            } else {
                RootChildBlockingTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            RootChildBlockingTest.this.getLog().warning("Received exception from SBB or resource:");
            RootChildBlockingTest.this.getLog().warning((Throwable)exception);
            RootChildBlockingTest.this.result.setError((Throwable)exception);
        }
    }
}

