/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sleetests.sleeservice.RemoteAccess;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceEventImpl;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.connection.SleeConnection;
import org.mobicents.slee.connector.server.RemoteSleeService;

public class RemoteAccessTest
extends AbstractSleeTCKTest {
    protected static Logger logger = Logger.getLogger(RemoteAccessTest.class.toString());
    protected FutureResult result;
    private TCKActivityID tckActivityID = null;
    private String activityName = null;
    private SleeConnection connection = null;
    private RemoteSleeService service = null;
    private String eventName = "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1";
    private String eventVendor = "jain.slee.tck";
    private String eventVersion = "1.0";

    public void setUp() throws Exception {
        super.setUp();
        this.getLog().info("\n========================\nConnecting to resource\n========================\n");
        TestResourceListenerImpl resourceListener = new TestResourceListenerImpl();
        this.setResourceListener((TCKResourceListener)resourceListener);
    }

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.activityName = this.utils().getTestParams().getProperty("activityName");
        this.tckActivityID = resource.createActivity(this.activityName);
        this.getLog().info("  == PREpARING TO LOOKUP SERVICE FROM JNDI  ==");
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            String tmpIP = "127.0.0.1";
            properties.put("java.naming.provider.url", "jnp://" + tmpIP + ":1099");
            InitialContext ctx = new InitialContext(properties);
            this.getLog().info("  == LOOKING UP  ==");
            this.service = (RemoteSleeService)ctx.lookup("/SleeService");
            if (this.service == null) {
                result.setError(" == LookedUp Serice == null!!! ==");
            }
            this.getLog().info("  == LOOKED UP  ==");
        }
        catch (NamingException ne) {
            result.setError((Throwable)ne);
            ne.printStackTrace();
        }
        catch (Exception E) {
            result.setError((Throwable)E);
            E.printStackTrace();
        }
        if (this.service != null) {
            try {
                this.getLog().info("  == RETRIEVEING EventTypeID  ==");
                EventTypeID requestType = this.service.getEventTypeID(this.eventName, this.eventVendor, this.eventVersion);
                if (requestType == null) {
                    result.setError(" == EventTypeID == null!! ==");
                }
                this.getLog().info("  == RETRIEVAL SUCCESSFUL:" + requestType + "  ==");
                this.getLog().info("  == RETRIEVING ExternalActivityHandle  ==");
                ExternalActivityHandle handle = this.service.createActivityHandle();
                if (handle == null) {
                    result.setError(" == ExternalActivityHandle == null!! ==");
                }
                this.getLog().info("  == RETRIEVAL SUCCESSFUL:" + handle + "  ==");
                TCKResourceEventImpl xEvent = new TCKResourceEventImpl(12L, "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", (Object)"SLEE SERVICE TEST", null);
                this.getLog().info("  == FIRING EVENT:" + xEvent + "  ==");
                this.service.fireEvent((Object)xEvent, requestType, handle, null);
                this.getLog().info("  == EVENT FIRED, WAITING FOR TestSbb TO RECEIVE IT  ==");
            }
            catch (RemoteException RE) {
                result.setError((Throwable)RE);
                RE.printStackTrace();
            }
        }
    }

    private class TestResourceListenerImpl
    extends BaseTCKResourceListener {
        private TestResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            Boolean sbbPassed = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            RemoteAccessTest.this.getLog().info("Received message from SBB: passed=" + sbbPassed + ", message=" + sbbTestMessage);
            if (sbbPassed.booleanValue()) {
                RemoteAccessTest.this.result.setPassed();
            } else {
                RemoteAccessTest.this.result.setFailed(0, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            RemoteAccessTest.this.getLog().warning("Received exception from SBB or resource:");
            RemoteAccessTest.this.getLog().warning((Throwable)exception);
            RemoteAccessTest.this.result.setError((Throwable)exception);
        }
    }
}

