/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.connector.proxy;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.connection.SleeConnection;
import javax.slee.connection.SleeConnectionFactory;
import org.apache.log4j.Logger;

public abstract class SleeConnectionProxyBean
implements SessionBean {
    private String jndiSleeConnectionFactoryPath = "java:MobicentsConnectionFactory";
    private String propsFileName = "ejbconnection-proxy.properties";
    private transient SleeConnection connection = null;
    private transient SleeConnectionFactory connectionFactory = null;
    private String componentID = "";
    private static transient Logger logger = Logger.getLogger((Class)SleeConnectionProxyBean.class);
    private SessionContext ctx = null;

    public SleeConnectionProxyBean() {
        logger.debug((Object)"METHOD: [ SleeConnectionProxyBean() ]");
        try {
            this.connectionFactory = this.lookupFactory();
            this.connection = this.connectionFactory.getConnection();
            this.componentID = "SleeConnectionProxyEJB:[ " + Math.random() * 10000.0 + " ]";
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
    }

    private Properties readProps() {
        Properties returnprops = new Properties();
        Properties fileProps = new Properties();
        boolean exceptionCaught = false;
        URL url = this.getClass().getResource(this.propsFileName);
        try {
            Class<?> thisCLS = this.getClass();
            InputStream IS = this.getClass().getResourceAsStream(this.propsFileName);
            fileProps.load(IS);
            returnprops.put("java.naming.factory.initial", fileProps.getProperty("InitialContext.INITIAL_CONTEXT_FACTORY", "org.jnp.interfaces.NamingContextFactory"));
            returnprops.put("java.naming.provider.url", fileProps.getProperty("InitialContext.PROVIDER_URL", "jnp://127.0.0.1:1099"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnprops;
    }

    private SleeConnectionFactory lookupFactory() {
        SleeConnectionFactory factory = null;
        Properties props = this.readProps();
        try {
            InitialContext ctx = null;
            ctx = props == null ? new InitialContext() : new InitialContext(props);
            factory = (SleeConnectionFactory)ctx.lookup(this.jndiSleeConnectionFactoryPath);
            ctx.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return factory;
    }

    public ExternalActivityHandle createActivityHandle() throws ResourceException {
        logger.debug((Object)("COMPONENT:[ " + this.componentID + " ] METHOD: [ public javax.slee.connection.ExternalActivityHandle createActivityHandle() ]"));
        return this.connection.createActivityHandle();
    }

    public EventTypeID getEventTypeID(String eventName, String eventVendor, String eventVersion) throws UnrecognizedEventException, ResourceException {
        logger.debug((Object)("COMPONENT:[ " + this.componentID + " ] METHOD: [ getEventTypeID(...) ]"));
        return this.connection.getEventTypeID(eventName, eventVendor, eventVersion);
    }

    public void fireEvent(Object event, EventTypeID eventTypeID, ExternalActivityHandle externalActivityHandle, Address address) throws NullPointerException, UnrecognizedActivityException, UnrecognizedEventException, ResourceException {
        logger.debug((Object)("COMPONENT:[ " + this.componentID + " ] METHOD: [ fireEvent ]"));
        this.connection.fireEvent(event, eventTypeID, externalActivityHandle, address);
    }

    public void close() throws ResourceException {
        logger.debug((Object)("COMPONENT:[ " + this.componentID + " ] METHOD: [ close() ]"));
        this.connection.close();
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() {
        try {
            logger.debug((Object)("COMPONENT:[ " + this.componentID + " ] ACTIVATING"));
            this.connectionFactory = this.lookupFactory();
            this.connection = this.connectionFactory.getConnection();
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
    }

    public void ejbPassivate() {
        try {
            logger.debug((Object)("COMPONENT:[ " + this.componentID + " ] PASIVATING"));
            this.connection.close();
        }
        catch (ResourceException RE) {
            RE.printStackTrace();
        }
        this.connection = null;
        this.connectionFactory = null;
    }

    public void setSessionContext(SessionContext ctx) {
        this.ctx = ctx;
    }
}

