/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.connector.server;

import EDU.oswego.cs.dl.util.concurrent.ThreadedExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.nullactivity.NullActivityFactory;
import org.jboss.logging.Logger;
import org.mobicents.slee.connector.server.ActivityHandleImpl;
import org.mobicents.slee.connector.server.EventInvocation;
import org.mobicents.slee.connector.server.RemoteSleeService;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.EventLookup;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.SleeInternalEndpoint;
import org.mobicents.slee.runtime.facilities.NullActivityFactoryImpl;
import org.mobicents.slee.runtime.facilities.NullActivityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class RemoteSleeServiceImpl
implements RemoteSleeService {
    private NullActivityFactory naf;
    private ActivityContextFactory acf;
    private SleeInternalEndpoint endpoint;
    private EventLookup eventLookup;
    private static Logger log = Logger.getLogger((Class)RemoteSleeServiceImpl.class);

    public RemoteSleeServiceImpl(NullActivityFactory naf, SleeInternalEndpoint endpoint, EventLookup eventLookup, ActivityContextFactory acf) {
        log.debug((Object)"Creating RemoteSleeServiceImpl");
        this.naf = naf;
        this.endpoint = endpoint;
        this.eventLookup = eventLookup;
        this.acf = acf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalActivityHandle createActivityHandle() {
        log.debug((Object)"createActivityHandle() called current ");
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        boolean b = false;
        try {
            b = txmgr.requireTransaction();
            NullActivityImpl na = (NullActivityImpl)((NullActivityFactoryImpl)this.naf).createNullActivityNoTx();
            ActivityContext ac = this.acf.getActivityContext(na);
            ActivityHandleImpl activityHandleImpl = new ActivityHandleImpl(ac.getActivityContextId());
            return activityHandleImpl;
        }
        catch (Exception ex) {
            try {
                if (b) {
                    txmgr.setRollbackOnly();
                }
            }
            catch (Exception e) {
                log.error((Object)"createActivityHandle(): exception occured", (Throwable)ex);
            }
            ExternalActivityHandle externalActivityHandle = null;
            return externalActivityHandle;
        }
        finally {
            try {
                if (b) {
                    txmgr.commit();
                }
            }
            catch (Exception ex) {
                log.error((Object)"createActivityHandle(): exception occured", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address) {
        if (event == null) {
            throw new NullPointerException("event is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is null");
        }
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        boolean b = false;
        try {
            log.debug((Object)("fireEvent() called " + txmgr.isInTx()));
            if (!txmgr.isInTx()) {
                txmgr.begin();
            }
            NullActivityImpl na = null;
            if (activityHandle != null) {
                ActivityHandleImpl handle = (ActivityHandleImpl)activityHandle;
                ActivityContext ac = this.acf.getActivityContextById(handle.getKey());
                if (ac == null) {
                    log.error((Object)"Invalid activity handle!");
                    return;
                }
                na = (NullActivityImpl)ac.getActivity();
            } else {
                log.debug((Object)"Creating new null activity");
                na = (NullActivityImpl)((NullActivityFactoryImpl)this.naf).createNullActivityNoTx();
            }
            this.endpoint.enqueueEvent(eventType, event, (Object)na, address);
            log.debug((Object)"Queued event");
        }
        catch (Exception ex) {
            try {
                if (txmgr.isInTx()) {
                    txmgr.setRollbackOnly();
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception committing tx", (Throwable)e);
            }
            log.error((Object)"Exception in fireEvent!", (Throwable)ex);
        }
        finally {
            try {
                if (txmgr.isInTx()) {
                    txmgr.commit();
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception committing tx", (Throwable)e);
            }
        }
    }

    public void fireEventQueue(ArrayList queue) {
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        try {
            log.debug((Object)"fireEventQueue() called");
            DeferredFireEventAction daf = new DeferredFireEventAction(queue);
            new ThreadedExecutor().execute((Runnable)daf);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected error", ex);
        }
    }

    public EventTypeID getEventTypeID(String name, String vendor, String version) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (vendor == null) {
            throw new NullPointerException("vendor is null");
        }
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        log.debug((Object)"getEventTypeID() called");
        int eventId = this.eventLookup.getEventID(name, vendor, version);
        log.debug((Object)("eventId is:" + eventId));
        if (eventId == -1) {
            return null;
        }
        EventTypeID eventTypeID = this.eventLookup.getEventTypeID(eventId);
        log.debug((Object)("Event type id is:" + eventTypeID));
        return eventTypeID;
    }

    class DeferredFireEventAction
    implements Runnable {
        ArrayList eventList;

        public DeferredFireEventAction(ArrayList alist) {
            this.eventList = new ArrayList(alist);
        }

        public void run() {
            log.debug((Object)"afterCompletion called -- fireEventQueue Again!");
            Iterator iter = this.eventList.iterator();
            while (iter.hasNext()) {
                EventInvocation ei = (EventInvocation)iter.next();
                RemoteSleeServiceImpl.this.fireEvent(ei.event, ei.eventTypeId, ei.externalActivityHandle, ei.address);
            }
        }
    }
}

